/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.netbeans.modules.visualweb.api.insync.InSyncService;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.SourceUnit;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

public class UndoEvent
implements InSyncService.WriteLock {
    private String description;
    private ArrayList modifiedUnits;
    private Model model;

    public Model getModel() {
        return this.model;
    }

    public UndoEvent(String string, Model model) {
        this.description = string;
        this.model = model;
    }

    public void notifyBufferUpdated(SourceUnit sourceUnit) {
        if (this.modifiedUnits == null) {
            this.modifiedUnits = new ArrayList(3);
        }
        this.modifiedUnits.add(sourceUnit);
    }

    public void undo() {
        if (this.modifiedUnits == null) {
            return;
        }
        for (SourceUnit sourceUnit : this.modifiedUnits) {
            CloneableEditorSupport cloneableEditorSupport;
            UndoRedo undoRedo;
            DataObject dataObject = sourceUnit.getDataObject();
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (!(editorCookie instanceof CloneableEditorSupport) || (undoRedo = UndoEvent.getUndoRedo(cloneableEditorSupport = (CloneableEditorSupport)editorCookie)) == null) continue;
            undoRedo.undo();
        }
    }

    public boolean hasChanges() {
        return this.modifiedUnits != null && this.modifiedUnits.size() > 0;
    }

    public void redo() {
        if (this.modifiedUnits == null) {
            return;
        }
        for (SourceUnit sourceUnit : this.modifiedUnits) {
            CloneableEditorSupport cloneableEditorSupport;
            UndoRedo undoRedo;
            DataObject dataObject = sourceUnit.getDataObject();
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (!(editorCookie instanceof CloneableEditorSupport) || (undoRedo = UndoEvent.getUndoRedo(cloneableEditorSupport = (CloneableEditorSupport)editorCookie)) == null) continue;
            undoRedo.redo();
        }
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public String toString() {
        return this.getDescription();
    }

    private static UndoRedo getUndoRedo(CloneableEditorSupport cloneableEditorSupport) {
        try {
            Method method = CloneableEditorSupport.class.getDeclaredMethod("getUndoRedo", new Class[0]);
            method.setAccessible(true);
            try {
                return (UndoRedo)method.invoke((Object)cloneableEditorSupport, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
            }
        }
        catch (SecurityException securityException) {
            ErrorManager.getDefault().notify(1, (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify(1, (Throwable)noSuchMethodException);
        }
        return null;
    }
}

