/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.Description;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ManagedBeanIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient boolean debug = false;

    public void initialize(TemplateWizard templateWizard) {
        if (this.debug) {
            this.log("initialize");
        }
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        DataFolder dataFolder = null;
        try {
            dataFolder = templateWizard.getTargetFolder();
        }
        catch (IOException iOException) {
            dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (this.debug) {
            this.log("\tproject: " + project);
            this.log("\ttargetFolder: " + dataFolder);
            this.log("\tsourceGroups.length: " + sourceGroupArray.length);
        }
        ManagedBeanPanel managedBeanPanel = new ManagedBeanPanel(project, (WizardDescriptor)templateWizard);
        WizardDescriptor.Panel panel = sourceGroupArray.length == 0 ? Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)managedBeanPanel) : JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroupArray, (WizardDescriptor.Panel)managedBeanPanel);
        this.panels = new WizardDescriptor.Panel[]{panel};
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jComponent = (JComponent)this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = jComponent.getName();
            }
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        if (this.debug) {
            this.log("instantiate");
        }
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)templateWizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)templateWizard));
        String string = (String)templateWizard.getProperty("ConfigFile");
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        fileObject = webModule.getDocumentBase();
        FileObject fileObject3 = fileObject.getFileObject(string);
        FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObject3, true).getRootComponent();
        ManagedBean managedBean = facesConfig.getModel().getFactory().createManagedBean();
        String string2 = Templates.getTargetName((WizardDescriptor)templateWizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        String string3 = null;
        FileObject fileObject4 = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        for (int i = 0; i < sourceGroupArray.length && string3 == null && (string3 = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject4)) == null; ++i) {
        }
        string3 = string3 != null ? string3.replace('/', '.') : "";
        String string4 = null;
        string4 = string3.length() > 0 ? string3 + "." + string2 : string2;
        managedBean.setManagedBeanName(this.getUniqueName(string2, facesConfig));
        managedBean.setManagedBeanClass(string4);
        managedBean.setManagedBeanScope((ManagedBean.Scope)((Object)templateWizard.getProperty("Scope")));
        String string5 = (String)templateWizard.getProperty("Description");
        if (string5 != null && string5.length() > 0) {
            String string6 = System.getProperty("line.separator");
            Description description = managedBean.getModel().getFactory().createDescription();
            description.setValue(string6 + string5 + string6);
            managedBean.addDescription(description);
        }
        facesConfig.getModel().startTransaction();
        facesConfig.addManagedBean(managedBean);
        facesConfig.getModel().endTransaction();
        facesConfig.getModel().sync();
        return Collections.singleton(dataObject2);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public String name() {
        return NbBundle.getMessage(ManagedBeanIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private void log(String string) {
        System.out.println("ActionIterator:: \t" + string);
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    private void replaceInDocument(Document document, String string, String string2) {
        AbstractDocument abstractDocument = (AbstractDocument)document;
        int n = string.length();
        try {
            String string3 = abstractDocument.getText(0, abstractDocument.getLength());
            int n2 = string3.lastIndexOf(string);
            while (n2 >= 0) {
                abstractDocument.replace(n2, n, string2, null);
                string3 = string3.substring(0, n2);
                n2 = string3.lastIndexOf(string);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String getUniqueName(String string, FacesConfig facesConfig) {
        String string2 = string;
        List<ManagedBean> list = facesConfig.getManagedBeans();
        int n = 0;
        for (ManagedBean managedBean : list) {
            if (!string2.equals(managedBean.getManagedBeanName())) {
                ++this.index;
                continue;
            }
            this.index = 0;
            string2 = string + ++n;
        }
        return string2;
    }
}

