/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanel;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JSFConfigurationPanelVisual
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private JSFConfigurationPanel panel;
    private boolean customizer;
    private final List<LibraryItem> jsfLibraries = new ArrayList<LibraryItem>();
    private boolean libsInitialized;
    private boolean webModule25Version;
    private String serverInstanceID;
    private ButtonGroup buttonGroup1;
    private JComboBox cbLibraries;
    private JCheckBox cbPackageJars;
    private JCheckBox cbValidate;
    private JCheckBox cbVerify;
    private JPanel confPanel;
    private JButton jbBrowse;
    private JTabbedPane jsfTabbedPane;
    private JTextField jtFolder;
    private JTextField jtNewLibraryName;
    private JLabel lDirectory;
    private JLabel lServletName;
    private JLabel lURLPattern;
    private JLabel lVersion;
    private JPanel libPanel;
    private JRadioButton rbNewLibrary;
    private JRadioButton rbNoneLibrary;
    private JRadioButton rbRegisteredLibrary;
    private JTextField tServletName;
    private JTextField tURLPattern;
    private static final char[] INVALID_PATTERN_CHARS = new char[]{'%', '+'};
    private static final Pattern VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");

    public JSFConfigurationPanelVisual(JSFConfigurationPanel jSFConfigurationPanel, boolean bl) {
        this.panel = jSFConfigurationPanel;
        this.customizer = bl;
        this.initComponents();
        this.tURLPattern.getDocument().addDocumentListener(this);
        this.cbPackageJars.setVisible(false);
    }

    public void addNotify() {
        super.addNotify();
        this.initLibraries();
        if (this.customizer) {
            this.enableComponents(false);
        } else {
            this.updateLibrary();
        }
    }

    private void initLibraries() {
        if (this.libsInitialized) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        this.jsfLibraries.clear();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!"j2se".equals(library.getType())) continue;
            List list = library.getContent("classpath");
            try {
                if (!Util.containsClass((List)list, (String)"javax.faces.FacesException")) continue;
                vector.add(library.getDisplayName());
                boolean bl = Util.containsClass((List)list, (String)"javax.faces.application.StateManagerWrapper");
                if (bl) {
                    this.jsfLibraries.add(new LibraryItem(library, JSFVersion.JSF_1_2));
                    continue;
                }
                this.jsfLibraries.add(new LibraryItem(library, JSFVersion.JSF_1_1));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        this.cbLibraries.setModel(new DefaultComboBoxModel(vector));
        if (vector.size() == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
            this.cbLibraries.setEnabled(false);
            this.rbNewLibrary.setSelected(true);
            this.panel.setLibrary(null);
        } else {
            this.rbRegisteredLibrary.setEnabled(true);
            this.rbRegisteredLibrary.setSelected(true);
            this.cbLibraries.setEnabled(true);
        }
        this.libsInitialized = true;
        this.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jsfTabbedPane = new JTabbedPane();
        this.confPanel = new JPanel();
        this.lServletName = new JLabel();
        this.tServletName = new JTextField();
        this.lURLPattern = new JLabel();
        this.tURLPattern = new JTextField();
        this.cbValidate = new JCheckBox();
        this.cbVerify = new JCheckBox();
        this.cbPackageJars = new JCheckBox();
        this.libPanel = new JPanel();
        this.rbRegisteredLibrary = new JRadioButton();
        this.cbLibraries = new JComboBox();
        this.rbNewLibrary = new JRadioButton();
        this.lDirectory = new JLabel();
        this.jtFolder = new JTextField();
        this.jbBrowse = new JButton();
        this.lVersion = new JLabel();
        this.jtNewLibraryName = new JTextField();
        this.rbNoneLibrary = new JRadioButton();
        this.setLayout(new CardLayout());
        this.lServletName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lServletName").charAt(0));
        this.lServletName.setLabelFor(this.tServletName);
        this.lServletName.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_Servlet_Name"));
        this.tServletName.setEditable(false);
        this.tServletName.setText("Faces Servlet");
        this.lURLPattern.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lURLPattern").charAt(0));
        this.lURLPattern.setLabelFor(this.tURLPattern);
        this.lURLPattern.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_URL_Pattern"));
        this.tURLPattern.setText("/faces/*");
        this.cbValidate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_cbValidate").charAt(0));
        this.cbValidate.setSelected(true);
        this.cbValidate.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Validate_XML"));
        this.cbValidate.setMargin(new Insets(0, 0, 0, 0));
        this.cbVerify.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_cbVerify").charAt(0));
        this.cbVerify.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Verify_Objects"));
        this.cbVerify.setMargin(new Insets(0, 0, 0, 0));
        this.cbPackageJars.setSelected(true);
        this.cbPackageJars.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Package_JARs"));
        this.cbPackageJars.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this.confPanel);
        this.confPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.cbPackageJars)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lURLPattern).add((Component)this.cbValidate))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((Component)this.lServletName))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tServletName, -1, 361, Short.MAX_VALUE).add((Component)this.cbVerify).add((Component)this.tURLPattern, -1, 361, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lServletName).add((Component)this.tServletName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lURLPattern).add((Component)this.tURLPattern, -2, -1, -2)).add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbValidate).add((Component)this.cbVerify)).addPreferredGap(0).add((Component)this.cbPackageJars).addContainerGap()));
        this.tServletName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_ServletName"));
        this.tURLPattern.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_Mapping"));
        this.cbValidate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_ValidateXML"));
        this.cbVerify.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_VerifyObjects"));
        this.cbPackageJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_PackageJarToWar"));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Configuration"), this.confPanel);
        this.libPanel.setAlignmentX(0.2f);
        this.libPanel.setAlignmentY(0.2f);
        this.buttonGroup1.add(this.rbRegisteredLibrary);
        this.rbRegisteredLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbRegLibs").charAt(0));
        this.rbRegisteredLibrary.setSelected(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.rbRegisteredLibrary.setText(resourceBundle.getString("LBL_REGISTERED_LIBRARIES"));
        this.rbRegisteredLibrary.setMargin(new Insets(0, 0, 0, 0));
        this.rbRegisteredLibrary.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JSFConfigurationPanelVisual.this.rbRegisteredLibraryItemStateChanged(itemEvent);
            }
        });
        this.cbLibraries.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbLibraries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSFConfigurationPanelVisual.this.cbLibrariesActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.rbNewLibrary);
        this.rbNewLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbCrNewLib").charAt(0));
        this.rbNewLibrary.setText(resourceBundle.getString("LBL_CREATE_NEW_LIBRARY"));
        this.rbNewLibrary.setToolTipText(resourceBundle.getString("MSG_CreatingLibraries"));
        this.rbNewLibrary.setMargin(new Insets(0, 0, 0, 0));
        this.rbNewLibrary.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JSFConfigurationPanelVisual.this.rbNewLibraryItemStateChanged(itemEvent);
            }
        });
        this.lDirectory.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lJSFDir").charAt(0));
        this.lDirectory.setLabelFor(this.jtFolder);
        this.lDirectory.setText(resourceBundle.getString("LBL_INSTALL_DIR"));
        this.lDirectory.setToolTipText(resourceBundle.getString("HINT_JSF_Directory"));
        this.jtFolder.setToolTipText(resourceBundle.getString("HINT_JSF_Directory"));
        this.jtFolder.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JSFConfigurationPanelVisual.this.jtFolderKeyPressed(keyEvent);
            }
        });
        this.jbBrowse.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Browse").charAt(0));
        this.jbBrowse.setText(resourceBundle.getString("LBL_Browse"));
        this.jbBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSFConfigurationPanelVisual.this.jbBrowseActionPerformed(actionEvent);
            }
        });
        this.lVersion.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lJSFVer").charAt(0));
        this.lVersion.setLabelFor(this.jtNewLibraryName);
        this.lVersion.setText(resourceBundle.getString("LBL_VERSION"));
        this.lVersion.setToolTipText(resourceBundle.getString("HINT_Version"));
        this.jtNewLibraryName.setToolTipText(resourceBundle.getString("HINT_Version"));
        this.jtNewLibraryName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JSFConfigurationPanelVisual.this.jtNewLibraryNameKeyReleased(keyEvent);
            }
        });
        this.buttonGroup1.add(this.rbNoneLibrary);
        this.rbNoneLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbNoAppend").charAt(0));
        this.rbNoneLibrary.setText(resourceBundle.getString("LBL_Any_Library"));
        this.rbNoneLibrary.setMargin(new Insets(0, 0, 0, 0));
        this.rbNoneLibrary.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JSFConfigurationPanelVisual.this.rbNoneLibraryItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.libPanel);
        this.libPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.rbRegisteredLibrary).addPreferredGap(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.cbLibraries, 0, 338, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.jtNewLibraryName, -1, 244, Short.MAX_VALUE).add((Component)this.jtFolder, -1, 244, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jbBrowse)))).add(2, (Component)this.rbNewLibrary, -1, 491, Short.MAX_VALUE).add((Component)this.rbNoneLibrary, -1, 491, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(22, 22, 22).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.lVersion, -1, 469, Short.MAX_VALUE).add((Component)this.lDirectory, -1, 469, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.rbRegisteredLibrary).add((Component)this.cbLibraries, -2, -1, -2)).add(1, 1, 1).add((Component)this.rbNewLibrary).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jbBrowse).add((Component)this.jtFolder, -2, -1, -2).add((Component)this.lDirectory)).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jtNewLibraryName, -2, -1, -2).add((Component)this.lVersion)).add(1, 1, 1).add((Component)this.rbNoneLibrary).addContainerGap()));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Libraries"), this.libPanel);
        this.add((Component)this.jsfTabbedPane, "card10");
        this.jsfTabbedPane.getAccessibleContext().setAccessibleName("");
    }

    private void rbNoneLibraryItemStateChanged(ItemEvent itemEvent) {
        this.updateLibrary();
        if (this.rbNoneLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void jtNewLibraryNameKeyReleased(KeyEvent keyEvent) {
        this.panel.setNewLibraryName(this.jtNewLibraryName.getText().trim());
    }

    private void rbNewLibraryItemStateChanged(ItemEvent itemEvent) {
        this.updateLibrary();
        if (this.rbNewLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void cbLibrariesActionPerformed(ActionEvent actionEvent) {
        this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
    }

    private void rbRegisteredLibraryItemStateChanged(ItemEvent itemEvent) {
        this.updateLibrary();
        if (this.rbRegisteredLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void jbBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_SelectLibraryLocation"));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setCurrentDirectory(new File(this.jtFolder.getText().trim()));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = jFileChooser.getSelectedFile();
            this.jtFolder.setText(file.getAbsolutePath());
            this.setNewLibraryFolder();
        }
    }

    private void jtFolderKeyPressed(KeyEvent keyEvent) {
        this.setNewLibraryFolder();
    }

    void enableComponents(boolean bl) {
        int n;
        Component[] componentArray = this.confPanel.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            componentArray[n].setEnabled(bl);
        }
        componentArray = this.libPanel.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            componentArray[n].setEnabled(bl);
        }
    }

    boolean valid() {
        String string;
        Object object;
        Object object2;
        ExtenderController extenderController = this.panel.getController();
        String string2 = this.tURLPattern.getText();
        if (string2 == null || string2.trim().equals("")) {
            extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsEmpty"));
            return false;
        }
        if (!this.isPatternValid(string2)) {
            extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsNotValid"));
            return false;
        }
        if (!this.customizer) {
            object2 = extenderController.getProperties();
            object = (String)object2.getProperty("j2eeLevel");
            string = (String)object2.getProperty("serverInstanceID");
            if (object != null && string != null) {
                boolean bl = object.equals("1.5");
                if (!string.equals(this.serverInstanceID) || bl != this.webModule25Version) {
                    this.webModule25Version = bl;
                    this.serverInstanceID = string;
                    this.initLibSettings(this.webModule25Version, this.serverInstanceID);
                }
            }
        }
        if (this.rbRegisteredLibrary.isSelected()) {
            if (this.cbLibraries.getItemCount() <= 0) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_MissingJSF"));
                return false;
            }
            if (!this.webModule25Version) {
                if (this.jsfLibraries.size() == 0) {
                    return false;
                }
                int n = this.cbLibraries.getSelectedIndex();
                object = this.jsfLibraries.get(n).getVersion();
                if (((Enum)object).compareTo(JSFVersion.JSF_1_1) > 0) {
                    extenderController.setErrorMessage(NbBundle.getMessage(JSFUtils.class, (String)"ERROR_REQUIRED_JSF_VERSION"));
                    return false;
                }
            }
        }
        if (this.rbNewLibrary.isSelected()) {
            object2 = this.jtFolder.getText().trim();
            object = this.webModule25Version ? JSFUtils.isJSFInstallFolder(new File((String)object2), JSFVersion.JSF_1_2) : JSFUtils.isJSFInstallFolder(new File((String)object2), JSFVersion.JSF_1_1);
            if (object != null) {
                extenderController.setErrorMessage(object);
                return false;
            }
            string = this.jtNewLibraryName.getText().trim();
            if (string.length() <= 0) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_EmptyNewLibraryName"));
                return false;
            }
            object = this.checkLibraryName(string);
            if (object != null) {
                extenderController.setErrorMessage(object);
                return false;
            }
            Library library = LibraryManager.getDefault().getLibrary(string);
            if (library != null) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_AlreadyExists"));
                return false;
            }
        }
        extenderController.setErrorMessage(null);
        return true;
    }

    private boolean isPatternValid(String string) {
        Object object = INVALID_PATTERN_CHARS;
        int n = ((char[])object).length;
        for (int i = 0; i < n; ++i) {
            char c = object[i];
            if (string.indexOf(c) == -1) continue;
            return false;
        }
        if (string.startsWith("*.") && ((String)(object = (Object)string.substring(2))).indexOf(46) == -1 && ((String)object).indexOf(42) == -1 && ((String)object).indexOf(47) == -1 && !((String)object).trim().equals("")) {
            return true;
        }
        return string.length() > 3 && string.endsWith("/*") && string.startsWith("/");
    }

    void update() {
        ExtenderController.Properties properties = this.panel.getController().getProperties();
        this.webModule25Version = "1.5".equals((String)properties.getProperty("j2eeLevel"));
        this.serverInstanceID = (String)properties.getProperty("serverInstanceID");
        this.initLibSettings(this.webModule25Version, this.serverInstanceID);
    }

    private void initLibSettings(boolean bl, String string) {
        try {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
            File[] fileArray = j2eePlatform != null ? j2eePlatform.getClasspathEntries() : new File[]{};
            boolean bl2 = Util.containsClass(Arrays.asList(fileArray), (String)"javax.faces.FacesException");
            boolean bl3 = Util.containsClass(Arrays.asList(fileArray), (String)"javax.faces.application.StateManagerWrapper");
            if (bl2 && bl3 && bl || bl2 && !bl3 && !bl) {
                this.rbNoneLibrary.setSelected(true);
            } else {
                Library library = null;
                library = bl ? LibraryManager.getDefault().getLibrary(JSFUtils.DEFAULT_JSF_1_2_NAME) : LibraryManager.getDefault().getLibrary(JSFUtils.DEFAULT_JSF_1_1_NAME);
                if (library != null) {
                    this.rbRegisteredLibrary.setSelected(true);
                    this.cbLibraries.setSelectedItem(library.getDisplayName());
                } else if (this.jsfLibraries.size() == 0) {
                    this.rbNewLibrary.setSelected(true);
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSFConfigurationPanelVisual.class);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public String getServletName() {
        return this.tServletName.getText();
    }

    public void setServletName(String string) {
        this.tServletName.setText(string);
    }

    public String getURLPattern() {
        return this.tURLPattern.getText();
    }

    public void setURLPattern(String string) {
        this.tURLPattern.setText(string);
    }

    public boolean validateXML() {
        return this.cbValidate.isSelected();
    }

    public void setValidateXML(boolean bl) {
        this.cbValidate.setSelected(bl);
    }

    public boolean verifyObjects() {
        return this.cbVerify.isSelected();
    }

    public void setVerifyObjects(boolean bl) {
        this.cbVerify.setSelected(bl);
    }

    public boolean packageJars() {
        return this.cbPackageJars.isSelected();
    }

    private void updateLibrary() {
        if (this.cbLibraries.getItemCount() == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
        }
        if (this.rbNoneLibrary.isSelected()) {
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.NONE);
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbRegisteredLibrary.isSelected()) {
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(true);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.USED);
            if (this.jsfLibraries.size() > 0) {
                this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
            }
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbNewLibrary.isSelected()) {
            this.enableNewLibraryComponent(true);
            this.enableDefinedLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.NEW);
            this.setNewLibraryFolder();
        }
    }

    private void enableDefinedLibraryComponent(boolean bl) {
        this.cbLibraries.setEnabled(bl);
    }

    private void enableNewLibraryComponent(boolean bl) {
        this.lDirectory.setEnabled(bl);
        this.jtFolder.setEnabled(bl);
        this.jbBrowse.setEnabled(bl);
        this.lVersion.setEnabled(bl);
        this.jtNewLibraryName.setEnabled(bl);
    }

    private void setNewLibraryFolder() {
        String string = this.jtFolder.getText();
        if (string == null || "".equals(string)) {
            this.panel.setInstallFolder(null);
        } else {
            File file = new File(string);
            this.panel.setInstallFolder(file);
        }
    }

    private String checkLibraryName(String string) {
        String string2 = null;
        if (string.length() == 0) {
            string2 = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_InvalidLibraryName");
        } else if (!VALID_PROPERTY_NAME.matcher(string).matches()) {
            string2 = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_InvalidLibraryNameCharacters");
        }
        return string2;
    }

    private static class LibraryItem {
        private Library library;
        private JSFVersion version;

        public LibraryItem(Library library, JSFVersion jSFVersion) {
            this.library = library;
            this.version = jSFVersion;
        }

        public Library getLibrary() {
            return this.library;
        }

        public JSFVersion getVersion() {
            return this.version;
        }

        public String toString() {
            return this.library.getDisplayName();
        }
    }
}

