/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.BorderLayout;
import java.awt.Image;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.vmd.VMDConnectionWidget;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.vmd.VMDPinWidget;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.editor.JSFConfigEditorContext;
import org.netbeans.modules.web.jsf.navigation.JSFPageFlowMultiviewDescriptor;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneData;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.graph.SceneSerializer;
import org.netbeans.modules.web.jsf.navigation.graph.layout.LayoutUtility;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowView
extends TopComponent
implements Lookup.Provider {
    private JSFConfigEditorContext context;
    private PageFlowScene scene;
    private PageFlowController pfc;
    private PageFlowSceneData sceneData;
    private ThreadPoolExecutor executor;
    private static final Logger LOG = Logger.getLogger("org.netbeans.web.jsf.navigation");
    private static final String ACN_PAGEVIEW_TC = NbBundle.getMessage(PageFlowView.class, (String)"ACN_PageView_TC");
    private static final String ACDS_PAGEVIEW_TC = NbBundle.getMessage(PageFlowView.class, (String)"ACDS_PageView_TC");
    private WeakReference<Lookup> lookupWRef = new WeakReference<Object>(null);
    public int sceneAssgn = 0;
    private static final String PATH_TOOLBAR_FOLDER = "PageFlowEditor/Toolbars";
    private static final String PATH_PALETTE_FOLDER = "PageFlowEditor/Palette";
    LayoutUtility.LayoutType lastUsedLayout = LayoutUtility.LayoutType.GRID_GRAPH;
    private WeakReference<JSFPageFlowMultiviewDescriptor.PageFlowElement> multiviewRef;

    PageFlowView(JSFPageFlowMultiviewDescriptor.PageFlowElement pageFlowElement, JSFConfigEditorContext jSFConfigEditorContext) {
        this.setMultiview(pageFlowElement);
        this.context = jSFConfigEditorContext;
        this.initializeScene();
        this.pfc = new PageFlowController(jSFConfigEditorContext, this);
        this.sceneData = new PageFlowSceneData(PageFlowToolbarUtilities.getInstance(this));
        this.deserializeNodeLocation(PageFlowView.getStorageFile(jSFConfigEditorContext.getFacesConfigFile()));
        this.pfc.setupGraphNoSaveData();
        LOG.fine("Initializing Page Flow SetupGraph");
        this.setFocusable(true);
        LOG.finest("Create Executor Thread");
        this.getAccessibleContext().setAccessibleDescription(ACDS_PAGEVIEW_TC);
        this.getAccessibleContext().setAccessibleName(ACN_PAGEVIEW_TC);
    }

    public void requestMultiViewActive() {
        this.getMultiview().getMultiViewCallback().requestActive();
        this.requestFocus();
    }

    public PageFlowController getPageFlowController() {
        return this.pfc;
    }

    public Lookup getLookup() {
        Lookup lookup = (Lookup)this.lookupWRef.get();
        DataObject dataObject = null;
        if (lookup == null) {
            Lookup lookup2 = super.getLookup();
            try {
                dataObject = DataObject.find((FileObject)this.context.getFacesConfigFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            lookup = dataObject != null ? new ProxyLookup(new Lookup[]{lookup2, Lookups.fixed((Object[])new Object[]{this.getScene(), dataObject})}) : new ProxyLookup(new Lookup[]{lookup2, Lookups.fixed((Object[])new Object[]{this.getScene()})});
            this.lookupWRef = new WeakReference<Lookup>(lookup);
        }
        return lookup;
    }

    public void unregstierListeners() {
        if (this.pfc != null) {
            this.pfc.unregisterListeners();
        }
    }

    public void registerListeners() {
        if (this.pfc != null) {
            this.pfc.registerListeners();
        }
    }

    private PageFlowScene initializeScene() {
        this.setLayout(new BorderLayout());
        this.setScene(new PageFlowScene(this));
        this.getScene().setAccessibleContext(this.getAccessibleContext());
        JScrollPane jScrollPane = new JScrollPane(this.getScene().createView());
        jScrollPane.setVisible(true);
        this.add(jScrollPane, "Center");
        this.setDefaultActivatedNode();
        return this.getScene();
    }

    public void destroyScene() {
        this.clearGraph();
        this.getScene().destoryPageFlowScene();
        this.setScene(null);
        this.sceneData = null;
        this.context = null;
        this.pfc.destroy();
        this.pfc = null;
    }

    public void setDefaultActivatedNode() {
        try {
            DefaultDataNode defaultDataNode = new DefaultDataNode(DataObject.find((FileObject)this.context.getFacesConfigFile()));
            this.setActivatedNodes(new Node[]{defaultDataNode});
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            LOG.fine("WARNING: Unable to find the following DataObject: " + this.context.getFacesConfigFile());
            this.setActivatedNodes(new Node[0]);
        }
    }

    public PageFlowScene getScene() {
        return this.scene;
    }

    public void setScene(PageFlowScene pageFlowScene) {
        ++this.sceneAssgn;
        this.scene = pageFlowScene;
    }

    public void warnUserMalFormedFacesConfig() {
        this.getScene().createMalFormedWidget();
    }

    public void removeUserMalFormedFacesConfig() {
        this.getScene().removeMalFormedWidget();
    }

    public void clearGraph() {
        HashSet hashSet = new HashSet(this.getScene().getNodes());
        for (Page page : hashSet) {
            this.getScene().removeNodeWithEdges(page);
            page.destroy2();
        }
        this.getScene().validate();
    }

    public void validateGraph() {
        this.getScene().validate();
    }

    public void saveLocations() {
        this.sceneData.saveCurrentSceneData(this.getScene());
    }

    public void saveLocation(String string, String string2) {
        this.sceneData.savePageWithNewName(string, string2);
    }

    protected VMDNodeWidget createNode(Page page, String string, List<Image> list) {
        String string2 = page.getDisplayName();
        VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)this.getScene().addNode(page);
        vMDNodeWidget.setNodeProperties(page.getIcon(1), string2, string, list);
        PageFlowSceneData.PageData pageData = this.sceneData.getPageData(string2);
        if (pageData != null) {
            vMDNodeWidget.setPreferredLocation(pageData.getPoint());
            vMDNodeWidget.setMinimized(pageData.isMinimized());
        }
        this.getScene().addPin(page, new Pin(page));
        this.selectPageFlowSceneElement(page);
        return vMDNodeWidget;
    }

    private void selectPageFlowSceneElement(PageFlowSceneElement pageFlowSceneElement) {
        HashSet<PageFlowSceneElement> hashSet = new HashSet<PageFlowSceneElement>(1);
        hashSet.add(pageFlowSceneElement);
        this.getScene().setSelectedObjects(hashSet);
    }

    private void setupPinsInNode(Page page) {
        Collection<Pin> collection = page.getPinNodes();
        for (Pin pin : collection) {
            this.createPin(page, pin);
        }
    }

    protected final VMDPinWidget createPin(Page page, Pin pin) {
        VMDPinWidget vMDPinWidget = null;
        if (page != null && this.getScene().isNode(page)) {
            vMDPinWidget = (VMDPinWidget)this.getScene().addPin(page, pin);
        }
        return vMDPinWidget;
    }

    protected void createEdge(NavigationCaseEdge navigationCaseEdge, Page page, Page page2) {
        assert (page.getDisplayName() != null);
        assert (page2.getDisplayName() != null);
        VMDConnectionWidget vMDConnectionWidget = (VMDConnectionWidget)this.getScene().addEdge(navigationCaseEdge);
        this.setEdgeSourcePin(navigationCaseEdge, page);
        this.setEdgeTargePin(navigationCaseEdge, page2);
        this.selectPageFlowSceneElement(navigationCaseEdge);
    }

    public void renameEdgeWidget(NavigationCaseEdge navigationCaseEdge, String string, String string2) {
        this.getScene().renameEdgeWidget(navigationCaseEdge, string, string2);
    }

    public Pin getEdgeSourcePin(NavigationCaseEdge navigationCaseEdge) {
        return (Pin)this.getScene().getEdgeSource(navigationCaseEdge);
    }

    public void setEdgeSourcePin(NavigationCaseEdge navigationCaseEdge, Page page) {
        Pin pin = this.getScene().getDefaultPin(page);
        Collection collection = this.getScene().getPins();
        for (Pin pin2 : collection) {
            if (pin2.getFromOutcome() == null || page != pin2.getPage() || !pin2.getFromOutcome().equals(navigationCaseEdge.getFromOuctome())) continue;
            pin = pin2;
            Collection collection2 = this.getScene().findPinEdges(pin, true, false);
            for (NavigationCaseEdge navigationCaseEdge2 : collection2) {
                this.getScene().setEdgeSource(navigationCaseEdge2, this.getScene().getDefaultPin(page));
            }
        }
        this.getScene().setEdgeSource(navigationCaseEdge, pin);
    }

    private void setEdgeTargePin(NavigationCaseEdge navigationCaseEdge, Page page) {
        Pin pin = this.getScene().getDefaultPin(page);
        this.getScene().setEdgeTarget(navigationCaseEdge, pin);
    }

    public JComponent getToolbarRepresentation() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        jToolBar.addSeparator();
        PageFlowToolbarUtilities pageFlowToolbarUtilities = PageFlowToolbarUtilities.getInstance(this);
        jToolBar.add(pageFlowToolbarUtilities.createScopeComboBox());
        jToolBar.addSeparator();
        jToolBar.add(pageFlowToolbarUtilities.createLayoutButton());
        return jToolBar;
    }

    public PaletteController getPaletteController() {
        try {
            return PaletteFactory.createPalette((String)PATH_PALETTE_FOLDER, (PaletteActions)new PaletteActions(){

                public Action[] getCustomCategoryActions(Lookup lookup) {
                    return new Action[0];
                }

                public Action[] getCustomItemActions(Lookup lookup) {
                    return new Action[0];
                }

                public Action[] getCustomPaletteActions() {
                    return new Action[0];
                }

                public Action[] getImportActions() {
                    return new Action[0];
                }

                public Action getPreferredAction(Lookup lookup) {
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.getScene().getView().requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.getScene().getView().requestFocusInWindow();
    }

    public void removeEdge(NavigationCaseEdge navigationCaseEdge) {
        if (this.getScene().getEdges().contains(navigationCaseEdge)) {
            this.getScene().removeEdge(navigationCaseEdge);
        }
    }

    public void removeNodeWithEdges(Page page) {
        if (this.getScene().getNodes().contains(page)) {
            this.getScene().removeNodeWithEdges(page);
        }
    }

    public void resetNodeWidget(Page page, boolean bl) {
        if (page == null) {
            throw new RuntimeException("PageFlowEditor: Cannot set node to null");
        }
        VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)this.getScene().findWidget(page);
        page.updateNode_HACK();
        if (vMDNodeWidget != null) {
            vMDNodeWidget.setNodeProperties(page.getIcon(1), page.getDisplayName(), null, null);
            if (bl) {
                this.redrawPinsAndEdges(page);
            }
        } else {
            this.validateGraph();
            System.err.println("PageFlowCreationStack: " + this.pfc.PageFlowCreationStack);
            System.err.println("PageFlowDestroyStack: " + this.pfc.PageFlowDestroyStack);
            this.pfc.PageFlowCreationStack.clear();
            this.pfc.PageFlowDestroyStack.clear();
            System.err.println("PageNode: " + page);
            System.err.println("Here are the scene nodes: " + this.getScene().getNodes());
        }
    }

    private final void redrawPinsAndEdges(Page page) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList(this.getScene().getPins());
        for (PageFlowSceneElement pageFlowSceneElement : arrayList2) {
            if (((Pin)pageFlowSceneElement).getPage() != page) continue;
            assert (((Pin)pageFlowSceneElement).getPage().getDisplayName().equals(page.getDisplayName()));
            Collection collection = this.getScene().findPinEdges(pageFlowSceneElement, true, false);
            arrayList.addAll(collection);
            if (((Pin)pageFlowSceneElement).isDefault()) continue;
            this.getScene().removePin(pageFlowSceneElement);
        }
        if (page.isDataNode()) {
            this.setupPinsInNode(page);
        }
        for (PageFlowSceneElement pageFlowSceneElement : arrayList) {
            this.setEdgeSourcePin((NavigationCaseEdge)pageFlowSceneElement, page);
        }
    }

    public Collection<NavigationCaseEdge> getNodeEdges(Page page) {
        Collection collection = this.getScene().getEdges();
        HashSet<NavigationCaseEdge> hashSet = new HashSet<NavigationCaseEdge>();
        String string = page.getDisplayName();
        for (NavigationCaseEdge navigationCaseEdge : collection) {
            String string2 = navigationCaseEdge.getToViewId();
            String string3 = navigationCaseEdge.getFromViewId();
            if ((string2 == null || !string2.equals(string)) && (string3 == null || !string3.equals(string))) continue;
            hashSet.add(navigationCaseEdge);
        }
        return hashSet;
    }

    public static final FileObject getStorageFile(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            LOG.warning("File does not exist inside a project.  Can't solve getStorageFile().");
            System.err.println("File does not exist inside a project.  Can't solve getStorageFile().");
            return null;
        }
        FileObject fileObject2 = project.getProjectDirectory();
        FileObject fileObject3 = fileObject2.getFileObject("nbproject", null);
        if (fileObject3 == null) {
            LOG.warning("Unable to create access the follow folder: " + fileObject3);
            System.err.println("Unable to create access the follow folder:" + fileObject3);
            return null;
        }
        String string = fileObject.getName() + ".NavData";
        FileObject fileObject4 = fileObject3.getFileObject(string);
        if (fileObject4 == null) {
            try {
                fileObject4 = fileObject3.createData(string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return fileObject4;
    }

    public static final FileObject getWebFolder(FileObject fileObject) {
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            LOG.warning("This configuration file is not part of a webModule: " + fileObject);
            System.err.println("This configuration file is not part of a webModule: " + fileObject);
            return null;
        }
        FileObject fileObject2 = webModule.getDocumentBase();
        return fileObject2;
    }

    public void serializeNodeLocations(FileObject fileObject) {
        if (fileObject != null) {
            this.saveLocations();
            SceneSerializer.serialize(this.sceneData, fileObject);
        }
    }

    public void deserializeNodeLocation(FileObject fileObject) {
        if (fileObject != null && fileObject.isValid() && fileObject.getSize() > 0L) {
            SceneSerializer.deserialize(this.sceneData, fileObject);
        }
    }

    protected String preferredID() {
        return "PageFlowEditor";
    }

    public int getPersistenceType() {
        return 2;
    }

    public void layoutNodes() {
        LayoutUtility.LayoutType layoutType = null;
        switch (this.lastUsedLayout) {
            case GRID_GRAPH: {
                layoutType = LayoutUtility.LayoutType.FREE_PLACES_NODES;
                break;
            }
            case FREE_PLACES_NODES: {
                layoutType = LayoutUtility.LayoutType.GRID_GRAPH;
            }
        }
        LayoutUtility.performLayout(this.getScene(), layoutType);
        this.lastUsedLayout = layoutType;
    }

    public JSFPageFlowMultiviewDescriptor.PageFlowElement getMultiview() {
        JSFPageFlowMultiviewDescriptor.PageFlowElement pageFlowElement = null;
        if (this.multiviewRef != null) {
            pageFlowElement = (JSFPageFlowMultiviewDescriptor.PageFlowElement)this.multiviewRef.get();
        }
        return pageFlowElement;
    }

    public void setMultiview(JSFPageFlowMultiviewDescriptor.PageFlowElement pageFlowElement) {
        this.multiviewRef = new WeakReference<JSFPageFlowMultiviewDescriptor.PageFlowElement>(pageFlowElement);
    }

    static class PFVTestAccessor {
        PFVTestAccessor() {
        }

        static PageFlowScene getPageFlowScene(PageFlowView pageFlowView) throws InterruptedException {
            if (pageFlowView.getScene() == null) {
                Thread.sleep(3000L);
            }
            return pageFlowView.getScene();
        }
    }

    public final class VMDNodeWidgetListener
    implements StateModel.Listener {
        public void stateChanged() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultDataNode
    extends FilterNode {
        Node srcFolderNode;

        public DefaultDataNode(DataObject dataObject) {
            this(dataObject.getNodeDelegate());
            Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            if (project != null) {
                Sources sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
                try {
                    FileObject fileObject = sourceGroupArray != null && sourceGroupArray.length > 0 ? sourceGroupArray[0].getRootFolder() : dataObject.getFolder().getPrimaryFile();
                    this.srcFolderNode = DataObject.find((FileObject)fileObject).getNodeDelegate();
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
        }

        public DefaultDataNode(Node node) {
            super(node);
            this.srcFolderNode = null;
        }

        public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
            if (clazz.equals(DataFolder.class)) {
                assert (this.srcFolderNode != null);
                return (T)this.srcFolderNode.getCookie(clazz);
            }
            return (T)super.getCookie(clazz);
        }
    }
}

