/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.wizards.support.SelectedTables;
import org.netbeans.modules.hibernate.wizards.support.SourceGroupUISupport;
import org.netbeans.modules.hibernate.wizards.support.TableClosure;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HibernateRevengCodeGenerationPanel
extends JPanel {
    private Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JTextComponent packageComboBoxEditor;
    private SelectedTables selectedTables;
    private JCheckBox chkDomain;
    private JCheckBox chkEjb;
    private JCheckBox chkHbm;
    private JCheckBox chkJava;
    private JComboBox cmbLocation;
    private JComboBox cmbPackage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField txtProject;

    public HibernateRevengCodeGenerationPanel() {
        this.initComponents();
        this.packageComboBoxEditor = (JTextComponent)this.cmbPackage.getEditor().getEditorComponent();
        Document document = this.packageComboBoxEditor.getDocument();
        document.addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                HibernateRevengCodeGenerationPanel.this.packageChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                HibernateRevengCodeGenerationPanel.this.packageChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                HibernateRevengCodeGenerationPanel.this.packageChanged();
            }
        });
    }

    public void initialize(Project project, FileObject fileObject) {
        SourceGroup sourceGroup;
        this.project = project;
        this.txtProject.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        SourceGroupUISupport.connect(this.cmbLocation, sourceGroupArray);
        this.cmbPackage.setRenderer(PackageView.listRenderer());
        this.updatePackageComboBox();
        if (fileObject != null && (sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroupArray, (FileObject)fileObject)) != null) {
            this.cmbLocation.setSelectedItem(sourceGroup);
            String string = SourceGroups.getPackageForFolder((SourceGroup)sourceGroup, (FileObject)fileObject);
            if (string != null) {
                this.packageComboBoxEditor.setText(string);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    private void packageChanged() {
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void updateSelectedTables() {
        if (this.selectedTables != null) {
            try {
                this.selectedTables.setTargetFolder(this.getLocationValue(), this.getPackageName());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void update(TableClosure tableClosure) {
        try {
            if (this.selectedTables == null) {
                this.selectedTables = new SelectedTables(tableClosure, this.getLocationValue(), this.getPackageName());
                this.selectedTables.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        HibernateRevengCodeGenerationPanel.this.changeSupport.fireChange();
                    }
                });
            } else {
                this.selectedTables.setTableClosureAndTargetFolder(tableClosure, this.getLocationValue(), this.getPackageName());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void updatePackageComboBox() {
        SourceGroup sourceGroup = (SourceGroup)this.cmbLocation.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
            if (comboBoxModel.getSelectedItem() != null && comboBoxModel.getSelectedItem().toString().startsWith("META-INF") && comboBoxModel.getSize() > 1) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(1));
            }
            this.cmbPackage.setModel(comboBoxModel);
        }
    }

    public SelectedTables getSelectedTables() {
        return this.selectedTables;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.cmbLocation.getSelectedItem();
    }

    public String getPackageName() {
        return this.packageComboBoxEditor.getText();
    }

    public boolean getChkDomain() {
        return this.chkDomain.isSelected();
    }

    public boolean getChkHbm() {
        return this.chkHbm.isSelected();
    }

    public boolean getChkJava() {
        return this.chkJava.isSelected();
    }

    public boolean getChkEjb() {
        return this.chkEjb.isSelected();
    }

    private void locationChanged() {
        this.updatePackageComboBox();
        this.updateSelectedTables();
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.chkDomain = new JCheckBox();
        this.chkHbm = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.txtProject = new JTextField();
        this.jLabel3 = new JLabel();
        this.cmbLocation = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cmbPackage = new JComboBox();
        this.jLabel5 = new JLabel();
        this.chkJava = new JCheckBox();
        this.chkEjb = new JCheckBox();
        this.setName(NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"LBL_GenerateClasses"));
        this.jLabel1.setText(NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.jLabel1.text"));
        this.chkDomain.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkDomain, (String)NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.chkDomain.text"));
        this.chkHbm.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkHbm, (String)NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.chkHbm.text"));
        this.jLabel2.setLabelFor(this.txtProject);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.jLabel2.text"));
        this.txtProject.setEditable(false);
        this.txtProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengCodeGenerationPanel.this.txtProjectActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setLabelFor(this.cmbLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.jLabel3.text"));
        this.cmbLocation.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengCodeGenerationPanel.this.cmbLocationActionPerformed(actionEvent);
            }
        });
        this.jLabel4.setLabelFor(this.cmbPackage);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.jLabel4.text"));
        this.cmbPackage.setEditable(true);
        this.cmbPackage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel5.setText(NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkJava, (String)NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.chkJava.text"));
        this.chkJava.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HibernateRevengCodeGenerationPanel.this.chkJavaActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chkEjb, (String)NbBundle.getMessage(HibernateRevengCodeGenerationPanel.class, (String)"HibernateRevengCodeGenerationPanel.chkEjb.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.chkEjb).add((Component)this.chkJava).add((Component)this.jLabel5).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel3, -1, 72, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtProject, -1, 414, Short.MAX_VALUE).add((Component)this.cmbPackage, 0, 414, Short.MAX_VALUE).add((Component)this.cmbLocation, 0, 414, Short.MAX_VALUE))).add((Component)this.chkHbm).add((Component)this.chkDomain).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.chkJava).addPreferredGap(0).add((Component)this.chkEjb).add(19, 19, 19).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.chkDomain).addPreferredGap(0).add((Component)this.chkHbm).add(23, 23, 23).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.txtProject, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cmbLocation, -2, -1, -2).add((Component)this.jLabel3)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cmbPackage, -2, -1, -2).add((Component)this.jLabel4)).add(29, 29, 29)));
    }

    private void cmbLocationActionPerformed(ActionEvent actionEvent) {
        this.locationChanged();
    }

    private void chkJavaActionPerformed(ActionEvent actionEvent) {
    }

    private void txtProjectActionPerformed(ActionEvent actionEvent) {
    }
}

