/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.mapping.HibernateMappingDataObject;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateConfigurationWizard;
import org.netbeans.modules.hibernate.wizards.HibernateMappingWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.Util;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMappingWizard
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private Project project;
    private WizardDescriptor wizard;
    private HibernateMappingWizardDescriptor descriptor;
    private transient WizardDescriptor.Panel[] panels;
    private final String resourceAttr = "resource";
    private static String DEFAULT_MAPPING_FILENAME = "hibernate.hbm";
    private Logger logger = Logger.getLogger(HibernateMappingWizard.class.getName());

    public static HibernateMappingWizard create() {
        return new HibernateMappingWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Object object;
            String[] stringArray;
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment == null) {
                this.logger.info("Unsupported project " + this.project + ". Existing config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                stringArray = Templates.getProject((WizardDescriptor)this.wizard);
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)stringArray).getSourceGroups("generic");
                object = Templates.createSimpleTargetChooser((Project)stringArray, (SourceGroup[])sourceGroupArray);
                this.panels = new WizardDescriptor.Panel[]{object, this.descriptor};
            }
            stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                object = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = ((Component)object).getName();
                }
                if (!(object instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)object;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        Object object;
        HibernateFileLocationProvider hibernateFileLocationProvider;
        this.wizard = wizardDescriptor;
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.descriptor = new HibernateMappingWizardDescriptor(this.project);
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            hibernateFileLocationProvider = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            Object object2 = object = hibernateFileLocationProvider != null ? hibernateFileLocationProvider.getLocation() : null;
            if (object != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)object);
            }
        }
        if (wizardDescriptor instanceof TemplateWizard) {
            hibernateFileLocationProvider = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateFileLocationProvider == null) {
                return;
            }
            object = hibernateFileLocationProvider.getAllHibernateMappingFileObjects();
            String string = DEFAULT_MAPPING_FILENAME;
            if (!object.isEmpty() && this.foundMappingFileInProject((List<FileObject>)object, DEFAULT_MAPPING_FILENAME)) {
                int n = object.size();
                string = "hibernate" + n++ + ".hbm";
                while (this.foundMappingFileInProject((List<FileObject>)object, string)) {
                    string = "hibernate" + n++ + ".hbm";
                }
            }
            ((TemplateWizard)wizardDescriptor).setTargetName(string);
        }
    }

    private boolean foundMappingFileInProject(List<FileObject> list, String string) {
        for (FileObject fileObject : list) {
            if (!fileObject.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        HibernateMappingDataObject hibernateMappingDataObject;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string);
        FileObject fileObject3 = null;
        MyClass myClass = new MyClass();
        if (this.descriptor.getConfigurationFile() != null && !"".equals(this.descriptor.getConfigurationFile())) {
            fileObject3 = this.descriptor.getConfigurationFile();
            hibernateMappingDataObject = DataObject.find((FileObject)fileObject3);
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)((Object)hibernateMappingDataObject);
            SessionFactory sessionFactory = hibernateCfgDataObject.getHibernateConfiguration().getSessionFactory();
            int n = sessionFactory.addMapping(true);
            sessionFactory.setAttributeValue("Mapping", n, "resource", HibernateUtil.getRelativeSourcePath(dataObject2.getPrimaryFile(), Util.getSourceRoot(this.project)));
            hibernateCfgDataObject.modelUpdatedFromUI();
            hibernateCfgDataObject.save();
        }
        try {
            hibernateMappingDataObject = (HibernateMappingDataObject)dataObject2;
            if (this.descriptor.getClassName() != null && !"".equals(this.descriptor.getClassName())) {
                myClass.setAttributeValue("name", this.descriptor.getClassName());
                if (this.descriptor.getDatabaseTable() != null && !"".equals(this.descriptor.getDatabaseTable())) {
                    myClass.setAttributeValue("table", this.descriptor.getDatabaseTable());
                    myClass.setAttributeValue("dynamic-insert", null);
                    myClass.setAttributeValue("dynamic-update", null);
                    myClass.setAttributeValue("mutable", null);
                    myClass.setAttributeValue("optimistic-lock", null);
                    myClass.setAttributeValue("polymorphism", null);
                    myClass.setAttributeValue("select-before-update", null);
                }
                hibernateMappingDataObject.addMyClass(myClass);
            }
            hibernateMappingDataObject.save();
            return Collections.singleton(hibernateMappingDataObject.getPrimaryFile());
        }
        catch (Exception exception) {
            return Collections.EMPTY_SET;
        }
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public String name() {
        return NbBundle.getMessage(HibernateConfigurationWizard.class, (String)"LBL_MappingWizardTitle");
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }
}

