/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.wizards.HibernateConfigurationWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateConfigurationWizard
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private Project project;
    private WizardDescriptor wizard;
    private HibernateConfigurationWizardDescriptor descriptor;
    private WizardDescriptor.Panel[] panels;
    private final String sessionName = "name";
    private final String dialect = "hibernate.dialect";
    private final String driver = "hibernate.connection.driver_class";
    private final String url = "hibernate.connection.url";
    private final String userName = "hibernate.connection.username";
    private final String password = "hibernate.connection.password";
    private final String DEFAULT_CONFIGURATION_FILENAME = "hibernate.cfg";
    private Logger logger = Logger.getLogger(HibernateConfigurationWizard.class.getName());

    public static HibernateConfigurationWizard create() {
        return new HibernateConfigurationWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            Object object;
            String[] stringArray;
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnvironment == null) {
                this.logger.info("Unsupported project " + this.project + ". Existing config wizard.");
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                stringArray = Templates.getProject((WizardDescriptor)this.wizard);
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)stringArray).getSourceGroups("generic");
                object = Templates.createSimpleTargetChooser((Project)stringArray, (SourceGroup[])sourceGroupArray);
                this.panels = new WizardDescriptor.Panel[]{object, this.descriptor};
            }
            stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                object = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = ((Component)object).getName();
                }
                if (!(object instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)object;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    private boolean foundConfigFileInProject(List<FileObject> list, String string) {
        for (FileObject fileObject : list) {
            if (!fileObject.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String name() {
        return NbBundle.getMessage(HibernateConfigurationWizard.class, (String)"LBL_ConfWizardTitle");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        Object object;
        HibernateFileLocationProvider hibernateFileLocationProvider;
        this.wizard = wizardDescriptor;
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.descriptor = new HibernateConfigurationWizardDescriptor(this.project);
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            hibernateFileLocationProvider = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            Object object2 = object = hibernateFileLocationProvider != null ? hibernateFileLocationProvider.getLocation() : null;
            if (object != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)object);
            }
        }
        if (wizardDescriptor instanceof TemplateWizard) {
            hibernateFileLocationProvider = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateFileLocationProvider == null) {
                return;
            }
            object = hibernateFileLocationProvider.getAllHibernateConfigFileObjects();
            String string = "hibernate.cfg";
            if (!object.isEmpty() && this.foundConfigFileInProject((List<FileObject>)object, "hibernate.cfg")) {
                int n = object.size();
                string = "hibernate" + n++ + ".cfg";
                while (this.foundConfigFileInProject((List<FileObject>)object, string)) {
                    string = "hibernate" + n++ + ".cfg";
                }
            }
            ((TemplateWizard)wizardDescriptor).setTargetName(string);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        int n;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string);
        SessionFactory sessionFactory = new SessionFactory();
        if (this.descriptor.getDialectName() != null && !"".equals(this.descriptor.getDialectName())) {
            n = sessionFactory.addProperty2(this.descriptor.getDialectName());
            sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.dialect");
        }
        if (this.descriptor.getDriver() != null && !"".equals(this.descriptor.getDriver())) {
            n = sessionFactory.addProperty2(this.descriptor.getDriver());
            sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.driver_class");
        }
        if (this.descriptor.getURL() != null && !"".equals(this.descriptor.getURL())) {
            n = sessionFactory.addProperty2(this.descriptor.getURL());
            sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.url");
        }
        if (this.descriptor.getUserName() != null && !"".equals(this.descriptor.getUserName())) {
            n = sessionFactory.addProperty2(this.descriptor.getUserName());
            sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.username");
        }
        if (this.descriptor.getPassword() != null && !"".equals(this.descriptor.getPassword())) {
            n = sessionFactory.addProperty2(this.descriptor.getPassword());
            sessionFactory.setAttributeValue("Property2", n, "name", "hibernate.connection.password");
        }
        try {
            HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)dataObject2;
            hibernateCfgDataObject.addSessionFactory(sessionFactory);
            hibernateCfgDataObject.save();
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            this.logger.info("Library registered : " + hibernateEnvironment.addHibernateLibraryToProject(hibernateCfgDataObject.getPrimaryFile()));
            return Collections.singleton(hibernateCfgDataObject.getPrimaryFile());
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return Collections.EMPTY_SET;
        }
    }
}

