/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUtil {
    private static Logger logger = Logger.getLogger(HibernateUtil.class.getName());

    public static List<String> getAllDatabaseTables(HibernateConfiguration ... hibernateConfigurationArray) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HibernateConfiguration hibernateConfiguration : hibernateConfigurationArray) {
            try {
                ResultSet resultSet;
                Connection connection;
                DatabaseConnection databaseConnection = HibernateUtil.getDBConnection(hibernateConfiguration);
                if (databaseConnection == null || (connection = databaseConnection.getJDBCConnection()) == null) continue;
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet2 = databaseMetaData.getSchemas();
                if (resultSet2.next()) {
                    do {
                        resultSet = databaseMetaData.getTables(null, resultSet2.getString("TABLE_SCHEM"), null, new String[]{"TABLE"});
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("TABLE_NAME"));
                        }
                    } while (resultSet2.next());
                    continue;
                }
                resultSet = databaseMetaData.getTables(null, databaseConnection.getSchema(), null, new String[]{"TABLE"});
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("TABLE_NAME"));
                }
            }
            catch (DatabaseException databaseException) {
                Exceptions.printStackTrace((Throwable)databaseException);
            }
        }
        return arrayList;
    }

    public static List<HibernateConfiguration> getAllHibernateConfigurations(Project project) {
        ArrayList<HibernateConfiguration> arrayList = new ArrayList<HibernateConfiguration>();
        for (FileObject fileObject : HibernateUtil.getAllHibernateConfigFileObjects(project)) {
            try {
                arrayList.add(((HibernateCfgDataObject)DataObject.find((FileObject)fileObject)).getHibernateConfiguration());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        return arrayList;
    }

    public static List<FileObject> getAllHibernateConfigFileObjects(Project project) {
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (SourceGroup sourceGroup : sourceGroupArray = HibernateUtil.getSourceGroups(project)) {
            FileObject fileObject = sourceGroup.getRootFolder();
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.getNameExt() == null || !fileObject2.getMIMEType().equals("text/x-hibernate-cfg+xml")) continue;
                arrayList.add(fileObject2);
            }
        }
        return arrayList;
    }

    public static List<FileObject> getAllHibernateMappingFileObjects(Project project) {
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (SourceGroup sourceGroup : sourceGroupArray = HibernateUtil.getSourceGroups(project)) {
            FileObject fileObject = sourceGroup.getRootFolder();
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.getNameExt() == null || !fileObject2.getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
                arrayList.add(fileObject2);
            }
        }
        return arrayList;
    }

    private static FileObject createBuildFolder(File file) {
        FileObject fileObject = null;
        logger.info("Build folder does not exist. Creating it.");
        try {
            fileObject = FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, "Cannot create build folder", iOException);
        }
        return fileObject;
    }

    private static SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("resources");
        if (sourceGroupArray == null || sourceGroupArray.length == 0) {
            sourceGroupArray = sources.getSourceGroups("java");
        }
        return sourceGroupArray;
    }

    public static FileObject findJavaFileObjectInProject(String string, Project project) {
        string = string.replace('.', File.separatorChar);
        string = string + ".java";
        GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();
        FileObject fileObject = globalPathRegistry.findResource(string);
        return fileObject;
    }

    public static List<URL> getProjectClassPathEntries(FileObject fileObject) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        for (ClassPath.Entry entry : classPath.entries()) {
            arrayList.add(entry.getURL());
        }
        return arrayList;
    }

    public static FileObject getBuildFO(Project project) {
        FileObject fileObject;
        block13: {
            fileObject = null;
            try {
                BinaryForSourceQueryImplementation binaryForSourceQueryImplementation = (BinaryForSourceQueryImplementation)project.getLookup().lookup(BinaryForSourceQueryImplementation.class);
                if (binaryForSourceQueryImplementation == null) {
                    logger.info("BinaryForSourceQueryImpl is null. trying reflection.");
                    Method method = null;
                    try {
                        method = project.getClass().getDeclaredMethod("evaluator", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        Exceptions.printStackTrace((Throwable)noSuchMethodException);
                    }
                    catch (SecurityException securityException) {
                        Exceptions.printStackTrace((Throwable)securityException);
                    }
                    if (method != null) {
                        try {
                            PropertyEvaluator propertyEvaluator = (PropertyEvaluator)method.invoke((Object)project, new Object[0]);
                            String string = propertyEvaluator.getProperty("build.classes.dir");
                            if (string != null && (fileObject = project.getProjectDirectory().getFileObject(string)) == null) {
                                File file = new File(FileUtil.toFile((FileObject)project.getProjectDirectory()), string);
                                fileObject = HibernateUtil.createBuildFolder(file);
                            }
                            break block13;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Exceptions.printStackTrace((Throwable)illegalAccessException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Exceptions.printStackTrace((Throwable)illegalArgumentException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Exceptions.printStackTrace((Throwable)invocationTargetException);
                        }
                        break block13;
                    }
                    logger.info("No method named 'evaluator() found in project : " + project);
                    break block13;
                }
                SourceGroup[] sourceGroupArray = HibernateUtil.getSourceGroups(project);
                BinaryForSourceQuery.Result result = binaryForSourceQueryImplementation.findBinaryRoots(sourceGroupArray[0].getRootFolder().getURL());
                URL uRL = result.getRoots()[0];
                logger.info("Got build URL from the project sources : " + uRL);
                File file = new File(uRL.getPath());
                fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null) {
                    fileObject = HibernateUtil.createBuildFolder(file);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        logger.info("Build Folder = " + fileObject);
        return fileObject;
    }

    public static List<String> getAllHibernateMappingsRelativeToSourcePath(Project project) {
        SourceGroup[] sourceGroupArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SourceGroup sourceGroup : sourceGroupArray = HibernateUtil.getSourceGroups(project)) {
            FileObject fileObject = sourceGroup.getRootFolder();
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.getNameExt() == null || !fileObject2.getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
                arrayList.add(HibernateUtil.getRelativeSourcePath(fileObject2, fileObject));
            }
        }
        return arrayList;
    }

    public static List<FileObject> getAllHibernateReverseEnggFileObjects(Project project) {
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
            FileObject fileObject = sourceGroup.getRootFolder();
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.getNameExt() == null || !fileObject2.getMIMEType().equals("text/x-hibernate-reveng+xml")) continue;
                arrayList.add(fileObject2);
            }
        }
        return arrayList;
    }

    public static List<TableColumn> getColumnsForTable(String string, HibernateConfiguration hibernateConfiguration) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        try {
            Connection connection = HibernateUtil.getJDBCConnection(hibernateConfiguration);
            if (connection != null) {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet2 = databaseMetaData.getPrimaryKeys(null, null, string);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (resultSet2.next()) {
                    arrayList2.add(resultSet2.getString("COLUMN_NAME"));
                }
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    TableColumn tableColumn = new TableColumn();
                    tableColumn.setColumnName(resultSetMetaData.getColumnName(i));
                    if (arrayList2.contains(tableColumn.getColumnName())) {
                        tableColumn.setPrimaryKey(true);
                    }
                    arrayList.add(tableColumn);
                }
            }
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        return arrayList;
    }

    public static String getDbConnectionDetails(HibernateConfiguration hibernateConfiguration, String string) {
        SessionFactory sessionFactory = hibernateConfiguration.getSessionFactory();
        int n = 0;
        for (String string2 : sessionFactory.getProperty2()) {
            String string3;
            if (!(string3 = sessionFactory.getAttributeValue("Property2", n++, "name")).equals(string)) continue;
            return string2;
        }
        return "";
    }

    public static DatabaseConnection getDBConnection(HibernateConfiguration hibernateConfiguration) throws DatabaseException {
        try {
            DatabaseConnection[] databaseConnectionArray;
            String string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.driver_class");
            String string2 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.url");
            String string3 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.username");
            String string4 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "hibernate.connection.password");
            if (string == null) {
                string = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.driver_class");
            }
            if (string2 == null) {
                string2 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.url");
            }
            if (string3 == null) {
                string3 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.username");
            }
            if (string4 == null) {
                string4 = HibernateUtil.getDbConnectionDetails(hibernateConfiguration, "connection.password");
            }
            for (DatabaseConnection databaseConnection : databaseConnectionArray = ConnectionManager.getDefault().getConnections()) {
                if (!databaseConnection.getDatabaseURL().equals(string2) || !databaseConnection.getUser().equals(string3)) continue;
                logger.info("Found pre-existing database connection.");
                return HibernateUtil.checkAndConnect(databaseConnection);
            }
            DatabaseConnection[] databaseConnectionArray2 = JDBCDriverManager.getDefault().getDrivers(string);
            if (databaseConnectionArray2.length == 0) {
                return null;
            }
            DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)databaseConnectionArray2[0], (String)string2, (String)string3, null, (String)string4, (boolean)true);
            ConnectionManager.getDefault().addConnection(databaseConnection);
            return HibernateUtil.checkAndConnect(databaseConnection);
        }
        catch (DatabaseException databaseException) {
            Exceptions.printStackTrace((Throwable)databaseException);
            throw databaseException;
        }
    }

    private static DatabaseConnection checkAndConnect(final DatabaseConnection databaseConnection) {
        if (databaseConnection.getJDBCConnection() == null) {
            logger.info("Database Connection not established, connecting..");
            return (DatabaseConnection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

                public DatabaseConnection run() {
                    ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                    return databaseConnection;
                }
            });
        }
        logger.info("Database Connection is pre-established. Returning the conneciton.");
        return databaseConnection;
    }

    public static String getRelativeSourcePath(FileObject fileObject, FileObject fileObject2) {
        String string = "";
        try {
            String string2 = fileObject.getPath();
            String string3 = fileObject2.getPath();
            int n = string2.indexOf(string3);
            string = string2.substring(n + string3.length() + 1);
        }
        catch (Exception exception) {
            logger.info("exception while parsing relative path");
            Exceptions.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private static Connection getJDBCConnection(HibernateConfiguration hibernateConfiguration) throws DatabaseException {
        if (HibernateUtil.getDBConnection(hibernateConfiguration) == null) {
            return null;
        }
        return HibernateUtil.getDBConnection(hibernateConfiguration).getJDBCConnection();
    }
}

