/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hqleditor.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.hibernate.QueryException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.impl.SessionFactoryImpl;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.hqleditor.HQLEditorController;
import org.netbeans.modules.hibernate.hqleditor.HQLResult;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.CustomClassLoader;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HQLEditorTopComponent
extends TopComponent {
    static final String ICON_PATH = "org/netbeans/modules/hibernate/hqleditor/ui/resources/queryEditor16X16.png";
    private Logger logger = Logger.getLogger(HQLEditorTopComponent.class.getName());
    private HashMap<String, FileObject> hibernateConfigMap = new HashMap();
    private static List<Integer> windowCounts = new ArrayList<Integer>();
    private Integer thisWindowCount = new Integer(0);
    private HQLEditorController controller = null;
    private HibernateEnvironment env = null;
    private ProgressHandle ph = null;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task hqlParserTask;
    private boolean isSqlTranslationProcessDone = false;
    private JPanel containerPanel;
    private JTextArea errorTextArea;
    private JPanel executionPanel;
    private JComboBox hibernateConfigurationComboBox;
    private JEditorPane hqlEditor;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JPanel resultContainerPanel;
    private JToggleButton resultToggleButton;
    private JPanel resultsOrErrorPanel;
    private JTable resultsTable;
    private JButton runHQLButton;
    private JLabel sessionLabel;
    private JComboBox setMaxRowCountComboBox;
    private JLabel setMaxRowCountLabel;
    private JPanel setMaxRowCountPanel;
    private JPanel spacerPanel1;
    private JPanel spacerPanel2;
    private JSplitPane splitPane;
    private JTextPane sqlEditorPane;
    private JToggleButton sqlToggleButton;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JToolBar toolBar;
    private JToolBar toolBar2;
    private JToolBar.Separator toolbarSeparator;
    private JToolBar.Separator toolbarSeparator1;

    private static int getNextWindowCount() {
        int n = 0;
        while (windowCounts.contains(n)) {
            ++n;
        }
        windowCounts.add(n);
        return n;
    }

    public static HQLEditorTopComponent getInstance() {
        return new HQLEditorTopComponent(null);
    }

    public HQLEditorTopComponent(HQLEditorController hQLEditorController) {
        this.controller = hQLEditorController;
        this.initComponents();
        this.thisWindowCount = HQLEditorTopComponent.getNextWindowCount();
        this.setName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"CTL_HQLEditorTopComponent") + this.thisWindowCount);
        this.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HINT_HQLEditorTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
        this.sqlToggleButton.setSelected(true);
        this.hqlEditor.getDocument().addDocumentListener(new HQLDocumentListener());
    }

    public void setFocusToEditor() {
        this.hqlEditor.requestFocus();
    }

    private void showSQL(String string) {
        this.sqlEditorPane.setText(string);
        this.switchToSQLView();
    }

    private void showSQLError(String string) {
        this.sqlEditorPane.setText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)string));
        this.switchToSQLView();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.requestProcessor = new RequestProcessor("hql-parser", 1, true);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.requestProcessor.stop();
    }

    /*
     * WARNING - void declaration
     */
    public void fillHibernateConfigurations(Node[] nodeArray) {
        Node node = nodeArray[0];
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject instanceof HibernateCfgDataObject) {
            void var7_10;
            Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            this.env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            if (this.env == null) {
                this.logger.warning("HiberEnv is not found in enclosing project.");
                return;
            }
            List<FileObject> list = this.env.getAllHibernateConfigFileObjects();
            for (FileObject object2 : list) {
                try {
                    HibernateCfgDataObject hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)object2);
                    String string = hibernateCfgDataObject.getHibernateConfiguration().getSessionFactory().getAttributeValue("name");
                    if (string == null || string.equals("")) {
                        string = object2.getName();
                    }
                    this.hibernateConfigMap.put(string, object2);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            this.hibernateConfigurationComboBox.setModel(new DefaultComboBoxModel<Object>(this.hibernateConfigMap.keySet().toArray()));
            HibernateConfiguration hibernateConfiguration = ((HibernateCfgDataObject)dataObject).getHibernateConfiguration();
            String string = hibernateConfiguration.getSessionFactory().getAttributeValue("name");
            if (string == null || string.equals("")) {
                String string2 = dataObject.getPrimaryFile().getName();
            }
            this.hibernateConfigurationComboBox.setSelectedItem(var7_10);
        }
    }

    public void setResult(HQLResult hQLResult) {
        if (hQLResult.getExceptions().size() == 0) {
            this.switchToResultView();
            StringBuilder stringBuilder = new StringBuilder();
            String string = " ";
            String string2 = "; ";
            stringBuilder.append(hQLResult.getUpdateOrDeleteResult());
            stringBuilder.append(string);
            stringBuilder.append(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryUpdatedOrDeleted"));
            stringBuilder.append(string2);
            stringBuilder.append(string);
            stringBuilder.append(hQLResult.getQueryResults().size());
            stringBuilder.append(string);
            stringBuilder.append(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"rowsSelected"));
            this.setStatus(stringBuilder.toString());
            Vector<String> vector = new Vector<String>();
            Vector<Vector> vector2 = new Vector<Vector>();
            if (hQLResult.getQueryResults().size() != 0) {
                Object e = hQLResult.getQueryResults().get(0);
                if (e instanceof Object[]) {
                    for (Object object : (Object[])e) {
                        this.createTableHeaders(vector, object);
                    }
                    for (Object e2 : hQLResult.getQueryResults()) {
                        this.createTableData(vector2, (Object[])e2);
                    }
                } else {
                    this.createTableHeaders(vector, e);
                    for (Object e3 : hQLResult.getQueryResults()) {
                        this.createTableData(vector2, e3);
                    }
                }
            }
            this.resultsTable.setModel(new HQLEditorResultTableModel(vector2, vector));
        } else {
            this.logger.info("HQL query execution resulted in following " + hQLResult.getExceptions().size() + " errors.");
            this.switchToErrorView();
            this.setStatus(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionError"));
            this.errorTextArea.setText("");
            for (Throwable throwable : hQLResult.getExceptions()) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                this.errorTextArea.append(stringWriter.toString());
                this.errorTextArea.append(this.removeHibernateModuleCodelines(stringWriter.toString()));
                this.logger.log(Level.INFO, "", throwable);
            }
        }
        this.ph.progress(99);
        this.ph.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionDone"));
        this.runHQLButton.setEnabled(true);
        this.ph.finish();
    }

    private void createTableHeaders(Vector<String> vector, Object object) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            String string = method.getName();
            if (!string.startsWith("get") || vector.contains(string)) continue;
            vector.add(method.getName().substring(3));
        }
    }

    private void createTableData(Vector<Vector> vector, Object ... objectArray) {
        Vector<Object> vector2 = new Vector<Object>();
        for (Object object : objectArray) {
            for (Method method : object.getClass().getDeclaredMethods()) {
                String string = method.getName();
                if (!string.startsWith("get")) continue;
                try {
                    Object object2 = method.invoke(object, new Object[0]);
                    if (object2 == null) {
                        vector2.add("NULL");
                        continue;
                    }
                    vector2.add(object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Exceptions.printStackTrace((Throwable)illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Exceptions.printStackTrace((Throwable)illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
            }
        }
        vector.add(vector2);
    }

    private void setStatus(String string) {
        this.statusLabel.setText(string);
    }

    private String removeHibernateModuleCodelines(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.contains("org.netbeans.modules.hibernate")) continue;
            stringBuilder.append(string2).append("\n");
        }
        return stringBuilder.toString();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.sessionLabel = new JLabel();
        this.hibernateConfigurationComboBox = new JComboBox();
        this.toolbarSeparator = new JToolBar.Separator();
        this.runHQLButton = new JButton();
        this.toolbarSeparator1 = new JToolBar.Separator();
        this.splitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.hqlEditor = new JEditorPane();
        this.containerPanel = new JPanel();
        this.toolBar2 = new JToolBar();
        this.resultToggleButton = new JToggleButton();
        this.sqlToggleButton = new JToggleButton();
        this.spacerPanel1 = new JPanel();
        this.spacerPanel2 = new JPanel();
        this.setMaxRowCountPanel = new JPanel();
        this.setMaxRowCountLabel = new JLabel();
        this.setMaxRowCountComboBox = new JComboBox();
        this.executionPanel = new JPanel();
        this.resultContainerPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.resultsOrErrorPanel = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.errorTextArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.resultsTable = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.sqlEditorPane = new JTextPane();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        Mnemonics.setLocalizedText((JLabel)this.sessionLabel, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.sessionLabel.text"));
        this.toolBar.add(this.sessionLabel);
        this.toolBar.add(this.hibernateConfigurationComboBox);
        this.toolBar.add(this.toolbarSeparator);
        this.runHQLButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/netbeans/modules/hibernate/hqleditor/ui/resources/run_hql_query_16.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.runHQLButton, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.runHQLButton.text"));
        this.runHQLButton.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"runHQLQueryButtonToolTip"));
        this.runHQLButton.setFocusable(false);
        this.runHQLButton.setHorizontalTextPosition(0);
        this.runHQLButton.setVerticalTextPosition(3);
        this.runHQLButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HQLEditorTopComponent.this.runHQLButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.runHQLButton);
        this.toolbarSeparator1.setSeparatorSize(new Dimension(300, 10));
        this.toolBar.add(this.toolbarSeparator1);
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(180);
        this.splitPane.setDividerSize(7);
        this.splitPane.setOrientation(0);
        this.hqlEditor.setContentType("text/x-hql");
        this.jScrollPane1.setViewportView(this.hqlEditor);
        this.splitPane.setTopComponent(this.jScrollPane1);
        this.toolBar2.setFloatable(false);
        this.toolBar2.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.resultToggleButton, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.resultToggleButton.text"));
        this.resultToggleButton.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"showResultTooltipText"));
        this.resultToggleButton.setFocusable(false);
        this.resultToggleButton.setHorizontalTextPosition(0);
        this.resultToggleButton.setVerticalTextPosition(3);
        this.resultToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HQLEditorTopComponent.this.resultToggleButtonItemStateChanged(itemEvent);
            }
        });
        this.toolBar2.add(this.resultToggleButton);
        Mnemonics.setLocalizedText((AbstractButton)this.sqlToggleButton, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.sqlToggleButton.text"));
        this.sqlToggleButton.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"showSQLTooltipText"));
        this.sqlToggleButton.setHorizontalTextPosition(0);
        this.sqlToggleButton.setVerticalTextPosition(3);
        this.sqlToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HQLEditorTopComponent.this.sqlToggleButtonItemStateChanged(itemEvent);
            }
        });
        this.toolBar2.add(this.sqlToggleButton);
        GroupLayout groupLayout = new GroupLayout((Container)this.spacerPanel1);
        this.spacerPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 202, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 27, Short.MAX_VALUE));
        this.toolBar2.add(this.spacerPanel1);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.spacerPanel2);
        this.spacerPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 98, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(0, 27, Short.MAX_VALUE));
        this.toolBar2.add(this.spacerPanel2);
        Mnemonics.setLocalizedText((JLabel)this.setMaxRowCountLabel, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.setMaxRowCountLabel.text"));
        this.setMaxRowCountComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"100", "1000", "10000", "100000"}));
        this.setMaxRowCountComboBox.setToolTipText(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"setMaxRowToolTip"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.setMaxRowCountPanel);
        this.setMaxRowCountPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.setMaxRowCountLabel).addPreferredGap(0).add((Component)this.setMaxRowCountComboBox, -2, -1, -2)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.setMaxRowCountLabel).add((Component)this.setMaxRowCountComboBox, -2, -1, -2)));
        this.toolBar2.add(this.setMaxRowCountPanel);
        this.executionPanel.setLayout(new CardLayout());
        this.resultContainerPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"HQLEditorTopComponent.statusLabel.text"));
        GroupLayout groupLayout4 = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 607, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add(0, 303, Short.MAX_VALUE).add((Component)this.statusLabel).add(0, 304, Short.MAX_VALUE))));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.statusLabel).add(0, 0, Short.MAX_VALUE))));
        this.resultContainerPanel.add((Component)this.statusPanel, "North");
        this.resultsOrErrorPanel.setLayout(new CardLayout());
        this.errorTextArea.setColumns(20);
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setForeground(new Color(255, 102, 102));
        this.errorTextArea.setRows(5);
        this.jScrollPane4.setViewportView(this.errorTextArea);
        this.resultsOrErrorPanel.add((Component)this.jScrollPane4, "card2");
        this.resultsTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane3.setViewportView(this.resultsTable);
        this.resultsOrErrorPanel.add((Component)this.jScrollPane3, "card3");
        this.resultContainerPanel.add((Component)this.resultsOrErrorPanel, "Center");
        this.executionPanel.add((Component)this.resultContainerPanel, "card2");
        this.jScrollPane2.setViewportView(this.sqlEditorPane);
        this.executionPanel.add((Component)this.jScrollPane2, "card1");
        GroupLayout groupLayout5 = new GroupLayout((Container)this.containerPanel);
        this.containerPanel.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.toolBar2, -1, 607, Short.MAX_VALUE).add((Component)this.executionPanel, -1, 607, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.toolBar2, -2, -1, -2).addPreferredGap(0).add((Component)this.executionPanel, -1, 284, Short.MAX_VALUE)));
        this.splitPane.setRightComponent(this.containerPanel);
        GroupLayout groupLayout6 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.toolBar, -1, 607, Short.MAX_VALUE).add((Component)this.splitPane, -1, 607, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((Component)this.toolBar, -2, 25, -2).addPreferredGap(0).add((Component)this.splitPane, -1, 508, Short.MAX_VALUE)));
    }

    private int getMaxRowCount() {
        String string = this.setMaxRowCountComboBox.getSelectedItem().toString();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.warning("Number Format Error during parsing the max. row count");
            return 1000;
        }
    }

    private void resultToggleButtonItemStateChanged(ItemEvent itemEvent) {
        if (this.resultToggleButton.isSelected()) {
            ((CardLayout)this.executionPanel.getLayout()).first(this.executionPanel);
            this.sqlToggleButton.setSelected(false);
        }
    }

    private void sqlToggleButtonItemStateChanged(ItemEvent itemEvent) {
        if (this.sqlToggleButton.isSelected()) {
            ((CardLayout)this.executionPanel.getLayout()).last(this.executionPanel);
            this.resultToggleButton.setSelected(false);
        }
    }

    private void runHQLButtonActionPerformed(ActionEvent actionEvent) {
        if (this.hqlEditor.getText().trim().equals("")) {
            this.switchToResultView();
            this.setStatus(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"emptyQuery"));
            return;
        }
        this.runHQLButton.setEnabled(false);
        try {
            this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(HQLEditorTopComponent.class, (String)"progressTaskname"));
            FileObject fileObject = this.hibernateConfigMap.get(this.hibernateConfigurationComboBox.getSelectedItem());
            this.ph.start(100);
            this.controller.executeHQLQuery(this.hqlEditor.getText(), fileObject, this.getMaxRowCount(), this.ph);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        windowCounts.remove(this.thisWindowCount);
    }

    private void switchToResultView() {
        this.resultToggleButton.setSelected(true);
        ((CardLayout)this.resultsOrErrorPanel.getLayout()).last(this.resultsOrErrorPanel);
    }

    private void switchToSQLView() {
        this.sqlToggleButton.setSelected(true);
    }

    private void switchToErrorView() {
        this.resultToggleButton.setSelected(true);
        ((CardLayout)this.resultsOrErrorPanel.getLayout()).first(this.resultsOrErrorPanel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HQLEditorResultTableModel
    extends DefaultTableModel {
        public HQLEditorResultTableModel(Vector<Vector> vector, Vector<String> vector2) {
            super(vector, vector2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class HQLDocumentListener
    implements DocumentListener {
        private HQLDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.process();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.process();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.process();
        }

        private void process() {
            if (HQLEditorTopComponent.this.hqlParserTask != null && !HQLEditorTopComponent.this.hqlParserTask.isFinished() && HQLEditorTopComponent.this.hqlParserTask.getDelay() != 0) {
                HQLEditorTopComponent.this.hqlParserTask.cancel();
            }
            HQLEditorTopComponent.this.hqlParserTask = HQLEditorTopComponent.this.requestProcessor.post((Runnable)new ParseHQL(), 1000);
            HQLEditorTopComponent.this.isSqlTranslationProcessDone = false;
        }
    }

    private class ParseHQL
    extends Thread {
        private ParseHQL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                if (HQLEditorTopComponent.this.hqlEditor.getText().trim().equals("")) {
                    return;
                }
                if (HQLEditorTopComponent.this.hibernateConfigurationComboBox.getSelectedItem() == null) {
                    HQLEditorTopComponent.this.logger.info("hibernate configuration combo box is empty.");
                    return;
                }
                FileObject fileObject = (FileObject)HQLEditorTopComponent.this.hibernateConfigMap.get(HQLEditorTopComponent.this.hibernateConfigurationComboBox.getSelectedItem().toString());
                if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                    return;
                }
                if (fileObject == null) continue;
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                HQLEditorTopComponent.this.env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
                if (HQLEditorTopComponent.this.env == null) {
                    HQLEditorTopComponent.this.logger.warning("HiberEnv is not found in enclosing project.");
                    return;
                }
                if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                    return;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    QueryTranslator[] queryTranslatorArray;
                    CustomClassLoader customClassLoader = new CustomClassLoader(HQLEditorTopComponent.this.env.getProjectClassPath(fileObject).toArray(new URL[0]), this.getClass().getClassLoader());
                    Thread.currentThread().setContextClassLoader(customClassLoader);
                    AnnotationConfiguration annotationConfiguration = HQLEditorTopComponent.this.controller.processAndConstructCustomConfiguration(HQLEditorTopComponent.this.hqlEditor.getText(), fileObject, project);
                    if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                        return;
                    }
                    SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)annotationConfiguration.buildSessionFactory();
                    if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    HQLQueryPlan hQLQueryPlan = sessionFactoryImpl.getQueryPlanCache().getHQLQueryPlan(HQLEditorTopComponent.this.hqlEditor.getText(), true, Collections.EMPTY_MAP);
                    for (QueryTranslator queryTranslator : queryTranslatorArray = hQLQueryPlan.getTranslators()) {
                        HQLEditorTopComponent.this.logger.info("SQL String = " + queryTranslator.getSQLString());
                        stringBuilder.append(queryTranslator.getSQLString() + "\n");
                    }
                    if (Thread.interrupted() || HQLEditorTopComponent.this.isSqlTranslationProcessDone) {
                        return;
                    }
                    HQLEditorTopComponent.this.showSQL(stringBuilder.toString());
                }
                catch (QuerySyntaxException querySyntaxException) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", querySyntaxException);
                    HQLEditorTopComponent.this.showSQLError("MalformedQuery");
                }
                catch (QueryException queryException) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", queryException);
                    HQLEditorTopComponent.this.showSQLError("MalformedQuery");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", illegalArgumentException);
                    HQLEditorTopComponent.this.showSQLError("MalformedQuery");
                }
                catch (NullPointerException nullPointerException) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", nullPointerException);
                    HQLEditorTopComponent.this.showSQLError("DbError");
                }
                catch (Exception exception) {
                    HQLEditorTopComponent.this.logger.log(Level.INFO, "", exception);
                    HQLEditorTopComponent.this.showSQLError("GeneralError");
                }
                finally {
                    HQLEditorTopComponent.this.isSqlTranslationProcessDone = true;
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
            }
        }
    }
}

