/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTCommentToken;
import org.netbeans.modules.cnd.apt.impl.support.APTConstTextToken;
import org.netbeans.modules.cnd.apt.impl.support.APTTestToken;
import org.netbeans.modules.cnd.apt.support.APTBaseToken;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTUtils {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.apt");
    public static final APTToken VA_ARGS_TOKEN;
    public static final APTToken EMPTY_ID_TOKEN;
    public static final APTToken COMMA_TOKEN;
    public static final List<Token> DEF_MACRO_BODY;
    public static final APTToken EOF_TOKEN;
    public static final TokenStream EMPTY_STREAM;

    private APTUtils() {
    }

    public static APTToken createAPTToken(int n) {
        if (APTUtils.isPreprocessorToken(n)) {
            return APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
        }
        switch (n) {
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 191: 
            case 192: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 233: {
                return APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
            }
            case 217: 
            case 218: {
                return new APTCommentToken();
            }
        }
        return new APTConstTextToken();
    }

    public static String debugString(TokenStream tokenStream) {
        return APTUtils.stringize(tokenStream, false);
    }

    public static String toString(TokenStream tokenStream) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token = tokenStream.nextToken();
            while (!APTUtils.isEOF(token)) {
                assert (token != null) : "list of tokens must not have 'null' elements";
                stringBuilder.append(token.toString());
                token = tokenStream.nextToken();
                if (APTUtils.isEOF(token)) continue;
                stringBuilder.append(" ");
            }
        }
        catch (TokenStreamException tokenStreamException) {
            LOG.log(Level.SEVERE, "error on converting token stream to text", tokenStreamException);
        }
        return stringBuilder.toString();
    }

    public static String stringize(TokenStream tokenStream, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            APTToken aPTToken = (APTToken)tokenStream.nextToken();
            while (!APTUtils.isEOF(aPTToken)) {
                assert (aPTToken != null) : "list of tokens must not have 'null' elements";
                stringBuilder.append(aPTToken.getText());
                APTToken aPTToken2 = (APTToken)tokenStream.nextToken();
                if (!APTUtils.isEOF(aPTToken2) && !bl) {
                    stringBuilder.append(aPTToken2.getOffset() == aPTToken.getEndOffset() ? "" : Character.valueOf(' '));
                }
                aPTToken = aPTToken2;
            }
        }
        catch (TokenStreamException tokenStreamException) {
            LOG.log(Level.SEVERE, "error on stringizing token stream", tokenStreamException);
        }
        return stringBuilder.toString();
    }

    public static String macros2String(Map<String, APTMacro> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MACROS (sorted " + map.size() + "):\n");
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            APTMacro aPTMacro = map.get(APTUtils.getTokenTextKey(new APTBaseToken(string)));
            assert (aPTMacro != null);
            stringBuilder.append(aPTMacro);
            stringBuilder.append("'\n");
        }
        return stringBuilder.toString();
    }

    public static String includes2String(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static boolean isPreprocessorToken(Token token) {
        assert (token != null);
        return APTUtils.isPreprocessorToken(token.getType());
    }

    public static boolean isPreprocessorToken(int n) {
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    public static boolean isID(Token token) {
        return token != null && token.getType() == 204;
    }

    public static boolean isEOF(Token token) {
        assert (token != null);
        return token == null || APTUtils.isEOF(token.getType());
    }

    public static boolean isEOF(int n) {
        return n == 1;
    }

    public static boolean isVaArgsToken(Token token) {
        return token != null && token.getText().equals(VA_ARGS_TOKEN.getText());
    }

    public static boolean isStartCondition(Token token) {
        return APTUtils.isStartCondition(token.getType());
    }

    public static boolean isStartCondition(int n) {
        switch (n) {
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStartConditionNode(int n) {
        switch (n) {
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStartOrSwitchConditionNode(int n) {
        switch (n) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndCondition(Token token) {
        return APTUtils.isEndCondition(token.getType());
    }

    public static boolean isEndCondition(int n) {
        switch (n) {
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static boolean isConditionsBlockToken(Token token) {
        assert (token != null);
        return APTUtils.isConditionsBlockToken(token.getType());
    }

    public static boolean isConditionsBlockToken(int n) {
        switch (n) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCommentToken(Token token) {
        assert (token != null);
        return APTUtils.isCommentToken(token.getType());
    }

    public static boolean isCommentToken(int n) {
        switch (n) {
            case 217: 
            case 218: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOpenBracket(Token token) {
        assert (token != null);
        return APTUtils.isOpenBracket(token.getType());
    }

    public static boolean isOpenBracket(int n) {
        switch (n) {
            case 137: 
            case 139: 
            case 141: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCloseBracket(Token token) {
        assert (token != null);
        return APTUtils.isCloseBracket(token.getType());
    }

    public static boolean isCloseBracket(int n) {
        switch (n) {
            case 138: 
            case 140: 
            case 142: {
                return true;
            }
        }
        return false;
    }

    public static int getMatchBracket(int n) {
        switch (n) {
            case 142: {
                return 141;
            }
            case 138: {
                return 137;
            }
            case 140: {
                return 139;
            }
            case 141: {
                return 142;
            }
            case 137: {
                return 138;
            }
            case 139: {
                return 140;
            }
        }
        return 1;
    }

    public static boolean isEndDirectiveToken(int n) {
        switch (n) {
            case 1: 
            case 207: {
                return true;
            }
        }
        return false;
    }

    public static List<Token> toList(TokenStream tokenStream) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        try {
            Token token = tokenStream.nextToken();
            while (!APTUtils.isEOF(token)) {
                assert (token != null) : "list of tokens must not have 'null' elements";
                arrayList.add(token);
                token = tokenStream.nextToken();
            }
        }
        catch (TokenStreamException tokenStreamException) {
            LOG.log(Level.INFO, "error on converting token stream to list", tokenStreamException.getMessage());
        }
        return arrayList;
    }

    public static Object getTextKey(String string) {
        assert (string != null);
        assert (string.length() > 0);
        return string;
    }

    public static String getTokenTextKey(Token token) {
        assert (token != null);
        return token.getText();
    }

    public static APTToken createAPTToken(Token token, int n) {
        APTToken aPTToken = null;
        aPTToken = APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken(token, n) : new APTBaseToken(token, n);
        return aPTToken;
    }

    public static APTToken createAPTToken(Token token) {
        return APTUtils.createAPTToken(token, token.getType());
    }

    public static APTToken createAPTToken() {
        APTToken aPTToken = null;
        aPTToken = APTTraceFlags.USE_APT_TEST_TOKEN ? new APTTestToken() : new APTBaseToken();
        return aPTToken;
    }

    static {
        Object object = System.getProperty("org.netbeans.modules.cnd.apt.level");
        if (object == null) {
            if (APTTraceFlags.TRACE_APT | APTTraceFlags.TRACE_APT_LEXER) {
                LOG.setLevel(Level.ALL);
            } else {
                LOG.setLevel(Level.SEVERE);
            }
        } else {
            LOG.setLevel(Level.parse((String)object));
        }
        VA_ARGS_TOKEN = APTUtils.createAPTToken();
        VA_ARGS_TOKEN.setType(204);
        VA_ARGS_TOKEN.setText("__VA_ARGS__");
        EMPTY_ID_TOKEN = APTUtils.createAPTToken();
        EMPTY_ID_TOKEN.setType(204);
        EMPTY_ID_TOKEN.setText("");
        COMMA_TOKEN = APTUtils.createAPTToken();
        COMMA_TOKEN.setType(133);
        COMMA_TOKEN.setText(",");
        object = APTUtils.createAPTToken();
        object.setType(203);
        object.setText("1");
        DEF_MACRO_BODY = new ArrayList<Token>();
        DEF_MACRO_BODY.add((Token)object);
        EOF_TOKEN = new APTEOFToken();
        EMPTY_STREAM = new TokenStream(){

            public Token nextToken() throws TokenStreamException {
                return EOF_TOKEN;
            }
        };
    }

    private static class APTEOFToken
    extends APTTokenAbstact {
        public int getOffset() {
            throw new UnsupportedOperationException("getOffset must not be used");
        }

        public void setOffset(int n) {
            throw new UnsupportedOperationException("setOffset must not be used");
        }

        public int getEndOffset() {
            throw new UnsupportedOperationException("getEndOffset must not be used");
        }

        public void setEndOffset(int n) {
            throw new UnsupportedOperationException("setEndOffset must not be used");
        }

        public int getTextID() {
            throw new UnsupportedOperationException("getTextID must not be used");
        }

        public void setTextID(int n) {
            throw new UnsupportedOperationException("setTextID must not be used");
        }

        public int getEndColumn() {
            throw new UnsupportedOperationException("getEndColumn must not be used");
        }

        public void setEndColumn(int n) {
            throw new UnsupportedOperationException("setEndColumn must not be used");
        }

        public int getEndLine() {
            throw new UnsupportedOperationException("getEndLine must not be used");
        }

        public void setEndLine(int n) {
            throw new UnsupportedOperationException("setEndLine must not be used");
        }

        public int getType() {
            return 1;
        }
    }
}

