/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.modules.ruby.platform.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Gem
implements Comparable<Gem> {
    private String name;
    private String desc;
    private String installedVersions;
    private String availableVersions;

    public Gem(String string, String string2, String string3) {
        this.name = string;
        this.installedVersions = string2;
        this.availableVersions = string3;
    }

    public String getName() {
        return this.name;
    }

    public String getInstalledVersionsAsString() {
        return this.installedVersions;
    }

    String getLatestInstalled() {
        return Gem.getLatestVersion(this.installedVersions);
    }

    SortedSet<String> getAvailableVersions() {
        return Gem.getVersions(this.availableVersions);
    }

    public String getAvailableVersionsAsString() {
        return this.availableVersions;
    }

    String getLatestAvailable() {
        return Gem.getLatestVersion(this.availableVersions);
    }

    boolean hasUpdateAvailable() {
        String string = this.getLatestAvailable();
        return string != null && Util.compareVersions(string, this.getLatestInstalled()) > 0;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("<html><b>");
        stringBuilder.append(this.name);
        stringBuilder.append("</b>");
        if (this.installedVersions != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this.installedVersions);
            if (this.availableVersions != null) {
                stringBuilder.append(" => ").append(this.availableVersions);
            }
            stringBuilder.append(") ");
        }
        if (this.desc != null) {
            stringBuilder.append(": ");
            stringBuilder.append(this.desc);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Gem gem) {
        return this.name.compareTo(gem.name);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setAvailableVersions(String string) {
        this.availableVersions = string;
    }

    public void setInstalledVersions(String string) {
        this.installedVersions = string;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    private static String getLatestVersion(String string) {
        SortedSet<String> sortedSet = Gem.getVersions(string);
        if (sortedSet.isEmpty()) {
            return null;
        }
        return sortedSet.last();
    }

    private static SortedSet<String> getVersions(String string) {
        if (string == null) {
            return new TreeSet<String>();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        TreeSet<String> treeSet = new TreeSet<String>(Util.VERSION_COMPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            treeSet.add(stringTokenizer.nextToken());
        }
        return treeSet;
    }
}

