/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.GemPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RubyPlatformCustomizer
extends JPanel {
    private static final String LAST_PLATFORM_DIRECTORY = "lastPlatformDirectory";
    private static String lastSelectedPlatformID;
    private JButton addButton;
    private JButton addGemPath;
    private JButton autoDetectButton;
    private JLabel autoDetectLabel;
    private JProgressBar autoDetectProgress;
    private JButton browseGemHome;
    private JPanel configPanel;
    private JPanel debuggerPanel;
    private JLabel engineLabel;
    private JLabel engineType;
    private JLabel gemHome;
    private JTextField gemHomeValue;
    private JLabel gemPath;
    private JList gemPathList;
    private JScrollPane gemPathSP;
    private JLabel gemTool;
    private JTextField gemToolValue;
    private JButton installFastDebugger;
    private JLabel platformsLabel;
    private JList platformsList;
    private JScrollPane platformsListSP;
    private JLabel plfInterpreter;
    private JTextField plfInterpreterValue;
    private JLabel plfName;
    private JTextField plfNameValue;
    private JPanel progressPanel;
    private JButton removeButton;
    private JButton removeGemPath;
    private JLabel rubyDebuggerLabel;
    private JSeparator upperSep;

    public static void showCustomizer() {
        RubyPlatformCustomizer rubyPlatformCustomizer = new RubyPlatformCustomizer();
        JButton jButton = new JButton();
        jButton.getAccessibleContext().setAccessibleDescription(RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.closeButton.AccessibleContext.accessibleName"));
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"CTL_Close"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rubyPlatformCustomizer, RubyPlatformCustomizer.getMessage("CTL_RubyPlatformManager_Title"), true, new Object[]{jButton}, (Object)jButton, 0, new HelpCtx(RubyPlatformCustomizer.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public RubyPlatformCustomizer() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.AccessibleContext.accessibleDescription"));
        this.refreshPlatformList();
        this.gemPathList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RubyPlatformCustomizer.this.removeGemPath.setEnabled(RubyPlatformCustomizer.this.gemPathList.getSelectedValue() != null);
            }
        });
        this.platformsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RubyPlatformCustomizer.this.refreshPlatform();
            }
        });
        if (RubyPreferences.isFirstPlatformTouch()) {
            this.performPlatformDetection();
        } else {
            this.setAutoDetecting(false);
        }
    }

    public static void manage(JComboBox jComboBox) {
        RubyPlatformCustomizer.showCustomizer();
        RubyPlatform rubyPlatform = (RubyPlatform)jComboBox.getSelectedItem();
        jComboBox.setModel(new PlatformComponentFactory.RubyPlatformListModel());
        jComboBox.setSelectedItem(rubyPlatform);
        jComboBox.requestFocus();
    }

    private RubyPlatform getSelectedPlatform() {
        return (RubyPlatform)this.platformsList.getSelectedValue();
    }

    private void refreshPlatformList() {
        if (this.platformsList.getModel().getSize() > 0) {
            RubyPlatform rubyPlatform;
            this.platformsList.setSelectedIndex(0);
            if (lastSelectedPlatformID != null && (rubyPlatform = RubyPlatformManager.getPlatformByID(lastSelectedPlatformID)) != null) {
                this.platformsList.setSelectedValue(rubyPlatform, true);
            }
        }
        this.refreshPlatform();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(RubyPlatformCustomizer.class, (String)string);
    }

    private void performPlatformDetection() {
        this.setAutoDetecting(true);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RubyPlatformManager.performPlatformDetection();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        RubyPlatformCustomizer.this.platformsList.setModel(new PlatformComponentFactory.RubyPlatformListModel());
                        RubyPlatformCustomizer.this.refreshPlatformList();
                        RubyPlatformCustomizer.this.setAutoDetecting(false);
                    }
                });
            }
        });
    }

    private void setAutoDetecting(boolean bl) {
        this.autoDetectButton.setEnabled(!bl);
        this.addButton.setEnabled(!bl);
        this.autoDetectProgress.setVisible(bl);
        this.autoDetectLabel.setVisible(bl);
    }

    private void refreshPlatform() {
        Color color;
        RubyPlatform rubyPlatform = this.getSelectedPlatform();
        if (rubyPlatform == null) {
            this.removeButton.setEnabled(false);
            return;
        }
        lastSelectedPlatformID = rubyPlatform.getID();
        this.plfNameValue.setText(rubyPlatform.getInfo().getLongDescription());
        this.plfInterpreterValue.setText(rubyPlatform.getInterpreter());
        boolean bl = rubyPlatform.hasRubyGemsInstalled();
        if (bl) {
            this.gemHomeValue.setText(rubyPlatform.getGemManager().getGemHome());
            this.gemPathList.setModel(this.createGemPathsModel(rubyPlatform));
            this.gemToolValue.setText(rubyPlatform.getGemManager().getGemTool() + " (" + rubyPlatform.getInfo().getGemVersion() + ')');
            color = UIManager.getColor("Label.foreground");
        } else {
            color = PlatformComponentFactory.INVALID_PLAF_COLOR;
            String string = GemManager.getNotInstalledMessage();
            this.gemHomeValue.setText(string);
            this.gemToolValue.setText(string);
        }
        this.browseGemHome.setEnabled(bl);
        this.gemHomeValue.setForeground(color);
        this.gemToolValue.setForeground(color);
        this.removeButton.setEnabled(!rubyPlatform.isDefault());
        this.removeGemPath.setEnabled(this.gemPathList.getSelectedValue() != null);
        this.refreshDebugger();
    }

    private ListModel createGemPathsModel(RubyPlatform rubyPlatform) {
        return new GemPathsListModel(rubyPlatform);
    }

    private GemPathsListModel getGemPathListModel() {
        return (GemPathsListModel)this.gemPathList.getModel();
    }

    private void initComponents() {
        this.platformsLabel = new JLabel();
        this.platformsListSP = new JScrollPane();
        this.platformsList = PlatformComponentFactory.getRubyPlatformsList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.autoDetectButton = new JButton();
        this.configPanel = new JPanel();
        this.gemTool = new JLabel();
        this.gemToolValue = new JTextField();
        this.gemHome = new JLabel();
        this.gemHomeValue = new JTextField();
        this.browseGemHome = new JButton();
        this.gemPath = new JLabel();
        this.plfInterpreter = new JLabel();
        this.plfInterpreterValue = new JTextField();
        this.plfName = new JLabel();
        this.plfNameValue = new JTextField();
        this.gemPathSP = new JScrollPane();
        this.gemPathList = new JList();
        this.addGemPath = new JButton();
        this.removeGemPath = new JButton();
        this.progressPanel = new JPanel();
        this.autoDetectLabel = new JLabel();
        this.autoDetectProgress = new JProgressBar();
        this.debuggerPanel = new JPanel();
        this.rubyDebuggerLabel = new JLabel();
        this.upperSep = new JSeparator();
        this.engineLabel = new JLabel();
        this.engineType = new JLabel();
        this.installFastDebugger = new JButton();
        this.platformsLabel.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.platformsLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.platformsLabel.text"));
        this.platformsList.setSelectionMode(0);
        this.platformsListSP.setViewportView(this.platformsList);
        this.platformsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.platformsList.AccessibleContext.accessibleName"));
        this.platformsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.platformsList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RubyPlatformCustomizer.this.addButtonaddPlatform(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RubyPlatformCustomizer.this.removeButtonremovePlatform(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.autoDetectButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.autoDetectButton.text"));
        this.autoDetectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RubyPlatformCustomizer.this.autoDetectButtonremovePlatform(actionEvent);
            }
        });
        this.gemTool.setLabelFor(this.gemToolValue);
        Mnemonics.setLocalizedText((JLabel)this.gemTool, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemTool.text"));
        this.gemToolValue.setEditable(false);
        this.gemHome.setLabelFor(this.gemHomeValue);
        Mnemonics.setLocalizedText((JLabel)this.gemHome, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemHome.text"));
        this.gemHomeValue.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseGemHome, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.browseGemHome.text"));
        this.browseGemHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RubyPlatformCustomizer.this.browseGemHomeActionPerformed(actionEvent);
            }
        });
        this.gemPath.setLabelFor(this.gemPathList);
        Mnemonics.setLocalizedText((JLabel)this.gemPath, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemPath.text"));
        this.plfInterpreter.setLabelFor(this.plfInterpreterValue);
        Mnemonics.setLocalizedText((JLabel)this.plfInterpreter, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfInterpreter.text"));
        this.plfInterpreterValue.setEditable(false);
        this.plfName.setLabelFor(this.plfNameValue);
        Mnemonics.setLocalizedText((JLabel)this.plfName, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfName.text"));
        this.plfNameValue.setEditable(false);
        this.gemPathSP.setViewportView(this.gemPathList);
        this.gemPathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemPathList.AccessibleContext.accessibleName"));
        this.gemPathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemPathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addGemPath, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addGemPath.text"));
        this.addGemPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RubyPlatformCustomizer.this.addGemPathActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeGemPath, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeGemPath.text"));
        this.removeGemPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RubyPlatformCustomizer.this.removeGemPathActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.configPanel);
        this.configPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.plfInterpreter).add((Component)this.plfName).add((Component)this.gemHome).add((Component)this.gemPath).add((Component)this.gemTool)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.gemHomeValue, -1, 287, Short.MAX_VALUE).add((Component)this.gemPathSP, -1, 287, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.removeGemPath).add((Component)this.addGemPath).add((Component)this.browseGemHome))).add((Component)this.plfInterpreterValue, -1, 382, Short.MAX_VALUE).add((Component)this.plfNameValue, -1, 382, Short.MAX_VALUE).add((Component)this.gemToolValue, -1, 382, Short.MAX_VALUE))));
        groupLayout.linkSize(new Component[]{this.gemHome, this.gemTool, this.plfInterpreter, this.plfName}, 1);
        groupLayout.linkSize(new Component[]{this.addGemPath, this.browseGemHome, this.removeGemPath}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.plfName).add((Component)this.plfNameValue, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.plfInterpreter).add((Component)this.plfInterpreterValue, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.gemHome).add((Component)this.gemHomeValue, -2, -1, -2).add((Component)this.browseGemHome)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.gemPath).add((Component)this.gemPathSP, -2, 68, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addGemPath).addPreferredGap(0).add((Component)this.removeGemPath))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.gemTool).add((Component)this.gemToolValue, -2, -1, -2))));
        this.gemToolValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemToolValue.AccessibleContext.accessibleDescription"));
        this.gemHomeValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemHomeValue.AccessibleContext.accessibleDescription"));
        this.browseGemHome.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.browseGemHome.AccessibleContext.accessibleDescription"));
        this.plfInterpreterValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfInterpreterValue.AccessibleContext.accessibleDescription"));
        this.plfNameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfNameValue.AccessibleContext.accessibleDescription"));
        this.addGemPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addGemPath.AccessibleContext.accessibleDescription"));
        this.removeGemPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeGemPath.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.autoDetectLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.autoDetectLabel.text"));
        this.progressPanel.add(this.autoDetectLabel);
        this.autoDetectProgress.setIndeterminate(true);
        this.progressPanel.add(this.autoDetectProgress);
        Mnemonics.setLocalizedText((JLabel)this.rubyDebuggerLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.rubyDebuggerLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.engineLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.engineLabel.text"));
        this.engineType.setFont(this.engineType.getFont().deriveFont(this.engineType.getFont().getStyle() | 2));
        Mnemonics.setLocalizedText((JLabel)this.engineType, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.classicDebuggerEngine.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installFastDebugger, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.installFastDebugger.text"));
        this.installFastDebugger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RubyPlatformCustomizer.this.installFastDebuggerActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.debuggerPanel);
        this.debuggerPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.rubyDebuggerLabel).addPreferredGap(0).add((Component)this.upperSep, -1, 369, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.engineLabel).addPreferredGap(0).add((Component)this.engineType).addPreferredGap(0).add((Component)this.installFastDebugger))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(4).add((Component)this.rubyDebuggerLabel).add((Component)this.upperSep, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.engineLabel).add((Component)this.engineType).add((Component)this.installFastDebugger)).addContainerGap(-1, Short.MAX_VALUE)));
        this.installFastDebugger.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.installFastDebugger.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.platformsLabel).add((Component)this.platformsListSP, -2, 235, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.debuggerPanel, -1, -1, Short.MAX_VALUE).add((Component)this.configPanel, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton).addPreferredGap(0).add((Component)this.autoDetectButton).addPreferredGap(0, 22, Short.MAX_VALUE).add((Component)this.progressPanel, -2, -1, -2))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.platformsLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.platformsListSP, -1, 287, Short.MAX_VALUE).add(6, 6, 6)).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.configPanel, -2, -1, -2).add(18, 18, 18).add((Component)this.debuggerPanel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.autoDetectButton)).add((Component)this.progressPanel, -2, 25, -2)).addContainerGap()));
        groupLayout3.linkSize(new Component[]{this.addButton, this.autoDetectButton, this.progressPanel, this.removeButton}, 2);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeButton.AccessibleContext.accessibleDescription"));
        this.autoDetectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.autoDetectButton.AccessibleContext.accessibleDescription"));
    }

    private PlatformComponentFactory.RubyPlatformListModel getPlafListModel() {
        return (PlatformComponentFactory.RubyPlatformListModel)this.platformsList.getModel();
    }

    private void addButtonaddPlatform(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(RubyPreferences.getPreferences().get(LAST_PLATFORM_DIRECTORY, ""));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || RubyPlatformCustomizer.this.isRuby(file);
            }

            public String getDescription() {
                return RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.rubyPlatform");
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            final File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            RubyPreferences.getPreferences().put(LAST_PLATFORM_DIRECTORY, file.getParentFile().getAbsolutePath());
            this.setAutoDetecting(true);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final RubyPlatform rubyPlatform = RubyPlatformCustomizer.this.getPlafListModel().addPlatform(file);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (rubyPlatform == null) {
                                Util.notifyLocalized(RubyPlatformCustomizer.class, "RubyPlatformCustomizer.invalid.platform.added", file.getAbsolutePath());
                            } else {
                                RubyPlatformCustomizer.this.refreshPlatform();
                            }
                            RubyPlatformCustomizer.this.setAutoDetecting(false);
                        }
                    });
                }
            });
        }
    }

    private boolean isRuby(File file) {
        String string = file.getName().toLowerCase(Locale.US);
        return file.isFile() && (string.contains("ruby") || string.contains("rubinius"));
    }

    private void removeButtonremovePlatform(ActionEvent actionEvent) {
        RubyPlatform rubyPlatform = this.getSelectedPlatform();
        if (rubyPlatform != null) {
            this.getPlafListModel().removePlatform(rubyPlatform);
            this.platformsList.setSelectedValue(RubyPlatformManager.getDefaultPlatform(), true);
            this.refreshPlatform();
            this.platformsList.requestFocusInWindow();
        }
    }

    private void autoDetectButtonremovePlatform(ActionEvent actionEvent) {
        this.performPlatformDetection();
        this.platformsList.requestFocusInWindow();
    }

    private void installFastDebuggerActionPerformed(ActionEvent actionEvent) {
        if (this.getSelectedPlatform().isJRuby()) {
            Util.notifyLocalized(RubyPlatformCustomizer.class, "RubyPlatformCustomizer.instructionsToInstallJRubyDebugger", this.getSelectedPlatform().getFastDebuggerProblemsInHTML());
        } else if (this.getSelectedPlatform().installFastDebugger()) {
            this.refreshDebugger();
        }
    }

    private void browseGemHomeActionPerformed(ActionEvent actionEvent) {
        boolean bl = GemPanel.chooseAndSetGemHome(this, this.getSelectedPlatform());
        if (bl) {
            this.refreshPlatform();
        }
    }

    private void addGemPathActionPerformed(ActionEvent actionEvent) {
        File file = GemPanel.chooseGemRepository(this);
        if (file != null) {
            String string = file.getAbsolutePath();
            if (!this.getGemPathListModel().getPaths().contains(string)) {
                this.getGemPathListModel().addPath(file);
                this.refreshPlatform();
                this.gemPathList.requestFocus();
                this.gemPathList.setSelectedValue(string, true);
            }
        }
    }

    private void removeGemPathActionPerformed(ActionEvent actionEvent) {
        this.getGemPathListModel().removePath((File)this.gemPathList.getSelectedValue());
        this.refreshPlatform();
        if (this.getGemPathListModel().getSize() > 0) {
            this.gemPathList.setSelectedIndex(0);
        }
        this.gemPathList.requestFocus();
    }

    private void refreshDebugger() {
        RubyPlatform rubyPlatform = this.getSelectedPlatform();
        boolean bl = !rubyPlatform.isRubinius();
        boolean bl2 = rubyPlatform.hasFastDebuggerInstalled();
        this.installFastDebugger.setEnabled(bl && rubyPlatform.hasRubyGemsInstalled());
        this.installFastDebugger.setVisible(bl && !bl2);
        String string = rubyPlatform.isRubinius() ? "RubyPlatformCustomizer.noFastDebuggerForRubiniusYet.text" : (rubyPlatform.hasFastDebuggerInstalled() ? "RubyPlatformCustomizer.rubyDebugEngine.text" : "RubyPlatformCustomizer.classicDebuggerEngine.text");
        this.engineType.setText(RubyPlatformCustomizer.getMessage(string));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GemPathsListModel
    extends AbstractListModel {
        private final RubyPlatform platform;

        GemPathsListModel(RubyPlatform rubyPlatform) {
            this.platform = rubyPlatform;
        }

        @Override
        public Object getElementAt(int n) {
            return n >= this.getSize() ? null : this.getPaths().toArray()[n];
        }

        @Override
        public int getSize() {
            return this.getPaths().size();
        }

        void addPath(File file) {
            this.platform.getGemManager().addGemPath(file);
            super.fireIntervalAdded(this, 0, this.getSize());
        }

        void removePath(File file) {
            this.platform.getGemManager().removeGemPath(file);
            super.fireIntervalRemoved(this, 0, this.getSize());
        }

        private Set<File> getPaths() {
            return this.platform.getGemManager().getGemPath();
        }
    }
}

