/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SceneLayerTableAdapter
implements TableModel,
SceneListener,
PropertyChangeListener {
    public static final boolean DEBUG = false;
    private static final int COLS = 7;
    public static final int COL_INDEX_LAYER_TYPE = 0;
    public static final int COL_INDEX_LAYER_INDEX = 1;
    public static final int COL_INDEX_LAYER_VISIBILITY_INDICATOR = 2;
    public static final int COL_INDEX_LAYER_LOCK_INDICATOR = 3;
    public static final int COL_INDEX_LAYER_NAME = 4;
    public static final int COL_INDEX_LAYER_POS_X = 5;
    public static final int COL_INDEX_LAYER_POS_Y = 6;
    private Scene scene;
    private ArrayList listeners = new ArrayList();

    public SceneLayerTableAdapter(Scene scene) {
        this.scene = scene;
        this.scene.addSceneListener(this);
    }

    public int getColumnCount() {
        return 7;
    }

    public int getRowCount() {
        return this.scene.getLayerCount();
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        return n2 != 5 && n2 != 6 || !this.scene.isLayerLocked(this.scene.getLayerAt(n));
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Layer.class;
        }
        if (n == 1) {
            return Integer.class;
        }
        if (n == 2) {
            return Boolean.class;
        }
        if (n == 3) {
            return Boolean.class;
        }
        if (n == 4) {
            return String.class;
        }
        if (n == 5) {
            return Integer.class;
        }
        if (n == 6) {
            return Integer.class;
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.scene.getLayerCount() || n2 < 0 || n2 >= 7) {
            return null;
        }
        Layer layer = this.scene.getLayerAt(n);
        switch (n2) {
            case 0: {
                return layer;
            }
            case 1: {
                return new Integer(this.scene.indexOf(layer));
            }
            case 2: {
                return new Boolean(this.scene.isLayerVisible(layer));
            }
            case 3: {
                return new Boolean(this.scene.isLayerLocked(layer));
            }
            case 4: {
                return layer.getName();
            }
            case 5: {
                return new Integer(this.scene.getLayerPosition((Layer)layer).x);
            }
            case 6: {
                return new Integer(this.scene.getLayerPosition((Layer)layer).y);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n >= this.scene.getLayerCount() || n2 < 0 || n2 >= 7) {
            throw new IllegalArgumentException("Arguments rowIndex = " + n + ", columnIndex = " + n2 + " are illegal for table of " + this.scene.getLayerCount() + " rows and " + 7 + " columns.");
        }
        Layer layer = this.scene.getLayerAt(n);
        switch (n2) {
            case 1: {
                Integer n3 = (Integer)object;
                int n4 = n3;
                this.scene.move(layer, n4);
                break;
            }
            case 2: {
                boolean bl = (Boolean)object;
                this.scene.setLayerVisible(layer, bl);
                break;
            }
            case 3: {
                boolean bl = (Boolean)object;
                this.scene.setLayerLocked(layer, bl);
                break;
            }
            case 4: {
                String string = (String)object;
                if (string.equals(layer.getName())) {
                    return;
                }
                if (!this.scene.getGameDesign().isComponentNameAvailable(string)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SceneLayerTableAdapter.class, (String)"SceneLayerTableAdapter.noRenameDialog.txt", (Object)string), 0));
                    break;
                }
                layer.setName(string);
                break;
            }
            case 5: {
                Integer n5 = (Integer)object;
                this.scene.setLayerPositionX(layer, n5, false);
                break;
            }
            case 6: {
                Integer n6 = (Integer)object;
                this.scene.setLayerPositionY(layer, n6, false);
            }
        }
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Z";
            }
            case 2: {
                return "View";
            }
            case 3: {
                return "Lock";
            }
            case 4: {
                return "Name";
            }
            case 5: {
                return "X";
            }
            case 6: {
                return "Y";
            }
        }
        return "???";
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    private void fireTableChanged(TableModelEvent tableModelEvent) {
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Layer) {
            Layer layer = (Layer)propertyChangeEvent.getSource();
            int n = this.scene.indexOf(layer);
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, 0);
            this.fireTableChanged(tableModelEvent);
        }
    }

    public void layerAdded(Scene scene, Layer layer, int n) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, 1);
        layer.addPropertyChangeListener(this);
        this.fireTableChanged(tableModelEvent);
    }

    public void layerRemoved(Scene scene, Layer layer, Scene.LayerInfo layerInfo, int n) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, -1);
        layer.removePropertyChangeListener(this);
        this.fireTableChanged(tableModelEvent);
    }

    public void layerModified(Scene scene, Layer layer) {
        int n = scene.indexOf(layer);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, 0);
        this.fireTableChanged(tableModelEvent);
    }

    public void layerMoved(Scene scene, Layer layer, int n, int n2) {
        this.layerRemoved(scene, layer, null, n);
        this.layerAdded(scene, layer, n2);
    }

    public void layerLockChanged(Scene scene, Layer layer, boolean bl) {
        this.layerModified(scene, layer);
    }

    public void layerPositionChanged(Scene scene, Layer layer, Point point, Point point2, boolean bl) {
        this.layerModified(scene, layer);
    }

    public void layerVisibilityChanged(Scene scene, Layer layer, boolean bl) {
        this.layerModified(scene, layer);
    }
}

