/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.CodeUtils;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResourceListener;
import org.netbeans.modules.vmd.game.model.ImageUtils;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.model.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageResource
implements Identifiable {
    private long id = -1L;
    public static final boolean DEBUG = false;
    private GlobalRepository gameDesign;
    EventListenerList listenerList = new EventListenerList();
    private URL imageURL;
    private String relativeResourcePath;
    private String name;
    private Map<Key, StaticTile> emptyTiles = new HashMap<Key, StaticTile>();
    private Map<Key, StaticTile[][]> staticTileGrids = new HashMap<Key, StaticTile[][]>();
    private Map<Integer, AnimatedTile> animatedTiles = new HashMap<Integer, AnimatedTile>();
    private int animatedTileIndexKey = -1;
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private static HashMap imgSoftReferences = new HashMap();

    private static BufferedImage softenImage(URL uRL) {
        BufferedImage bufferedImage = null;
        SoftReference softReference = (SoftReference)imgSoftReferences.get(uRL);
        if (softReference != null) {
            bufferedImage = (BufferedImage)softReference.get();
        }
        if (bufferedImage == null) {
            bufferedImage = ImageUtils.loadImage(uRL);
            imgSoftReferences.put(uRL, new SoftReference<BufferedImage>(bufferedImage));
        }
        return bufferedImage;
    }

    ImageResource(GlobalRepository globalRepository, URL uRL, String string) {
        assert (globalRepository != null);
        this.gameDesign = globalRepository;
        this.imageURL = uRL;
        this.relativeResourcePath = string;
        this.name = globalRepository.getNextAvailableComponentName(CodeUtils.getIdealImageName(string));
    }

    public void addImageResourceListener(ImageResourceListener imageResourceListener) {
        this.listenerList.add(ImageResourceListener.class, imageResourceListener);
    }

    public void removeImageResourceListener(ImageResourceListener imageResourceListener) {
        this.listenerList.remove(ImageResourceListener.class, imageResourceListener);
    }

    public Sequence createSequence(String string, int n, int n2, int n3, boolean bl) {
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Sequence cannot be created because component name '" + string + "' already exists.");
        }
        Sequence sequence = new Sequence(string, this, n, n2, n3, bl);
        this.sequences.add(sequence);
        this.fireSequenceAdded(sequence);
        return sequence;
    }

    public Sequence createSequence(String string, Sequence sequence) {
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("Sequence cannot be created because component name '" + string + "' already exists.");
        }
        Sequence sequence2 = new Sequence(string, sequence);
        this.sequences.add(sequence2);
        this.fireSequenceAdded(sequence2);
        return sequence2;
    }

    public Sequence getSequenceByName(String string) {
        for (Sequence sequence : this.sequences) {
            if (!sequence.getName().equals(string)) continue;
            return sequence;
        }
        return null;
    }

    public Sequence getSequence(long l) {
        for (Sequence sequence : this.sequences) {
            if (sequence.getId() != l) continue;
            return sequence;
        }
        return null;
    }

    public void fireSequenceAdded(Sequence sequence) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ImageResourceListener.class) continue;
            ((ImageResourceListener)objectArray[i + 1]).sequenceAdded(this, sequence);
        }
    }

    public void removeSequence(Sequence sequence) {
        this.sequences.remove(sequence);
        this.fireSequenceRemoved(sequence);
    }

    public void fireSequenceRemoved(Sequence sequence) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ImageResourceListener.class) continue;
            ((ImageResourceListener)objectArray[i + 1]).sequenceRemoved(this, sequence);
        }
    }

    public List getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    public AnimatedTile createAnimatedTile(int n, String string, int n2, int n3, int n4) {
        assert (n < 0);
        assert (this.animatedTiles.get(n) == null);
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("AnimatedTile cannot be created because component name '" + string + "' already exists.");
        }
        if (this.animatedTileIndexKey >= n) {
            this.animatedTileIndexKey = n - 1;
        }
        AnimatedTile animatedTile = new AnimatedTile(string, this, n, n3, n4);
        Sequence sequence = animatedTile.getDefaultSequence();
        sequence.setFrame(new StaticTile(this, n2, n3, n4, false), 0);
        this.animatedTiles.put(n, animatedTile);
        this.fireAnimatedTileAdded(animatedTile);
        return animatedTile;
    }

    public AnimatedTile createAnimatedTile(String string, int n, int n2, int n3) {
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("AnimatedTile cannot be created because component name '" + string + "' already exists.");
        }
        int n4 = this.animatedTileIndexKey--;
        return this.createAnimatedTile(n4, string, n, n2, n3);
    }

    public AnimatedTile createAnimatedTile(int n, String string, Sequence sequence) {
        assert (n < 0);
        assert (this.animatedTiles.get(n) == null);
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("AnimatedTile cannot be created because component name '" + string + "' already exists.");
        }
        if (this.animatedTileIndexKey >= n) {
            this.animatedTileIndexKey = n - 1;
        }
        AnimatedTile animatedTile = new AnimatedTile(string, this, n, sequence, sequence.getFrameWidth(), sequence.getFrameHeight());
        this.animatedTiles.put(n, animatedTile);
        this.fireAnimatedTileAdded(animatedTile);
        return animatedTile;
    }

    public AnimatedTile createAnimatedTile(String string, Sequence sequence) {
        if (!this.gameDesign.isComponentNameAvailable(string)) {
            throw new IllegalArgumentException("AnimatedTile cannot be created because component name '" + string + "' already exists.");
        }
        int n = this.animatedTileIndexKey--;
        return this.createAnimatedTile(n, string, sequence);
    }

    public void fireAnimatedTileAdded(AnimatedTile animatedTile) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ImageResourceListener.class) continue;
            ((ImageResourceListener)objectArray[i + 1]).animatedTileAdded(this, animatedTile);
        }
    }

    public void removeAnimatedTile(int n) {
        AnimatedTile animatedTile = this.animatedTiles.remove(new Integer(n));
        this.fireAnimatedTileRemoved(animatedTile);
    }

    public void fireAnimatedTileRemoved(AnimatedTile animatedTile) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ImageResourceListener.class) continue;
            ((ImageResourceListener)objectArray[i + 1]).animatedTileRemoved(this, animatedTile);
        }
    }

    public AnimatedTile getAnimatedTile(long l) {
        Collection<AnimatedTile> collection = this.animatedTiles.values();
        for (AnimatedTile animatedTile : collection) {
            if (animatedTile.getId() != l) continue;
            return animatedTile;
        }
        return null;
    }

    public AnimatedTile getAnimatedTileByName(String string) {
        Collection<AnimatedTile> collection = this.animatedTiles.values();
        for (AnimatedTile animatedTile : collection) {
            if (!animatedTile.getName().equals(string)) continue;
            return animatedTile;
        }
        return null;
    }

    public StaticTile getEmptyTile(int n, int n2) {
        StaticTile staticTile = this.emptyTiles.get(ImageResource.getGridKey(n, n2, false));
        if (staticTile == null) {
            staticTile = new StaticTile(this, 0, n, n2, false);
            this.emptyTiles.put(ImageResource.getGridKey(n, n2, false), staticTile);
        }
        return staticTile;
    }

    private StaticTile[][] getStaticTileGrid(int n, int n2, boolean bl) {
        StaticTile[][] staticTileArray = this.staticTileGrids.get(ImageResource.getGridKey(n, n2, bl));
        if (staticTileArray == null) {
            staticTileArray = this.initStaticTileGrid(n, n2, bl);
        }
        return staticTileArray;
    }

    public Set<Dimension> getTileResolutions() {
        Set<Key> set = this.staticTileGrids.keySet();
        HashSet<Dimension> hashSet = new HashSet<Dimension>();
        for (Key key : set) {
            hashSet.add(new Dimension(key.getTileWidth(), key.getTileHeight()));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static Key getGridKey(int n, int n2, boolean bl) {
        return new Key(n, n2, bl);
    }

    public int getStaticTileCount(int n, int n2) {
        return this.getRowCount(n, n2) * this.getColumnCount(n, n2);
    }

    public int getStaticTileIndex(int n, int n2, int n3, int n4, boolean bl) {
        return this.getStaticTileAt(n, n2, n3, n4, bl).getIndex();
    }

    public Tile getTile(int n, int n2, int n3, boolean bl) {
        if (bl) {
            return new StaticTile(this, n, n2, n3, bl);
        }
        if (n == 0) {
            return this.getEmptyTile(n2, n3);
        }
        if (n > 0) {
            return new StaticTile(this, n, n2, n3, bl);
        }
        return this.animatedTiles.get(new Integer(n));
    }

    public List<AnimatedTile> getAnimatedTiles() {
        ArrayList<AnimatedTile> arrayList = new ArrayList<AnimatedTile>(this.animatedTiles.values());
        Collections.sort(arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public List<AnimatedTile> getAnimatedTiles(int n, int n2) {
        ArrayList<AnimatedTile> arrayList = new ArrayList<AnimatedTile>();
        for (AnimatedTile animatedTile : this.animatedTiles.values()) {
            if (animatedTile.getWidth() != n || animatedTile.getHeight() != n2) continue;
            arrayList.add(animatedTile);
        }
        return arrayList;
    }

    public StaticTile getStaticTileAt(int n, int n2, int n3, int n4, boolean bl) {
        StaticTile[][] staticTileArray = this.getStaticTileGrid(n3, n4, bl);
        return staticTileArray[n][n2];
    }

    private int[] translateIndex(int n, int n2, int n3, boolean bl) {
        StaticTile[][] staticTileArray = this.getStaticTileGrid(n2, n3, bl);
        int[] nArray = new int[]{(n - (bl ? 0 : 1)) / staticTileArray[0].length, (n - (bl ? 0 : 1)) % staticTileArray[0].length};
        return nArray;
    }

    private int getRowCount(int n, int n2) {
        StaticTile[][] staticTileArray = this.getStaticTileGrid(n, n2, true);
        return staticTileArray.length;
    }

    private int getColumnCount(int n, int n2) {
        StaticTile[][] staticTileArray = this.getStaticTileGrid(n, n2, true);
        return staticTileArray[0].length;
    }

    private StaticTile[][] initStaticTileGrid(int n, int n2, boolean bl) {
        BufferedImage bufferedImage = ImageResource.softenImage(this.imageURL);
        int n3 = bufferedImage.getHeight(null) / n2;
        int n4 = bufferedImage.getWidth(null) / n;
        StaticTile[][] staticTileArray = new StaticTile[n3][n4];
        int n5 = bl ? 0 : 1;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                StaticTile staticTile;
                staticTileArray[i][j] = staticTile = new StaticTile(this, n5++, n, n2, bl);
            }
        }
        this.staticTileGrids.put(ImageResource.getGridKey(n, n2, bl), staticTileArray);
        return staticTileArray;
    }

    public void paint(int n, Graphics2D graphics2D, int n2, int n3, int n4, int n5, boolean bl) {
        this.paint(n, graphics2D, n2, n3, n4, n5, n4, n5, bl);
    }

    void paint(int n, Graphics2D graphics2D, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (bl) {
            BufferedImage bufferedImage = ImageResource.softenImage(this.imageURL);
            int[] nArray = this.translateIndex(n, n4, n5, bl);
            int n8 = nArray[1] * n4;
            int n9 = nArray[0] * n5;
            graphics2D.drawImage(bufferedImage, n2, n3, n2 + n6, n3 + n7, n8, n9, n8 + n4, n9 + n5, null);
        } else {
            if (n == 0) {
                return;
            }
            if (n > 0) {
                BufferedImage bufferedImage = ImageResource.softenImage(this.imageURL);
                int[] nArray = this.translateIndex(n, n4, n5, bl);
                int n10 = nArray[1] * n4;
                int n11 = nArray[0] * n5;
                graphics2D.drawImage(bufferedImage, n2, n3, n2 + n6, n3 + n7, n10, n11, n10 + n4, n11 + n5, null);
            } else {
                AnimatedTile animatedTile = (AnimatedTile)this.getTile(n, n4, n5, bl);
                animatedTile.paint(graphics2D, n2, n3);
            }
        }
    }

    public String getRelativeResourcePath() {
        return this.relativeResourcePath;
    }

    public String toString() {
        return "ImageResource: " + this.imageURL;
    }

    public GlobalRepository getGameDesign() {
        return this.gameDesign;
    }

    public URL getURL() {
        return this.imageURL;
    }

    public void setURL(URL uRL) {
        this.imageURL = uRL;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (this.name == null && bl) {
            String string = CodeUtils.getIdealImageName(this.getRelativeResourcePath());
            this.name = this.gameDesign.getNextAvailableComponentName(string);
        }
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l) {
        this.id = l;
    }

    private static class Key {
        private int tileWidth;
        private int tileHeight;
        private boolean zeroBasedIndex;

        public Key(int n, int n2, boolean bl) {
            this.tileWidth = n;
            this.tileHeight = n2;
            this.zeroBasedIndex = bl;
        }

        public boolean isZeroBasedIndex() {
            return this.zeroBasedIndex;
        }

        public int getTileHeight() {
            return this.tileHeight;
        }

        public int getTileWidth() {
            return this.tileWidth;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        public String toString() {
            return "" + this.tileWidth + this.tileHeight + this.zeroBasedIndex;
        }
    }
}

