/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.grid;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.game.editor.common.TileCellRenderer;
import org.netbeans.modules.vmd.game.editor.grid.ResourceImageListModel;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileTransferable;

class ResourceImageList
extends JList {
    public static final boolean DEBUG = false;
    private int padX = 4;
    private int padY = 4;

    public ResourceImageList() {
        this.setModel(new ResourceImageListModel());
        this.setCellRenderer(new TileCellRenderer(this.padX, this.padY));
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.addListSelectionListener(new ResourceImageListSelectionListener());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                int n = ResourceImageList.this.getSelectedIndex();
                if (n != -1) {
                    StaticTile staticTile = (StaticTile)ResourceImageList.this.getModel().getElementAt(n);
                    staticTile.getImageResource().getGameDesign().getMainView().requestPreview(staticTile);
                    staticTile.getImageResource().getGameDesign().getMainView().paintTileChanged(staticTile);
                }
            }
        });
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this, 1, new DGL());
    }

    public void setImageResource(ImageResource imageResource, int n, int n2, boolean bl) {
        ((ResourceImageListModel)this.getModel()).update(imageResource, n, n2, bl);
    }

    private void hiliteTileAtPoint(Point point) {
        int n = this.locationToIndex(point);
        this.setSelectedIndex(n);
    }

    public Tile getSelectedTile() {
        int n = this.getSelectedIndex();
        return (Tile)this.getModel().getElementAt(n);
    }

    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    private class ResourceImageListSelectionListener
    implements ListSelectionListener {
        private ResourceImageListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ResourceImageList.this.getSelectedIndex();
            this.handleTileSelection(n);
        }

        private void handleTileSelection(int n) {
            StaticTile staticTile = (StaticTile)ResourceImageList.this.getModel().getElementAt(n);
            staticTile.getImageResource().getGameDesign().getMainView().requestPreview(staticTile);
            staticTile.getImageResource().getGameDesign().getMainView().paintTileChanged(staticTile);
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            TileTransferable tileTransferable = new TileTransferable();
            if (ResourceImageList.this.getSelectedValues().length == 0) {
                int n = ResourceImageList.this.locationToIndex(point);
                Tile tile = (Tile)ResourceImageList.this.getModel().getElementAt(n);
                tileTransferable.getTiles().add(tile);
                ResourceImageList.this.hiliteTileAtPoint(point);
            } else {
                Object[] objectArray = ResourceImageList.this.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    tileTransferable.getTiles().add((Tile)objectArray[i]);
                }
            }
            dragGestureEvent.startDrag(null, tileTransferable, this);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            super.dragDropEnd(dragSourceDropEvent);
            if (dragSourceDropEvent.getDropSuccess()) {
                // empty if block
            }
        }
    }
}

