/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.server.GlassFishGem;
import org.netbeans.modules.ruby.railsprojects.server.Mongrel;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.ServerInstanceProviderImpl;
import org.netbeans.modules.ruby.railsprojects.server.WEBrick;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstanceProvider;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerRegistry
implements VetoableChangeListener {
    private static ServerRegistry defaultRegistry;

    private ServerRegistry() {
    }

    public static synchronized ServerRegistry getDefault() {
        if (defaultRegistry == null) {
            defaultRegistry = new ServerRegistry();
            RubyPlatformManager.addVetoableChangeListener((VetoableChangeListener)defaultRegistry);
        }
        return defaultRegistry;
    }

    public List<RubyInstance> getServers() {
        ArrayList<RubyInstance> arrayList = new ArrayList<RubyInstance>();
        for (RubyInstanceProvider rubyInstanceProvider : Lookups.forPath((String)"Servers/Ruby").lookupAll(RubyInstanceProvider.class)) {
            arrayList.addAll(rubyInstanceProvider.getInstances());
        }
        arrayList.addAll(this.getRubyServers());
        return arrayList;
    }

    List<RubyInstance> getServers(RubyPlatform rubyPlatform) {
        ArrayList<RubyInstance> arrayList = new ArrayList<RubyInstance>();
        for (RubyInstance rubyInstance : this.getServers()) {
            if (!rubyInstance.isPlatformSupported(rubyPlatform)) continue;
            arrayList.add(rubyInstance);
        }
        return arrayList;
    }

    List<RubyServer> getRubyServers() {
        ArrayList<RubyServer> arrayList = new ArrayList<RubyServer>();
        for (RubyPlatform rubyPlatform : RubyPlatformManager.getPlatforms()) {
            arrayList.addAll(RubyServerFactory.getInstance(rubyPlatform).getServers());
        }
        return arrayList;
    }

    public RubyInstance getServer(String string, RubyPlatform rubyPlatform) {
        for (RubyInstanceProvider object : Lookups.forPath((String)"Servers/Ruby").lookupAll(RubyInstanceProvider.class)) {
            RubyInstance rubyInstance = object.getInstance(string);
            if (rubyInstance == null || !rubyInstance.isPlatformSupported(rubyPlatform)) continue;
            return rubyInstance;
        }
        for (RubyServer rubyServer : RubyServerFactory.getInstance(rubyPlatform).getServers()) {
            if (!rubyServer.getServerUri().equals(string) || !rubyServer.isPlatformSupported(rubyPlatform)) continue;
            return rubyServer;
        }
        return null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getPropertyName().equals("platforms")) {
            ServerInstanceProviderImpl.getInstance().fireServersChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RubyServerFactory
    implements PropertyChangeListener {
        private static final Map<RubyPlatform, RubyServerFactory> instances = new HashMap<RubyPlatform, RubyServerFactory>();
        private final RubyPlatform platform;
        private final Set<RubyServer> servers = new HashSet<RubyServer>();

        private RubyServerFactory(RubyPlatform rubyPlatform) {
            this.platform = rubyPlatform;
        }

        public static synchronized RubyServerFactory getInstance(RubyPlatform rubyPlatform) {
            RubyServerFactory rubyServerFactory = instances.get(rubyPlatform);
            if (rubyServerFactory != null) {
                return rubyServerFactory;
            }
            RubyServerFactory rubyServerFactory2 = new RubyServerFactory(rubyPlatform);
            rubyServerFactory2.initGlassFish();
            rubyServerFactory2.initWEBrick();
            rubyServerFactory2.initMongrel();
            rubyPlatform.addPropertyChangeListener((PropertyChangeListener)rubyServerFactory2);
            instances.put(rubyPlatform, rubyServerFactory2);
            return rubyServerFactory2;
        }

        public List<RubyServer> getServers() {
            return new ArrayList<RubyServer>(this.servers);
        }

        private void initGlassFish() {
            if (this.platform.isJRuby()) {
                GemInfo gemInfo;
                GemManager gemManager = this.platform.getGemManager();
                if (gemManager == null) {
                    return;
                }
                List list = gemManager.getVersions("glassfish");
                GemInfo gemInfo2 = gemInfo = list.isEmpty() ? null : (GemInfo)list.get(0);
                if (gemInfo == null) {
                    Iterator<RubyServer> iterator = this.servers.iterator();
                    while (iterator.hasNext()) {
                        if (!(iterator.next() instanceof GlassFishGem)) continue;
                        iterator.remove();
                    }
                    return;
                }
                GlassFishGem glassFishGem = new GlassFishGem(this.platform, gemInfo);
                if (!this.servers.contains(glassFishGem)) {
                    this.servers.add(glassFishGem);
                }
            }
        }

        private void initMongrel() {
            GemManager gemManager = this.platform.getGemManager();
            if (gemManager == null) {
                return;
            }
            String string = gemManager.getLatestVersion("mongrel");
            if (string == null) {
                Iterator<RubyServer> iterator = this.servers.iterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof Mongrel)) continue;
                    iterator.remove();
                }
                return;
            }
            Mongrel mongrel = new Mongrel(this.platform, string);
            if (!this.servers.contains(mongrel)) {
                this.servers.add(mongrel);
            }
        }

        private void initWEBrick() {
            WEBrick wEBrick = new WEBrick(this.platform);
            if (!this.servers.contains(wEBrick)) {
                this.servers.add(wEBrick);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("gems")) {
                this.initGlassFish();
                this.initMongrel();
                this.initWEBrick();
                ServerInstanceProviderImpl.getInstance().fireServersChanged();
            }
        }
    }
}

