/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsProjectUtil {
    private RailsProjectUtil() {
    }

    public static String getVersionString(File file) {
        try {
            String string;
            Pattern pattern = Pattern.compile("\\s*[A-Z]+\\s*=\\s*(\\d+)\\s*");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < 10 && (string = bufferedReader.readLine()) != null; ++i) {
                Matcher matcher;
                if (string.indexOf("MAJOR") != -1) {
                    matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    n = Integer.parseInt(matcher.group(1));
                    continue;
                }
                if (string.indexOf("MINOR") != -1) {
                    matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    n2 = Integer.parseInt(matcher.group(1));
                    continue;
                }
                if (string.indexOf("TINY") == -1 || !(matcher = pattern.matcher(string)).matches()) continue;
                n3 = Integer.parseInt(matcher.group(1));
            }
            bufferedReader.close();
            return n + "." + n2 + "." + n3;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public static String getRailsVersion(Project project) {
        File file;
        String string;
        FileObject fileObject;
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)project);
        String string2 = gemManager.getLatestVersion("rails");
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("vendor/rails/railties");
        if (fileObject2 != null && (fileObject = fileObject2.getFileObject("lib/rails/version.rb")) != null && (string = RailsProjectUtil.getVersionString(file = FileUtil.toFile((FileObject)fileObject))) != null) {
            string2 = string;
        }
        return string2;
    }

    public static Object getEvaluatedProperty(Project project, String string) {
        if (string == null) {
            return null;
        }
        RailsProject railsProject = (RailsProject)((Object)project.getLookup().lookup(RailsProject.class));
        if (railsProject != null) {
            return railsProject.evaluator().evaluate(string);
        }
        return null;
    }

    public static void getAllScripts(String string, FileObject fileObject, List<String> list) {
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (!"".equals(string)) {
            string = string + "/";
        }
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i].isData() && fileObjectArray[i].getMIMEType().equals("text/x-ruby")) {
                list.add(string + fileObjectArray[i].getNameExt());
            }
            if (!fileObjectArray[i].isFolder()) continue;
            RailsProjectUtil.getAllScripts(string + fileObjectArray[i].getNameExt(), fileObjectArray[i], list);
        }
    }

    public static URL getRootURL(File file, String string) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        } else if (!file.exists()) {
            uRL = new URL(uRL.toExternalForm() + "/");
        }
        if (string != null) {
            assert (string.endsWith("/"));
            uRL = new URL(uRL.toExternalForm() + string);
        }
        return uRL;
    }
}

