/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.util;

import org.netbeans.api.debugger.Properties;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.util.NbBundle;

public abstract class AbstractColumn
extends ColumnModel {
    protected String myId;
    protected String myName;
    protected String myTooltip;
    protected Class myType;
    protected Properties myProperties = Properties.getDefault().getProperties("debugger").getProperties("views");
    protected boolean mySortable = true;
    private static final int WIDTH = 150;
    private static final String SORTED = "sorted";
    private static final String DESCENDING = "sortedDescending";
    private static final String VISIBLE = "visible";
    private static final String COLUMN_WIDTH = "columnWidth";
    private static final String ORDER_NUMBER = "currentOrderNumber";

    public String getID() {
        return this.myId;
    }

    public String getDisplayName() {
        return this.getMessage(this.myName);
    }

    public Class getType() {
        return this.myType;
    }

    public String getShortDescription() {
        return this.getMessage(this.myTooltip);
    }

    public int getCurrentOrderNumber() {
        return this.myProperties.getInt(this.getFieldId(ORDER_NUMBER), -1);
    }

    public void setCurrentOrderNumber(int n) {
        this.myProperties.setInt(this.getFieldId(ORDER_NUMBER), n);
    }

    public int getColumnWidth() {
        return this.myProperties.getInt(this.getFieldId(COLUMN_WIDTH), 150);
    }

    public void setColumnWidth(int n) {
        this.myProperties.setInt(this.getFieldId(COLUMN_WIDTH), n);
    }

    public void setVisible(boolean bl) {
        this.myProperties.setBoolean(this.getFieldId(VISIBLE), bl);
    }

    public boolean isVisible() {
        return this.myProperties.getBoolean(this.getFieldId(VISIBLE), true);
    }

    public void setSorted(boolean bl) {
        this.myProperties.setBoolean(this.getFieldId(SORTED), bl);
    }

    public boolean isSorted() {
        return this.myProperties.getBoolean(this.getFieldId(SORTED), false);
    }

    public void setSortedDescending(boolean bl) {
        this.myProperties.setBoolean(this.getFieldId(DESCENDING), bl);
    }

    public boolean isSortedDescending() {
        return this.myProperties.getBoolean(this.getFieldId(DESCENDING), false);
    }

    public boolean isSortable() {
        return this.mySortable;
    }

    private String getFieldId(String string) {
        return this.getID() + "." + string;
    }

    private String getMessage(String string) {
        if (string == null) {
            return null;
        }
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)string);
    }
}

