/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.xml.namespace.QName;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class SourcesModel
implements TreeModel,
TableModel,
NodeActionsProvider {
    private Listener listener;
    private SourcePath sourcePath;
    private BpelDebugger debugger;
    private Vector listeners = new Vector();
    private Set enabledSourceRoots = new HashSet();
    private Set disabledSourceRoots = new HashSet();

    public SourcesModel(ContextProvider contextProvider) {
        this.sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        this.debugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Object[] objectArray = this.sourcePath.getAvailableSources();
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return objectArray;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return this.sourcePath.getAvailableSources().length;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof String) {
            if (string.equals("use")) {
                return this.isEnabled((String)object);
            }
            if (string.equals("processQName")) {
                QName qName = this.getProcessQName((String)object);
                return qName != null ? qName.toString() : "";
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof String) {
            if (string.equals("use")) {
                return false;
            }
            if (string.equals("processQName")) {
                return true;
            }
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof String) {
            if (string.equals("use")) {
                this.setEnabled((String)object, (Boolean)object2);
                return;
            }
            if (string.equals("processQName")) {
                return;
            }
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return new Action[0];
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    private boolean isEnabled(String string) {
        String[] stringArray = this.sourcePath.getSelectedSources();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private QName getProcessQName(String string) {
        return this.sourcePath.getProcessQName(string);
    }

    private void setEnabled(String string, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.sourcePath.getSelectedSources()));
        if (bl) {
            this.enabledSourceRoots.add(string);
            this.disabledSourceRoots.remove(string);
            hashSet.add(string);
        } else {
            this.disabledSourceRoots.add(string);
            this.enabledSourceRoots.remove(string);
            hashSet.remove(string);
        }
        String[] stringArray = new String[hashSet.size()];
        this.sourcePath.setSelectedSources(hashSet.toArray(stringArray));
    }

    public static abstract class AbstractColumn
    extends ColumnModel {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views");

        public void setVisible(boolean bl) {
            this.properties.setBoolean(this.getID() + ".visible", bl);
        }

        public void setSorted(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sorted", bl);
        }

        public void setSortedDescending(boolean bl) {
            this.properties.setBoolean(this.getID() + ".sortedDescending", bl);
        }

        public int getCurrentOrderNumber() {
            return this.properties.getInt(this.getID() + ".currentOrderNumber", -1);
        }

        public void setCurrentOrderNumber(int n) {
            this.properties.setInt(this.getID() + ".currentOrderNumber", n);
        }

        public int getColumnWidth() {
            return this.properties.getInt(this.getID() + ".columnWidth", 150);
        }

        public void setColumnWidth(int n) {
            this.properties.setInt(this.getID() + ".columnWidth", n);
        }

        public boolean isVisible() {
            return this.properties.getBoolean(this.getID() + ".visible", true);
        }

        public boolean isSorted() {
            return this.properties.getBoolean(this.getID() + ".sorted", false);
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean(this.getID() + ".sortedDescending", false);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference model;

        private Listener(SourcesModel sourcesModel) {
            this.model = new WeakReference<SourcesModel>(sourcesModel);
            sourcesModel.sourcePath.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private SourcesModel getModel() {
            SourcesModel sourcesModel = (SourcesModel)this.model.get();
            if (sourcesModel == null) {
                sourcesModel.sourcePath.removePropertyChangeListener((PropertyChangeListener)this);
            }
            return sourcesModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SourcesModel sourcesModel = this.getModel();
            if (sourcesModel == null) {
                return;
            }
            sourcesModel.fireTreeChanged();
        }
    }

    public static class SourcesQNameColumn
    extends AbstractColumn {
        public String getID() {
            return "processQName";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_QName_Name");
        }

        public Class getType() {
            return String.class;
        }

        public String getShortDescription() {
            return NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_QName_Desc");
        }

        public boolean initiallyVisible() {
            return false;
        }
    }

    public static class SourcesUsedColumn
    extends AbstractColumn {
        public String getID() {
            return "use";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Name");
        }

        public Class getType() {
            return Boolean.TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle(SourcesModel.class).getString("CTL_SourcesModel_Column_Debugging_Desc");
        }

        public boolean initiallyVisible() {
            return true;
        }
    }

    public static class DefaultSourcesColumn
    extends AbstractColumn {
        public String getID() {
            return "DefaultSourcesColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Name");
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DefaultSourcesColumn.class).getString("CTL_SourcesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }
}

