/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.plinks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.RuntimePartnerLink;
import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.modules.bpel.debugger.ui.plinks.models.EndpointWrapper;
import org.netbeans.modules.bpel.debugger.ui.plinks.models.PartnerLinkWrapper;
import org.netbeans.modules.bpel.debugger.ui.plinks.models.RoleRefWrapper;
import org.netbeans.modules.bpel.debugger.ui.util.VariablesUtil;
import org.netbeans.modules.bpel.debugger.ui.util.XmlUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PLinksTreeModel
implements TreeModel {
    private BpelDebugger myDebugger;
    private ProcessInstance myInstance;
    private PositionListener myListener;
    private Vector myListeners = new Vector();

    public PLinksTreeModel(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object object2;
        Object object3;
        if (this.myInstance == null) {
            if (object.equals("Root")) {
                return new Object[]{new Dummy()};
            }
            if (object instanceof Dummy) {
                return new Object[0];
            }
            throw new UnknownTypeException(object);
        }
        if ("Root".equals(object)) {
            return this.getPartnerLinks();
        }
        if (object instanceof PartnerLinkWrapper) {
            ArrayList<Object> arrayList = new ArrayList<Object>(3);
            PartnerLinkWrapper partnerLinkWrapper = (PartnerLinkWrapper)object;
            if (partnerLinkWrapper.getMyRoleRef() != null) {
                arrayList.add(new RoleRefWrapper(partnerLinkWrapper.getMyRoleRef(), RoleRefWrapper.RoleType.MY));
            }
            if (partnerLinkWrapper.getPartnerRoleRef() != null) {
                arrayList.add(new RoleRefWrapper(partnerLinkWrapper.getPartnerRoleRef(), RoleRefWrapper.RoleType.PARTNER));
                arrayList.add(new EndpointWrapper(partnerLinkWrapper));
            }
            return arrayList.toArray();
        }
        if (object instanceof RoleRefWrapper) {
            return new Object[0];
        }
        if (object instanceof EndpointWrapper && (object3 = ((EndpointWrapper)(object2 = (EndpointWrapper)object)).getSerializedValue()) != null) {
            Element element = XmlUtil.parseXmlElement((String)object3);
            if (element != null) {
                return new Object[]{element};
            }
            return new Object[0];
        }
        if (object instanceof Node) {
            if (object instanceof Element) {
                Node node;
                int n3;
                object2 = (Element)object;
                object3 = object2.getAttributes();
                NodeList nodeList = object2.getChildNodes();
                LinkedList<Node> linkedList = new LinkedList<Node>();
                for (n3 = 0; n3 < object3.getLength(); ++n3) {
                    node = object3.item(n3);
                    if (node.getNodeName().startsWith("xmlns")) continue;
                    linkedList.add(node);
                }
                if (nodeList.getLength() > 1 || nodeList.item(0).getNodeType() != 3) {
                    for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                        node = nodeList.item(n3);
                        if (node.getNodeType() == 3 && node.getNodeValue().trim().equals("")) continue;
                        linkedList.add(node);
                    }
                }
                return linkedList.toArray();
            }
            return new Object[0];
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        return this.getChildren(object, 0, 0).length;
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        return this.getChildrenCount(object) == 0;
    }

    public void addModelListener(ModelListener modelListener) {
        this.myListeners.add(modelListener);
        if (this.myListener == null && this.myDebugger != null) {
            this.myListener = new PositionListener(this, this.myDebugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myListeners.remove(modelListener);
        if (this.myListeners.size() == 0 && this.myListener != null) {
            this.myListener.destroy();
            this.myListener = null;
        }
    }

    void setProcessInstance(ProcessInstance processInstance) {
        this.myInstance = processInstance;
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.myListeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private Object[] getPartnerLinks() {
        if (this.myInstance == null) {
            return new Object[0];
        }
        PartnerLink[] partnerLinkArray = this.getStaticPartnerLinks();
        RuntimePartnerLink[] runtimePartnerLinkArray = this.myInstance.getRuntimePartnerLinks();
        Object[] objectArray = new PartnerLinkWrapper[partnerLinkArray.length];
        block0: for (int i = 0; i < partnerLinkArray.length; ++i) {
            objectArray[i] = new PartnerLinkWrapper(partnerLinkArray[i], null);
            for (int j = 0; j < runtimePartnerLinkArray.length; ++j) {
                if (!runtimePartnerLinkArray[j].getName().equals(partnerLinkArray[i].getName())) continue;
                objectArray[i] = new PartnerLinkWrapper(partnerLinkArray[i], runtimePartnerLinkArray[j]);
                continue block0;
            }
        }
        return objectArray;
    }

    private PartnerLink[] getStaticPartnerLinks() {
        ProcessInstance processInstance;
        VariablesUtil variablesUtil = new VariablesUtil(this.myDebugger);
        BpelModel bpelModel = variablesUtil.getBpelModel();
        if (bpelModel == null) {
            return new PartnerLink[0];
        }
        LinkedList<PartnerLink> linkedList = new LinkedList<PartnerLink>();
        PartnerLinkContainer partnerLinkContainer = bpelModel.getProcess().getPartnerLinkContainer();
        if (partnerLinkContainer != null && partnerLinkContainer.sizeOfPartnerLink() > 0) {
            linkedList.addAll(Arrays.asList(partnerLinkContainer.getPartnerLinks()));
        }
        if ((processInstance = this.myDebugger.getCurrentProcessInstance()) == null) {
            return linkedList.toArray(new PartnerLink[linkedList.size()]);
        }
        ProcessExecutionModel processExecutionModel = processInstance.getProcessExecutionModel();
        if (processExecutionModel == null) {
            return linkedList.toArray(new PartnerLink[linkedList.size()]);
        }
        PemEntity pemEntity = processExecutionModel.getLastStartedEntity();
        if (pemEntity == null) {
            return linkedList.toArray(new PartnerLink[linkedList.size()]);
        }
        String string = pemEntity.getPsmEntity().getXpath();
        int n = string.indexOf("scope");
        while (n != -1) {
            int n2 = string.indexOf("/", n);
            String string2 = n2 == -1 ? string : string.substring(0, n2);
            Scope scope = variablesUtil.getScopeEntity(string2);
            if (scope != null && (partnerLinkContainer = scope.getPartnerLinkContainer()) != null && partnerLinkContainer.sizeOfPartnerLink() > 0) {
                linkedList.addAll(Arrays.asList(partnerLinkContainer.getPartnerLinks()));
            }
            n = n2 == -1 ? n2 : string.indexOf("scope", n2);
        }
        return linkedList.toArray(new PartnerLink[linkedList.size()]);
    }

    static class Dummy {
        Dummy() {
        }
    }

    private static class PositionListener
    implements PropertyChangeListener {
        private BpelDebugger myDebugger;
        private WeakReference myModel;
        private RequestProcessor.Task task;

        private PositionListener(PLinksTreeModel pLinksTreeModel, BpelDebugger bpelDebugger) {
            this.myDebugger = bpelDebugger;
            this.myModel = new WeakReference<PLinksTreeModel>(pLinksTreeModel);
            this.myDebugger.addPropertyChangeListener((PropertyChangeListener)this);
            this.getModel().setProcessInstance(this.myDebugger.getCurrentProcessInstance());
        }

        private void destroy() {
            this.myDebugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        private PLinksTreeModel getModel() {
            PLinksTreeModel pLinksTreeModel = (PLinksTreeModel)this.myModel.get();
            if (pLinksTreeModel == null) {
                this.destroy();
            }
            return pLinksTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("currentProcessInstance".equals(propertyChangeEvent.getPropertyName())) {
                this.getModel().setProcessInstance(this.myDebugger.getCurrentProcessInstance());
            }
            if ("currentPosition".equals(propertyChangeEvent.getPropertyName())) {
                final PLinksTreeModel pLinksTreeModel = this.getModel();
                if (pLinksTreeModel == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        pLinksTreeModel.fireTreeChanged();
                    }
                }, 500);
            }
        }
    }
}

