/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.breakpoint;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.breakpoints.BpelFaultBreakpoint;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BpelFaultBreakpointPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BpelBreakpointFilter
implements NodeActionsProviderFilter {
    private static final Action GO_TO_SOURCE_ACTION = Models.createAction((String)NbBundle.getMessage(BpelBreakpointFilter.class, (String)"CTL_Breakpoint_Action_Go_to_Source"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            BpelBreakpointFilter.goToSource((LineBreakpoint)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action CUSTOMIZE_ACTION = Models.createAction((String)NbBundle.getMessage(BpelBreakpointFilter.class, (String)"CTL_Breakpoint_Customize_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return object instanceof BpelFaultBreakpoint;
        }

        public void perform(Object[] objectArray) {
            BpelBreakpointFilter.customize(objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            Action[] actionArray = nodeActionsProvider.getActions(object);
            Action[] actionArray2 = new Action[actionArray.length + 2];
            actionArray2[0] = GO_TO_SOURCE_ACTION;
            actionArray2[1] = null;
            for (int i = 0; i < actionArray.length; ++i) {
                actionArray2[i + 2] = actionArray[i];
            }
            return actionArray2;
        }
        if (object instanceof BpelFaultBreakpoint) {
            Action[] actionArray = nodeActionsProvider.getActions(object);
            Action[] actionArray3 = new Action[actionArray.length + 2];
            actionArray3[0] = CUSTOMIZE_ACTION;
            actionArray3[1] = null;
            for (int i = 0; i < actionArray.length; ++i) {
                actionArray3[i + 2] = actionArray[i];
            }
            return actionArray3;
        }
        return nodeActionsProvider.getActions(object);
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            BpelBreakpointFilter.goToSource((LineBreakpoint)object);
        } else if (object instanceof BpelFaultBreakpoint) {
            BpelBreakpointFilter.customize(object);
        } else {
            nodeActionsProvider.performDefaultAction(object);
        }
    }

    private static void goToSource(LineBreakpoint lineBreakpoint) {
        EditorContextBridge.showSource((String)lineBreakpoint.getURL(), (String)lineBreakpoint.getXpath(), (String)"bpelsource");
    }

    private static void customize(Object object) {
        if (!(object instanceof BpelFaultBreakpoint)) {
            return;
        }
        BpelFaultBreakpoint bpelFaultBreakpoint = (BpelFaultBreakpoint)object;
        BpelFaultBreakpointPanel bpelFaultBreakpointPanel = new BpelFaultBreakpointPanel(bpelFaultBreakpoint);
        ((Component)bpelFaultBreakpointPanel).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BpelBreakpointFilter.class, (String)"ACSD_Breakpoint_Customizer_Dialog"));
        HelpCtx helpCtx = HelpCtx.findHelp((Component)bpelFaultBreakpointPanel);
        if (helpCtx == null) {
            helpCtx = new HelpCtx("debug.add.breakpoint");
        }
        final Controller[] controllerArray = new Controller[]{bpelFaultBreakpointPanel};
        final DialogDescriptor[] dialogDescriptorArray = new DialogDescriptor[1];
        final Dialog[] dialogArray = new Dialog[1];
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (dialogDescriptorArray[0].getValue() == DialogDescriptor.OK_OPTION) {
                    boolean bl = controllerArray[0].ok();
                    if (bl) {
                        dialogArray[0].setVisible(false);
                    }
                } else {
                    dialogArray[0].setVisible(false);
                }
            }
        };
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bpelFaultBreakpointPanel, NbBundle.getMessage(BpelBreakpointFilter.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, actionListener);
        dialogDescriptor.setClosingOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialogDescriptorArray[0] = dialogDescriptor;
        dialogArray[0] = dialog;
        dialog.setVisible(true);
    }
}

