/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.bpel.debugger.api.EditorContextBridge;
import org.netbeans.modules.bpel.debugger.api.breakpoints.LineBreakpoint;
import org.netbeans.modules.bpel.debugger.ui.breakpoint.BpelBreakpointListener;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.debugger.ui.util.ModelUtil;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.BpelNodeTypedAction;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.soa.ui.nodes.InstanceRef;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Breakpoint
extends ActionsProviderSupport
implements PropertyChangeListener {
    private BpelBreakpointListener myBreakpointAnnotationListener;
    private AtomicBoolean myIsExecuting = new AtomicBoolean(false);

    public Breakpoint() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object object) {
        if (this.myIsExecuting.compareAndSet(false, true)) {
            try {
                this.toggleBreakpoint();
            }
            finally {
                this.myIsExecuting.set(false);
            }
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        MultiViewPerspective multiViewPerspective;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Breakpoint.this.propertyChange(propertyChangeEvent);
                }
            });
            return;
        }
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        TopComponent topComponent2 = WindowManager.getDefault().findTopComponent("navigatorTC");
        String string = null;
        if (multiViewHandler != null && (multiViewPerspective = multiViewHandler.getSelectedPerspective()) != null) {
            string = multiViewPerspective.preferredID();
        }
        if (topComponent != null && topComponent.equals(topComponent2)) {
            bl = true;
        } else {
            Node node;
            Action[] actionArray;
            boolean bl2 = bl = EditorUtil.getCurrentLine() != null && ("orch-designer".equals(string) || "bpelsource".equals(string));
            if (bl && "orch-designer".equals(string) && (actionArray = (node = this.getCurrentNode()).getActions(true)) != null) {
                bl = false;
                for (Action action : actionArray) {
                    if (!(action instanceof BpelNodeTypedAction) || ((BpelNodeTypedAction)action).getType() != ActionType.TOGGLE_BREAKPOINT) continue;
                    bl = true;
                    break;
                }
            }
        }
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }

    private void toggleBreakpoint() {
        Object object;
        Object object2;
        Node node = this.getCurrentNode();
        if (node == null) {
            return;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return;
        }
        String string = this.getFileExt(dataObject);
        if (!"bpel".equals(string)) {
            return;
        }
        String string2 = FileUtil.toFile((FileObject)dataObject.getPrimaryFile()).getPath().replace("\\", "/");
        int n = -1;
        UniqueId uniqueId = null;
        if (node instanceof InstanceRef && !this.isInSourceEditor()) {
            object2 = ((InstanceRef)node).getReference();
            if (object2 == null || !(object2 instanceof BpelEntity)) {
                return;
            }
            object = (BpelEntity)object2;
            uniqueId = object.getUID();
            n = ModelUtil.getLineNumber(uniqueId);
            int n2 = EditorContextBridge.translateBreakpointLine((String)string2, (int)n);
            if (n2 != -1) {
                n = n2;
            }
        } else {
            int n3;
            n = EditorUtil.getLineNumber(node);
            if (n > 0 && (n3 = EditorContextBridge.translateBreakpointLine((String)string2, (int)n)) != -1 && n3 >= n - 5 && n3 <= n + 5) {
                object = EditorUtil.getDocument(dataObject);
                BpelModel bpelModel = EditorUtil.getBpelModel(dataObject);
                if (object != null && bpelModel != null && n3 > 0) {
                    int n4 = EditorUtil.findOffset((Document)object, n3);
                    uniqueId = ModelUtil.getBpelEntityId(bpelModel, n4);
                    n = n3;
                }
            }
        }
        if (n == -1) {
            return;
        }
        object2 = null;
        if (uniqueId != null) {
            object2 = ModelUtil.getXpath(uniqueId);
        }
        object = DebuggerManager.getDebuggerManager();
        LineBreakpoint lineBreakpoint = this.getBreakpointAnnotationListener().findBreakpoint(string2, (String)object2, n);
        if (lineBreakpoint != null) {
            object.removeBreakpoint((org.netbeans.api.debugger.Breakpoint)lineBreakpoint);
        } else {
            object.addBreakpoint((org.netbeans.api.debugger.Breakpoint)LineBreakpoint.create((String)string2, (String)object2, (int)n));
        }
    }

    private Node getCurrentNode() {
        Node[] nodeArray = WindowManager.getDefault().getRegistry().getCurrentNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        return nodeArray[0];
    }

    private boolean isInSourceEditor() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        if (topComponent == null) {
            return false;
        }
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return false;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        return multiViewPerspective.preferredID().equals("bpelsource");
    }

    private String getFileExt(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject == null) {
            return null;
        }
        return fileObject.getExt();
    }

    private BpelBreakpointListener getBreakpointAnnotationListener() {
        if (this.myBreakpointAnnotationListener == null) {
            this.myBreakpointAnnotationListener = (BpelBreakpointListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, BpelBreakpointListener.class));
        }
        return this.myBreakpointAnnotationListener;
    }
}

