/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.netbeans.modules.uihandler.Installer;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class MetricsHandler
extends Handler {
    private static Task lastRecord = Task.EMPTY;
    private static RequestProcessor FLUSH = new RequestProcessor("Flush Metrics Logs");
    private static boolean flushOnRecord;
    static final int MAX_LOGS = 400;

    public MetricsHandler() {
        this.setLevel(Level.FINEST);
    }

    public void publish(LogRecord logRecord) {
        class WriteOut
        implements Runnable {
            public LogRecord r;

            WriteOut() {
            }

            public void run() {
                Installer.writeOutMetrics(this.r);
                this.r = null;
            }
        }
        WriteOut writeOut = new WriteOut();
        writeOut.r = logRecord;
        lastRecord = FLUSH.post((Runnable)writeOut);
        if (flushOnRecord) {
            MetricsHandler.waitFlushed();
        }
    }

    public void flush() {
        MetricsHandler.waitFlushed();
    }

    static final void flushImmediatelly() {
        flushOnRecord = true;
    }

    static final void waitFlushed() {
        try {
            lastRecord.waitFinished(1000L);
        }
        catch (InterruptedException interruptedException) {
            Installer.LOG.log(Level.FINE, null, interruptedException);
        }
    }

    public void close() throws SecurityException {
    }
}

