/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.config.TomcatDatasource;
import org.netbeans.modules.tomcat5.config.gen.Context;
import org.netbeans.modules.tomcat5.config.gen.Parameter;
import org.netbeans.modules.tomcat5.config.gen.ResourceParams;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatModuleConfiguration
implements ModuleConfiguration,
ContextRootConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private final J2eeModule j2eeModule;
    private final TomcatManager.TomcatVersion tomcatVersion;
    private DataObject contextDataObject;
    private final File contextXml;
    private Context context;
    private static final String ATTR_PATH = "path";
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.tomcat5");

    public TomcatModuleConfiguration(J2eeModule j2eeModule, TomcatManager.TomcatVersion tomcatVersion) {
        this.j2eeModule = j2eeModule;
        this.tomcatVersion = tomcatVersion;
        this.contextXml = j2eeModule.getDeploymentConfigurationFile("META-INF/context.xml");
        this.init(this.contextXml);
    }

    private void init(File file) {
        try {
            this.getContext();
        }
        catch (ConfigurationException configurationException) {
            LOGGER.log(Level.FINE, null, configurationException);
        }
        if (this.contextDataObject == null) {
            try {
                this.contextDataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
                this.contextDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.FINE, null, dataObjectNotFoundException);
            }
        }
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public void dispose() {
    }

    public boolean supportsCreateDatasource() {
        return true;
    }

    public synchronized Context getContext() throws ConfigurationException {
        if (this.context == null) {
            if (this.contextXml.exists()) {
                try {
                    this.context = Context.createGraph(this.contextXml);
                }
                catch (IOException iOException) {
                    String string = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlReadFail", (Object)this.contextXml.getPath());
                    throw new ConfigurationException(string, (Throwable)iOException);
                }
                catch (RuntimeException runtimeException) {
                    String string = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlBroken", (Object)this.contextXml.getPath());
                    throw new ConfigurationException(string, (Throwable)runtimeException);
                }
            } else {
                this.context = this.genereateContext();
                this.writefile(this.contextXml);
            }
        }
        return this.context;
    }

    public String getContextRoot() throws ConfigurationException {
        return this.getContext().getAttributeValue(ATTR_PATH);
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        Context context = this.getContext();
        HashSet<Datasource> hashSet = new HashSet<Datasource>();
        int n = context.getResource().length;
        if (this.tomcatVersion != TomcatManager.TomcatVersion.TOMCAT_50) {
            for (int i = 0; i < n; ++i) {
                String string = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(string)) continue;
                String string2 = context.getResourceName(i);
                String string3 = context.getResourceUsername(i);
                String string4 = context.getResourceUrl(i);
                String string5 = context.getResourcePassword(i);
                String string6 = context.getResourceDriverClassName(i);
                if (string2 == null || string3 == null || string4 == null || string6 == null) continue;
                hashSet.add(new TomcatDatasource(string3, string4, string5, string2, string6));
            }
        } else {
            ResourceParams[] resourceParamsArray = context.getResourceParams();
            for (int i = 0; i < n; ++i) {
                String string = context.getResourceType(i);
                if (!"javax.sql.DataSource".equals(string)) continue;
                String string7 = context.getResourceName(i);
                for (int j = 0; j < resourceParamsArray.length; ++j) {
                    Object object2;
                    if (!string7.equals(resourceParamsArray[j].getName())) continue;
                    Parameter[] parameterArray = resourceParamsArray[j].getParameter();
                    HashMap<String, String> hashMap = new HashMap<String, String>(parameterArray.length);
                    for (Object object2 : parameterArray) {
                        hashMap.put(object2.getName(), object2.getValue());
                    }
                    String object3 = (String)hashMap.get("username");
                    String string2 = (String)hashMap.get("url");
                    String string3 = (String)hashMap.get("password");
                    object2 = (String)hashMap.get("driverClassName");
                    if (object3 == null || string2 == null || object2 == null) continue;
                    hashSet.add(new TomcatDatasource(object3, string2, string3, string7, (String)object2));
                }
            }
        }
        return hashSet;
    }

    public Datasource createDatasource(final String string, final String string2, final String string3, final String string4, final String string5) throws ConfigurationException, DatasourceAlreadyExistsException {
        ArrayList<Datasource> arrayList = new ArrayList<Datasource>();
        for (Datasource datasource : this.getDatasources()) {
            if (!string.equals(datasource.getJndiName())) continue;
            arrayList.add(datasource);
        }
        if (arrayList.size() > 0) {
            throw new DatasourceAlreadyExistsException(arrayList);
        }
        if (this.tomcatVersion != TomcatManager.TomcatVersion.TOMCAT_50) {
            this.modifyContext(new ContextModifier(){

                public void modify(Context context) {
                    int n = context.addResource(true);
                    context.setResourceName(n, string);
                    context.setResourceAuth(n, "Container");
                    context.setResourceType(n, "javax.sql.DataSource");
                    context.setResourceDriverClassName(n, string5);
                    context.setResourceUrl(n, string2);
                    context.setResourceUsername(n, string3);
                    context.setResourcePassword(n, string4);
                    context.setResourceMaxActive(n, "20");
                    context.setResourceMaxIdle(n, "10");
                    context.setResourceMaxWait(n, "-1");
                }
            });
        } else {
            this.modifyContext(new ContextModifier(){

                public void modify(Context context) {
                    int n = context.addResource(true);
                    context.setResourceName(n, string);
                    context.setResourceAuth(n, "Container");
                    context.setResourceType(n, "javax.sql.DataSource");
                    ResourceParams[] resourceParamsArray = context.getResourceParams();
                    for (int i = 0; i < resourceParamsArray.length; ++i) {
                        if (!string.equals(resourceParamsArray[i].getName())) continue;
                        context.removeResourceParams(resourceParamsArray[i]);
                    }
                    ResourceParams resourceParams = TomcatModuleConfiguration.this.createResourceParams(string, new Parameter[]{TomcatModuleConfiguration.this.createParameter("factory", "org.apache.commons.dbcp.BasicDataSourceFactory"), TomcatModuleConfiguration.this.createParameter("driverClassName", string5), TomcatModuleConfiguration.this.createParameter("url", string2), TomcatModuleConfiguration.this.createParameter("username", string3), TomcatModuleConfiguration.this.createParameter("password", string4), TomcatModuleConfiguration.this.createParameter("maxActive", "20"), TomcatModuleConfiguration.this.createParameter("maxIdle", "10"), TomcatModuleConfiguration.this.createParameter("maxWait", "-1")});
                    context.addResourceParams(resourceParams);
                }
            });
        }
        return new TomcatDatasource(string3, string2, string4, string, string5);
    }

    public void setContextRoot(String string) throws ConfigurationException {
        String string2;
        if (!this.isCorrectCP(string)) {
            string2 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("/" + stringTokenizer.nextToken());
            }
            string2 = stringBuffer.toString();
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_invalidCP", (Object)string), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            string = string2;
        }
        string2 = string;
        this.modifyContext(new ContextModifier(){

            public void modify(Context context) {
                if (TomcatModuleConfiguration.this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_50) {
                    String string = context.getAttributeValue(TomcatModuleConfiguration.ATTR_PATH);
                    String string22 = context.getLoggerPrefix();
                    if (string22 != null && string22.equals(TomcatModuleConfiguration.this.computeLoggerPrefix(string))) {
                        context.setLoggerPrefix(TomcatModuleConfiguration.this.computeLoggerPrefix(string2));
                    }
                }
                context.setAttributeValue(TomcatModuleConfiguration.ATTR_PATH, string2);
            }
        });
    }

    public DataObject getContextDataObject() {
        return this.contextDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "modified" && propertyChangeEvent.getNewValue() == Boolean.FALSE) {
            TomcatModuleConfiguration tomcatModuleConfiguration = this;
            synchronized (tomcatModuleConfiguration) {
                this.context = null;
            }
        }
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        Context context = this.getContext();
        try {
            context.write(outputStream);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    private Context genereateContext() {
        Context context = new Context();
        String string = "";
        context.setAttributeValue(ATTR_PATH, string);
        if (this.tomcatVersion == TomcatManager.TomcatVersion.TOMCAT_50) {
            context.setLogger(true);
            context.setLoggerClassName("org.apache.catalina.logger.FileLogger");
            context.setLoggerPrefix(this.computeLoggerPrefix(string));
            context.setLoggerSuffix(".log");
            context.setLoggerTimestamp("true");
        } else {
            context.setAntiJARLocking("true");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyContext(ContextModifier contextModifier) throws ConfigurationException {
        assert (this.contextDataObject != null) : "DataObject has not been initialized yet";
        try {
            Object object;
            EditorCookie editorCookie = (EditorCookie)this.contextDataObject.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument == null) {
                styledDocument = editorCookie.openDocument();
            }
            Context context = null;
            try {
                byte[] byArray = styledDocument.getText(0, styledDocument.getLength()).getBytes();
                context = Context.createGraph(new ByteArrayInputStream(byArray));
            }
            catch (RuntimeException runtimeException) {
                object = this.getContext();
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlNotValid"), 2);
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object2 == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                context = object;
            }
            contextModifier.modify(context);
            boolean bl = this.contextDataObject.isModified();
            this.replaceDocument(styledDocument, context);
            if (!bl && (object = (SaveCookie)this.contextDataObject.getCookie(SaveCookie.class)) != null) {
                object.save();
            }
            object = this;
            synchronized (object) {
                this.context = context;
            }
        }
        catch (BadLocationException badLocationException) {
            String string = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(string, (Throwable)badLocationException);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    private Parameter createParameter(String string, String string2) {
        Parameter parameter = new Parameter();
        parameter.setName(string);
        parameter.setValue(string2);
        return parameter;
    }

    private ResourceParams createResourceParams(String string, Parameter[] parameterArray) {
        ResourceParams resourceParams = new ResourceParams();
        resourceParams.setName(string);
        for (int i = 0; i < parameterArray.length; ++i) {
            resourceParams.addParameter(parameterArray[i]);
        }
        return resourceParams;
    }

    private String computeLoggerPrefix(String string) {
        return string.length() > 0 ? string.substring(1).replace('/', '_').concat(".") : "ROOT.";
    }

    private void writefile(final File file) throws ConfigurationException {
        assert (file != null) : "File to write can't be null";
        assert (file.getParentFile() != null) : "File parent folder can't be null";
        try {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
            if (fileObject == null) {
                try {
                    fileObject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file.getParentFile()));
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_FailedToCreateConfigFolder", (Object)file.getParentFile().getAbsolutePath()));
                }
            }
            final FileObject fileObject2 = fileObject;
            final ConfigurationException[] configurationExceptionArray = new ConfigurationException[]{null};
            FileSystem fileSystem = fileObject2.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    String string = file.getName();
                    FileObject fileObject = fileObject2.getFileObject(string);
                    if (fileObject == null) {
                        fileObject = fileObject2.createData(string);
                    }
                    Context context = null;
                    try {
                        context = TomcatModuleConfiguration.this.getContext();
                    }
                    catch (ConfigurationException configurationException) {
                        configurationExceptionArray[0] = configurationException;
                        return;
                    }
                    FileLock fileLock = fileObject.lock();
                    try {
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock), 4096);
                        try {
                            if (context != null) {
                                context.write(bufferedOutputStream);
                            }
                        }
                        finally {
                            ((OutputStream)bufferedOutputStream).close();
                        }
                    }
                    finally {
                        fileLock.releaseLock();
                    }
                }
            });
            if (configurationExceptionArray[0] != null) {
                throw configurationExceptionArray[0];
            }
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(TomcatModuleConfiguration.class, (String)"MSG_ContextXmlWriteFail", (Object)this.contextXml.getPath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    private void replaceDocument(final StyledDocument styledDocument, BaseBean baseBean) {
        final StringWriter stringWriter = new StringWriter();
        try {
            baseBean.write((Writer)stringWriter);
        }
        catch (Schema2BeansException schema2BeansException) {
            Logger.getLogger(TomcatModuleConfiguration.class.getName()).log(Level.INFO, null, schema2BeansException);
        }
        catch (IOException iOException) {
            Logger.getLogger(TomcatModuleConfiguration.class.getName()).log(Level.INFO, null, iOException);
        }
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

            public void run() {
                try {
                    styledDocument.remove(0, styledDocument.getLength());
                    styledDocument.insertString(0, stringWriter.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
    }

    private boolean isCorrectCP(String string) {
        boolean bl = true;
        if (!string.equals("") && !string.startsWith("/")) {
            bl = false;
        } else if (string.endsWith("/")) {
            bl = false;
        } else if (string.indexOf("//") >= 0) {
            bl = false;
        }
        return bl;
    }

    public void bindDatasourceReference(final String string, final String string2) throws ConfigurationException {
        Set<Datasource> set = this.getDatasources();
        for (Datasource datasource : set) {
            if (!string.equals(datasource.getJndiName())) continue;
            return;
        }
        Context context = this.getContext();
        int n = context.getResourceLink().length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(context.getResourceLinkName(i))) continue;
            return;
        }
        for (Datasource datasource : set) {
            if (!string2.equals(datasource.getJndiName())) continue;
            try {
                this.createDatasource(string, datasource.getUrl(), datasource.getUsername(), datasource.getPassword(), datasource.getDriverClassName());
            }
            catch (DatasourceAlreadyExistsException datasourceAlreadyExistsException) {
                LOGGER.info("Datasource with the '" + string + "' reference name already exists.");
            }
            return;
        }
        this.modifyContext(new ContextModifier(){

            public void modify(Context context) {
                int n = context.addResourceLink(true);
                context.setResourceLinkName(n, string);
                context.setResourceLinkGlobal(n, string2);
                context.setResourceLinkType(n, "javax.sql.DataSource");
            }
        });
    }

    public void bindDatasourceReferenceForEjb(String string, String string2, String string3, String string4) throws ConfigurationException {
    }

    public String findDatasourceJndiName(String string) throws ConfigurationException {
        Context context = this.getContext();
        if (context != null) {
            int n;
            int n2 = context.getResource().length;
            for (n = 0; n < n2; ++n) {
                if (!string.equals(context.getResourceName(n))) continue;
                return string;
            }
            n = context.getResourceLink().length;
            for (int i = 0; i < n; ++i) {
                if (!string.equals(context.getResourceLinkName(i))) continue;
                return context.getResourceLinkGlobal(i);
            }
        }
        return null;
    }

    public String findDatasourceJndiNameForEjb(String string, String string2) throws ConfigurationException {
        return null;
    }

    private static interface ContextModifier {
        public void modify(Context var1);
    }
}

