/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.Parser;
import org.apache.commons.jxpath.ri.compiler.Constant;
import org.apache.commons.jxpath.ri.compiler.CoreFunction;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.CoreOperationAdd;
import org.apache.commons.jxpath.ri.compiler.CoreOperationAnd;
import org.apache.commons.jxpath.ri.compiler.CoreOperationDivide;
import org.apache.commons.jxpath.ri.compiler.CoreOperationEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationGreaterThan;
import org.apache.commons.jxpath.ri.compiler.CoreOperationGreaterThanOrEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationLessThan;
import org.apache.commons.jxpath.ri.compiler.CoreOperationLessThanOrEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationMod;
import org.apache.commons.jxpath.ri.compiler.CoreOperationMultiply;
import org.apache.commons.jxpath.ri.compiler.CoreOperationNegate;
import org.apache.commons.jxpath.ri.compiler.CoreOperationNotEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationOr;
import org.apache.commons.jxpath.ri.compiler.CoreOperationSubtract;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.ExpressionPath;
import org.apache.commons.jxpath.ri.compiler.ExtensionFunction;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.compiler.VariableReference;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.StepNodeNameTest;
import org.netbeans.modules.xml.xpath.StepNodeTest;
import org.netbeans.modules.xml.xpath.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.XPathLiteral;
import org.netbeans.modules.xml.xpath.XPathLocationPath;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xml.xpath.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.common.MessageManager;
import org.netbeans.modules.xml.xpath.impl.LocationStepImpl;
import org.netbeans.modules.xml.xpath.impl.XPathTreeCompiler;

public class XPathModelImpl
implements XPathModel {
    private Compiler mCompiler = new XPathTreeCompiler();
    private static final Logger mLogger = Logger.getLogger(XPathModelImpl.class.getName());
    private static MessageManager mMsgMgr = MessageManager.getManager(XPathModelImpl.class);

    public XPathExpression parseExpression(String string) throws XPathException {
        try {
            Object object = Parser.parseExpression((String)string, (Compiler)this.mCompiler);
            if (object instanceof Expression) {
                return this.processExpression((Expression)object);
            }
            XPathException xPathException = new XPathException(mMsgMgr.getString("Unhandled_XPath_Expression", string, object.toString()));
            mLogger.log(Level.FINEST, "parseExpression", xPathException);
            throw xPathException;
        }
        catch (JXPathException jXPathException) {
            mLogger.log(Level.FINEST, "parseExpression", jXPathException);
            throw new XPathException((Exception)((Object)jXPathException));
        }
    }

    XPathExpression processExpression(Expression expression) throws XPathException {
        if (expression instanceof LocationPath) {
            return this.processLocationPath((LocationPath)expression);
        }
        if (expression instanceof CoreFunction) {
            return this.processCoreFunction((CoreFunction)expression);
        }
        if (expression instanceof ExtensionFunction) {
            return this.processExtensionFunction((ExtensionFunction)expression);
        }
        if (expression instanceof CoreOperation) {
            return this.processCoreOperation((CoreOperation)expression);
        }
        if (expression instanceof Constant) {
            return this.processConstant((Constant)expression);
        }
        if (expression instanceof VariableReference) {
            return this.processVariableReference((VariableReference)expression);
        }
        if (expression instanceof ExpressionPath) {
            return this.processExpressionPath((ExpressionPath)expression);
        }
        XPathException xPathException = new XPathException(mMsgMgr.getString("Unhandled_Expression_Type", expression.toString()));
        mLogger.log(Level.FINEST, "processExpression", xPathException);
        throw xPathException;
    }

    XPathExpression processVariableReference(VariableReference variableReference) throws XPathException {
        return AbstractXPathModelHelper.getInstance().newXPathVariableReference(variableReference);
    }

    XPathExpression processConstant(Constant constant) throws XPathException {
        XPathLiteral xPathLiteral;
        Object object = constant.computeValue(null);
        if (object instanceof String) {
            xPathLiteral = AbstractXPathModelHelper.getInstance().newXPathStringLiteral((String)object);
        } else if (object instanceof Number) {
            xPathLiteral = AbstractXPathModelHelper.getInstance().newXPathNumericLiteral((Number)object);
        } else {
            XPathException xPathException = new XPathException(mMsgMgr.getString("Invalid_XPath_Constant", object));
            mLogger.log(Level.FINEST, "processConstant", xPathException);
            throw xPathException;
        }
        mLogger.finer("constant=" + constant + " value=" + object);
        return xPathLiteral;
    }

    XPathExpression processCoreFunction(CoreFunction coreFunction) throws XPathException {
        int n = this.getCoreFunctionCode(coreFunction);
        Expression[] expressionArray = coreFunction.getArguments();
        if (-1 == n) {
            XPathException xPathException = new XPathException(mMsgMgr.getString("Unhandled_XPath_Function", coreFunction.toString()));
            mLogger.log(Level.FINEST, "processCoreFunction", xPathException);
            throw xPathException;
        }
        XPathCoreFunction xPathCoreFunction = AbstractXPathModelHelper.getInstance().newXPathCoreFunction(n);
        if (expressionArray != null) {
            for (int i = 0; i < expressionArray.length; ++i) {
                xPathCoreFunction.addChild(this.processExpression(expressionArray[i]));
            }
        }
        mLogger.finer("coreFunction=" + coreFunction);
        return xPathCoreFunction;
    }

    XPathExpression processCoreOperation(CoreOperation coreOperation) throws XPathException {
        int n = this.getCoreOperationCode(coreOperation);
        Expression[] expressionArray = coreOperation.getArguments();
        if (-1 == n) {
            XPathException xPathException = new XPathException(mMsgMgr.getString("Unhandled_XPath_Operator", coreOperation.toString()));
            mLogger.log(Level.FINEST, "processCoreOperation", xPathException);
            throw xPathException;
        }
        XPathCoreOperation xPathCoreOperation = AbstractXPathModelHelper.getInstance().newXPathCoreOperation(n);
        for (int i = 0; i < expressionArray.length; ++i) {
            xPathCoreOperation.addChild(this.processExpression(expressionArray[i]));
        }
        mLogger.finer("coreOperation=" + coreOperation);
        return xPathCoreOperation;
    }

    XPathExpression processExtensionFunction(ExtensionFunction extensionFunction) throws XPathException {
        String string = extensionFunction.getFunctionName().toString();
        Expression[] expressionArray = extensionFunction.getArguments();
        if (null == string) {
            XPathException xPathException = new XPathException(mMsgMgr.getString("Unhandled_XPath_Function", extensionFunction.toString()));
            mLogger.log(Level.FINEST, "processExtensionFunction", xPathException);
            throw xPathException;
        }
        if (!XPathModelImpl.isValidFunction(string)) {
            XPathException xPathException = new XPathException(mMsgMgr.getString("Invalid_XPath_Function", extensionFunction.toString()));
            mLogger.log(Level.FINEST, "processExtensionFunction", xPathException);
            throw xPathException;
        }
        XPathExtensionFunction xPathExtensionFunction = AbstractXPathModelHelper.getInstance().newXPathExtensionFunction(string);
        if (expressionArray != null) {
            for (int i = 0; i < expressionArray.length; ++i) {
                xPathExtensionFunction.addChild(this.processExpression(expressionArray[i]));
            }
        }
        mLogger.finer("extensionFunction=" + extensionFunction + " name=" + string);
        return xPathExtensionFunction;
    }

    XPathExpression processLocationPath(LocationPath locationPath) throws XPathException {
        Step[] stepArray = locationPath.getSteps();
        ArrayList<LocationStep> arrayList = new ArrayList<LocationStep>();
        if (stepArray != null) {
            for (int i = 0; i < stepArray.length; ++i) {
                arrayList.add(this.processStep(stepArray[i]));
            }
        }
        LocationStep[] locationStepArray = new LocationStepImpl[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            locationStepArray[n] = (LocationStep)iterator.next();
            ++n;
        }
        XPathLocationPath xPathLocationPath = AbstractXPathModelHelper.getInstance().newXPathLocationPath(locationStepArray);
        xPathLocationPath.setAbsolute(locationPath.isAbsolute());
        xPathLocationPath.setSimplePath(locationPath.isSimplePath());
        return xPathLocationPath;
    }

    XPathExpression processExpressionPath(ExpressionPath expressionPath) throws XPathException {
        Expression expression = expressionPath.getExpression();
        XPathExpression xPathExpression = null;
        if (expression != null) {
            xPathExpression = this.processExpression(expression);
        }
        Step[] stepArray = expressionPath.getSteps();
        ArrayList<LocationStep> arrayList = new ArrayList<LocationStep>();
        if (stepArray != null) {
            for (int i = 0; i < stepArray.length; ++i) {
                arrayList.add(this.processStep(stepArray[i]));
            }
        }
        LocationStep[] locationStepArray = new LocationStepImpl[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            locationStepArray[n] = (LocationStep)iterator.next();
            ++n;
        }
        XPathExpressionPath xPathExpressionPath = AbstractXPathModelHelper.getInstance().newXPathExpressionPath(xPathExpression, locationStepArray);
        xPathExpressionPath.setSimplePath(expressionPath.isSimplePath());
        return xPathExpressionPath;
    }

    LocationStep processStep(Step step) throws XPathException {
        int n = this.getAxis(step.getAxis());
        NodeTest nodeTest = step.getNodeTest();
        Expression[] expressionArray = step.getPredicates();
        Object var5_5 = null;
        StepNodeTest stepNodeTest = null;
        if (nodeTest instanceof NodeNameTest) {
            stepNodeTest = new StepNodeNameTest(((NodeNameTest)nodeTest).getNodeName().toString());
        } else if (nodeTest instanceof NodeTypeTest) {
            stepNodeTest = new StepNodeTypeTest(this.getNodeType(((NodeTypeTest)nodeTest).getNodeType()));
        } else {
            XPathException xPathException = new XPathException(mMsgMgr.getString("Invalid_Location_Step", step.toString()));
            mLogger.log(Level.FINEST, "processStep", xPathException);
            throw xPathException;
        }
        XPathPredicateExpression[] xPathPredicateExpressionArray = null;
        if (expressionArray != null && expressionArray.length > 0) {
            XPathExpression[] xPathExpressionArray = null;
            xPathExpressionArray = new XPathExpression[expressionArray.length];
            xPathPredicateExpressionArray = new XPathPredicateExpression[expressionArray.length];
            int n2 = expressionArray.length;
            for (int i = 0; i < n2; ++i) {
                xPathExpressionArray[i] = this.processExpression(expressionArray[i]);
                if (xPathExpressionArray[i] instanceof XPathNumericLiteral) {
                    xPathExpressionArray[i] = AbstractXPathModelHelper.getInstance().newXPathPredicateNumericLiteral(new Long(((XPathNumericLiteral)xPathExpressionArray[i]).getValue().longValue()));
                }
                xPathPredicateExpressionArray[i] = AbstractXPathModelHelper.getInstance().newXPathPredicateExpression(xPathExpressionArray[i]);
            }
        }
        return new LocationStepImpl(n, stepNodeTest, xPathPredicateExpressionArray);
    }

    int getAxis(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 13: {
                return 11;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 13;
            }
        }
        return -1;
    }

    int getNodeType(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    int getCoreFunctionCode(CoreFunction coreFunction) {
        int n = coreFunction.getFunctionCode();
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 27: {
                return 27;
            }
            case 28: {
                return 28;
            }
            case 29: {
                return 29;
            }
            case 30: {
                return 30;
            }
            case 31: {
                return 31;
            }
        }
        return -1;
    }

    int getCoreOperationCode(CoreOperation coreOperation) {
        if (coreOperation instanceof CoreOperationAdd) {
            return 1;
        }
        if (coreOperation instanceof CoreOperationSubtract) {
            return 2;
        }
        if (coreOperation instanceof CoreOperationMultiply) {
            return 3;
        }
        if (coreOperation instanceof CoreOperationDivide) {
            return 4;
        }
        if (coreOperation instanceof CoreOperationMod) {
            return 5;
        }
        if (coreOperation instanceof CoreOperationNegate) {
            return 6;
        }
        if (coreOperation instanceof CoreOperationAnd) {
            return 7;
        }
        if (coreOperation instanceof CoreOperationOr) {
            return 8;
        }
        if (coreOperation instanceof CoreOperationEqual) {
            return 9;
        }
        if (coreOperation instanceof CoreOperationNotEqual) {
            return 10;
        }
        if (coreOperation instanceof CoreOperationLessThan) {
            return 11;
        }
        if (coreOperation instanceof CoreOperationLessThanOrEqual) {
            return 12;
        }
        if (coreOperation instanceof CoreOperationGreaterThan) {
            return 13;
        }
        if (coreOperation instanceof CoreOperationGreaterThanOrEqual) {
            return 14;
        }
        return -1;
    }

    static boolean isValidFunction(String string) {
        for (int i = 0; i < VALID_FUNCTION_NAMES.length; ++i) {
            if (!string.equals(VALID_FUNCTION_NAMES[i])) continue;
            return true;
        }
        String string2 = string;
        int n = string2.indexOf(58);
        if (n != -1) {
            string2 = string2.substring(n + 1, string2.length());
        }
        for (int i = 0; i < VALID_BPWS_FUNCTION_NAMES.length; ++i) {
            if (!string2.equals(VALID_BPWS_FUNCTION_NAMES[i])) continue;
            return true;
        }
        return false;
    }
}

