/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openide.util.Utilities;

public class ResultItemPaintComponent
extends JPanel {
    static final String PACKAGE = "org/netbeans/modules/editor/resources/completion/defaultFolder.gif";
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static String str;
    private static final String[] frequentWords;
    public static final Color KEYWORD_COLOR;
    public static final Color TYPE_COLOR;

    public ResultItemPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public void setString(String string) {
        str = string;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    protected void setDeprecated(boolean bl) {
        this.isDeprecated = bl;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    protected Icon getIcon() {
        return null;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics graphics, String string) {
        this.drawString(graphics, string, false);
    }

    protected void drawString(Graphics graphics, String string, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawStringToGraphics(graphics, string, this.getDrawFont(), bl);
    }

    protected void drawString(Graphics graphics, String string, Color color) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
        }
        this.drawStringToGraphics(graphics, string);
    }

    protected void drawString(Graphics graphics, String string, Color color, Font font, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
            graphics.setFont(font);
        }
        this.drawStringToGraphics(graphics, string, font, bl);
        if (graphics != null) {
            graphics.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics graphics, String string, Color color) {
        if (graphics == null) {
            this.drawString(graphics, "   ");
            this.drawString(graphics, string, color);
        } else {
            int n = this.getWidth(" ");
            this.drawX = this.getWidth() - this.getWidth(string) < this.drawX ? (this.drawX += n * 2) : this.getWidth() - this.getWidth(string) - 4;
            this.drawString(graphics, string, color);
        }
    }

    protected void drawStringToGraphics(Graphics graphics, String string) {
        this.drawStringToGraphics(graphics, string, null, false);
    }

    protected void drawStringToGraphics(Graphics graphics, String string, Font font, boolean bl) {
        if (graphics != null) {
            if (!bl) {
                graphics.drawString(string, this.drawX, this.drawY);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
                graphics2D.drawString(attributedString.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string) {
        Integer n = (Integer)this.widths.get(string);
        if (n != null) {
            return n;
        }
        if (string == null) {
            string = "";
        }
        return this.fontMetrics.stringWidth(string);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.getWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected Color getColor(String string, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    private void storeWidth(String string) {
        this.fontMetrics.stringWidth(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        this.setFont(font);
        this.draw(graphics);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return this.drawX;
    }

    static {
        frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", THROWS};
        KEYWORD_COLOR = Color.darkGray;
        TYPE_COLOR = Color.black;
    }

    public static class ELFunctionPaintComponent
    extends ELPaintComponent {
        private String prefix = null;
        private String parameters = null;
        private static final Color PREFIX_COLOR = Color.blue.darker().darker();
        private static final Color FUNCTION_NAME_COLOR = Color.black;
        private static final Color PARAMETER_COLOR = Color.black;
        private static final String ICON_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/function_16.png";

        protected Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)ICON_PATH));
        }

        public Color getExpressionColor() {
            return FUNCTION_NAME_COLOR;
        }

        public void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.prefix, PREFIX_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            this.drawString(graphics, ":" + str, FUNCTION_NAME_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            this.drawParameters(graphics, this.parameters);
            if (this.getTypeName() != null) {
                this.drawTypeName(graphics, this.getTypeName(), this.getTypeColor());
            }
        }

        protected void drawParameters(Graphics graphics, String string) {
            this.drawString(graphics, "(", PARAMETER_COLOR);
            if (this.parameters != null) {
                this.drawString(graphics, this.parameters, PARAMETER_COLOR);
            }
            this.drawString(graphics, ")", PARAMETER_COLOR);
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public void setParameters(String string) {
            this.parameters = string;
        }
    }

    public static class ELPropertyPaintComponent
    extends ELPaintComponent {
        public static final Color PROPERTY_NAME_COLOR = Color.blue.darker().darker();
        private static final String PROPERTY_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/property_16.png";

        protected Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)PROPERTY_PATH));
        }

        public Color getExpressionColor() {
            return PROPERTY_NAME_COLOR;
        }
    }

    public static class ELBeanPaintComponent
    extends ELPaintComponent {
        public static final Color BEAN_NAME_COLOR = Color.blue.darker().darker();
        private static final String BEAN_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/bean_16.png";

        protected Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)BEAN_PATH));
        }

        public Color getExpressionColor() {
            return BEAN_NAME_COLOR;
        }
    }

    public static class ELImplicitObjectPaintComponent
    extends ELPaintComponent {
        private int type = 0;
        private static final String OBJECT_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/class_16.png";
        private static final String MAP_PATH = "org/netbeans/modules/web/core/syntax/completion/resources/map_16.png";

        protected Icon getIcon() {
            ImageIcon imageIcon = null;
            switch (this.type) {
                case 0: {
                    imageIcon = new ImageIcon(Utilities.loadImage((String)OBJECT_PATH));
                    break;
                }
                case 1: {
                    imageIcon = new ImageIcon(Utilities.loadImage((String)MAP_PATH));
                }
            }
            return imageIcon;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }
    }

    public static class ELPaintComponent
    extends ResultItemPaintComponent {
        private String typeName = null;

        public void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, str, this.getExpressionColor(), new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            if (this.getTypeName() != null) {
                this.drawTypeName(graphics, this.getTypeName(), this.getTypeColor());
            }
        }

        public Color getExpressionColor() {
            return Color.blue;
        }

        public Color getTypeColor() {
            return Color.BLACK;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }
    }

    public static class AttributePaintComponent
    extends ResultItemPaintComponent {
        private boolean mandatory;

        public AttributePaintComponent(boolean bl) {
            this.mandatory = bl;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, str, this.mandatory ? Color.RED : Color.GREEN.darker());
        }
    }

    public static class JspDirectivePaintComponent
    extends ResultItemPaintComponent {
        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, "<%@ ");
            this.drawString(graphics, str, Color.BLUE, this.getDrawFont().deriveFont(1), false);
            this.drawString(graphics, " ... ", Color.GREEN.darker());
            this.drawString(graphics, "%>");
        }
    }

    public static class JspTagPaintComponent
    extends ResultItemPaintComponent {
        private boolean isEmpty;

        public JspTagPaintComponent(boolean bl) {
            this.isEmpty = bl;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, "<");
            this.drawString(graphics, str, Color.BLUE, this.getDrawFont().deriveFont(1), false);
            if (this.isEmpty) {
                this.drawString(graphics, "/>");
            } else {
                this.drawString(graphics, ">");
            }
        }
    }

    public static class AbbrevPaintComponent
    extends ResultItemPaintComponent {
        private String abbrev;

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.abbrev, Color.BLUE, this.getDrawFont().deriveFont(1), false);
            this.drawString(graphics, " " + str, TYPE_COLOR);
        }

        public void setAbbrev(String string) {
            this.abbrev = string;
        }
    }

    public static class StringPaintComponent
    extends ResultItemPaintComponent {
        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, str, TYPE_COLOR);
        }
    }
}

