/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifiedJSPServlet {
    private static final String CLASS_HEADER = "\nclass SimplifiedJSPServlet extends %s {\n\tprivate static final long serialVersionUID = 1L;\n";
    private static final String METHOD_HEADER = "\n\tvoid mergedScriptlets(\n\t\tHttpServletRequest request,\n\t\tHttpServletResponse response,\n\t\tHttpSession session,\n\t\tServletContext application,\n\t\tJspWriter out,\n\t\tServletConfig config,\n\t\tJspContext jspContext,\n\t\tObject page,\n\t\tPageContext pageContext,\n\t\tThrowable exception\n\t) throws Throwable {\n";
    private static final String CLASS_FOOTER = "\n\t}\n}";
    private final Document doc;
    private CharSequence charSequence;
    private final FileObject fobj;
    private final ArrayList<CodeBlockData> codeBlocks = new ArrayList();
    private String header = null;
    private StringBuilder scriptlets = new StringBuilder();
    private StringBuilder declarations = new StringBuilder();
    private String beanDeclarations = null;
    private boolean processCalled = false;
    private String importStatements = null;
    private int expressionIndex = 1;
    private static final Logger logger = Logger.getLogger(SimplifiedJSPServlet.class.getName());
    private boolean processingSuccessful = true;

    public SimplifiedJSPServlet(Document document) {
        this(document, null);
    }

    public SimplifiedJSPServlet(Document document, CharSequence charSequence) {
        this.doc = document;
        if (charSequence == null) {
            try {
                this.charSequence = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                assert (false);
            }
        } else {
            this.charSequence = charSequence;
        }
        if (document != null) {
            DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
            this.fobj = dataObject != null ? NbEditorUtilities.getDataObject((Document)document).getPrimaryFile() : null;
        } else {
            logger.log(Level.SEVERE, "Unable to find FileObject for document");
            this.fobj = null;
        }
    }

    public void process() throws BadLocationException {
        this.process(false);
    }

    public void process(boolean bl) throws BadLocationException {
        JspParserAPI.ParseResult parseResult;
        this.processCalled = true;
        if (!this.isServletAPIOnClasspath()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimplifiedJSPServlet.this.displayServletAPIMissingWarning();
                }
            });
            this.processingSuccessful = false;
            return;
        }
        if (!(DocumentUtilities.isWriteLocked((Document)this.doc) || (parseResult = JspUtils.getCachedParseResult(this.doc, this.fobj, false, false)) != null && parseResult.isParsingSuccess())) {
            this.processingSuccessful = false;
            return;
        }
        parseResult = new BadLocationException[1];
        this.processIncludes();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)this.charSequence, (Language)JspTokenId.language());
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (!tokenSequence.moveNext()) {
            return;
        }
        do {
            Object object;
            Token token;
            if ((token = tokenSequence.token()).id() != JspTokenId.SCRIPTLET) continue;
            int n = token.offset(tokenHierarchy);
            int n2 = n + token.length();
            JspTokenId.JavaCodeType javaCodeType = (JspTokenId.JavaCodeType)token.getProperty((Object)"JAVA_CODE_TYPE");
            String string = ((Object)this.charSequence.subSequence(n, n2)).toString();
            StringBuilder stringBuilder = javaCodeType == JspTokenId.JavaCodeType.DECLARATION ? this.declarations : this.scriptlets;
            int n3 = stringBuilder.length();
            if (javaCodeType == JspTokenId.JavaCodeType.EXPRESSION) {
                if (!bl) {
                    object = String.format("\t\tObject expr%1$d = \"\" + (", this.expressionIndex++);
                    n3 += ((String)object).length();
                    stringBuilder.append((String)object + string + ");\n");
                }
            } else {
                stringBuilder.append(string + "\n");
            }
            object = new CodeBlockData(n, n3, n2, javaCodeType);
            this.codeBlocks.add((CodeBlockData)object);
        } while (tokenSequence.moveNext());
        if (parseResult[0] != null) {
            throw parseResult[0];
        }
        this.header = this.getClassHeader();
        this.importStatements = this.createImportStatements();
        this.beanDeclarations = "\n" + this.createBeanVarDeclarations();
    }

    private void processIncludes() {
        Object object2;
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo == null) {
            return;
        }
        final TreeSet<String> treeSet = new TreeSet<String>(Collections.singleton(this.fobj.getPath()));
        for (Object object2 : pageInfo.getIncludePrelude()) {
            this.processIncludedFile((String)object2, treeSet);
        }
        Iterator iterator = new Node.Visitor(){

            public void visit(Node.IncludeDirective includeDirective) throws JspException {
                String string = includeDirective.getAttributeValue("file");
                SimplifiedJSPServlet.this.processIncludedFile(string, treeSet);
            }
        };
        object2 = JspSyntaxSupport.get(this.doc);
        try {
            JspParserAPI.ParseResult parseResult = ((JspSyntaxSupport)((Object)object2)).getParseResult();
            if (parseResult != null) {
                parseResult.getNodes().visit(iterator);
            }
        }
        catch (JspException jspException) {
            Exceptions.printStackTrace((Throwable)jspException);
        }
    }

    private void processIncludedFile(String string, Collection<String> collection) {
        FileObject fileObject = JspUtils.getFileObject(this.doc, string);
        if (fileObject != null && fileObject.canRead() && !collection.contains(fileObject.getPath())) {
            collection.add(fileObject.getPath());
            try {
                EditorCookie editorCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                String string2 = fileObject.getMIMEType();
                if (("text/x-jsp".equals(string2) || "text/x-tag".equals(string2)) && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                    SimplifiedJSPServlet simplifiedJSPServlet = new SimplifiedJSPServlet(editorCookie.openDocument());
                    simplifiedJSPServlet.process(true);
                    this.declarations.append((CharSequence)simplifiedJSPServlet.declarations);
                    this.scriptlets.append((CharSequence)simplifiedJSPServlet.scriptlets);
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
    }

    private boolean isServletAPIOnClasspath() {
        ClassPath classPath = ClassPath.getClassPath((FileObject)this.fobj, (String)"classpath/compile");
        return classPath != null && classPath.findResource("javax/servlet/http/HttpServlet.class") != null;
    }

    private void displayServletAPIMissingWarning() {
        try {
            JEditorPane jEditorPane;
            DataObject dataObject = DataObject.find((FileObject)this.fobj);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null && editorCookie.getOpenedPanes() != null && (jEditorPane = editorCookie.getOpenedPanes()[0]) != null) {
                Utilities.setStatusBoldText((JTextComponent)jEditorPane, (String)NbBundle.getMessage(SimplifiedJSPServlet.class, (String)"MSG_MissingServletAPI"));
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }

    private String createBeanVarDeclarations() {
        StringBuilder stringBuilder = new StringBuilder();
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            PageInfo.BeanData[] beanDataArray = this.getBeanData();
            if (beanDataArray != null) {
                for (PageInfo.BeanData beanData : beanDataArray) {
                    stringBuilder.append(beanData.getClassName() + " " + beanData.getId() + ";\n");
                }
            }
            if (pageInfo.isTagFile()) {
                for (PageInfo.BeanData beanData : pageInfo.getTagInfo().getAttributes()) {
                    if (beanData.getTypeName() == null) continue;
                    stringBuilder.append(beanData.getTypeName() + " " + beanData.getName() + ";\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    private String[] getImports() {
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo == null) {
            return new String[]{"javax.servlet.*", "javax.servlet.http.*", "javax.servlet.jsp.*"};
        }
        List list = pageInfo.getImports();
        return list.toArray(new String[list.size()]);
    }

    private PageInfo.BeanData[] getBeanData() {
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            return pageInfo.getBeans();
        }
        return null;
    }

    private PageInfo getPageInfo() {
        if (DocumentUtilities.isWriteLocked((Document)this.doc)) {
            return null;
        }
        JspParserAPI.ParseResult parseResult = JspUtils.getCachedParseResult(this.doc, this.fobj, true, false);
        if (parseResult != null) {
            return parseResult.getPageInfo();
        }
        logger.log(Level.INFO, null, "PageInfo obtained from JspParserAPI.ParseResult is null");
        return null;
    }

    private String createImportStatements() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.getImports();
        if (stringArray == null || stringArray.length == 0) {
            this.processingSuccessful = false;
        } else {
            for (String string : stringArray) {
                stringBuilder.append("import " + string + ";\n");
            }
        }
        return stringBuilder.toString();
    }

    private String getClassHeader() {
        String string = null;
        PageInfo pageInfo = this.getPageInfo();
        if (pageInfo != null) {
            string = pageInfo.getExtends();
        }
        if (string == null || "org.apache.jasper.runtime.HttpJspBase".equals(string)) {
            string = "HttpServlet";
        }
        return String.format(CLASS_HEADER, string);
    }

    private void assureProcessCalled() {
        if (!this.processCalled) {
            throw new IllegalStateException("process() method must be called first!");
        }
    }

    public int getShiftedOffset(int n) {
        this.assureProcessCalled();
        CodeBlockData codeBlockData = this.getCodeBlockAtOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.getStartOffset();
        int n3 = codeBlockData.getNewBlockStart() + n2;
        return n3;
    }

    public int getRealOffset(int n) {
        this.assureProcessCalled();
        if (this.processingSuccessful) {
            for (CodeBlockData codeBlockData : this.codeBlocks) {
                int n2 = codeBlockData.getEndOffset() - codeBlockData.getStartOffset();
                if (codeBlockData.getNewBlockStart() > n || codeBlockData.getNewBlockStart() + n2 < n) continue;
                return codeBlockData.getStartOffset() + n - codeBlockData.getNewBlockStart();
            }
        }
        return -1;
    }

    public String getVirtualClassBody() {
        this.assureProcessCalled();
        if (!this.processingSuccessful) {
            return "";
        }
        String string = this.importStatements + this.header + this.declarations + this.beanDeclarations + METHOD_HEADER + this.scriptlets + CLASS_FOOTER;
        return string;
    }

    private CodeBlockData getCodeBlockAtOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.getStartOffset() > n || codeBlockData.getEndOffset() < n) continue;
            return codeBlockData;
        }
        return null;
    }

    private class CodeBlockData {
        private int startOffset;
        private int endOffset;
        private int newRelativeBlockStart;
        private JspTokenId.JavaCodeType type;

        public CodeBlockData(int n, int n2, int n3, JspTokenId.JavaCodeType javaCodeType) {
            this.startOffset = n;
            this.newRelativeBlockStart = n2;
            this.endOffset = n3;
            this.type = javaCodeType;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public JspTokenId.JavaCodeType getType() {
            return this.type;
        }

        public int getNewBlockStart() {
            int n = this.newRelativeBlockStart + SimplifiedJSPServlet.this.header.length() + SimplifiedJSPServlet.this.importStatements.length();
            if (this.getType() != JspTokenId.JavaCodeType.DECLARATION) {
                n += SimplifiedJSPServlet.this.declarations.length() + SimplifiedJSPServlet.this.beanDeclarations.length() + SimplifiedJSPServlet.METHOD_HEADER.length();
            }
            return n;
        }
    }

    public static abstract class VirtualJavaClass {
        public final void create(Document document, String string) {
            FileObject fileObject = null;
            Object var4_4 = null;
            try {
                FileSystem fileSystem = FileUtil.createMemoryFileSystem();
                fileObject = fileSystem.getRoot().createData("SimplifiedJSPServlet", "java");
                PrintWriter printWriter = new PrintWriter(fileObject.getOutputStream());
                printWriter.print(string);
                printWriter.close();
                FileObject fileObject2 = NbEditorUtilities.getFileObject((Document)document);
                ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject2);
                JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{fileObject});
                this.process(fileObject, javaSource);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }

        protected abstract void process(FileObject var1, JavaSource var2);
    }
}

