/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;

public class JspColoringUpdater {
    private static final Logger LOGGER = Logger.getLogger(JspColoringUpdater.class.getName());
    private Document doc;

    public static JspColoringUpdater init(Document document) {
        JspColoringUpdater jspColoringUpdater = (JspColoringUpdater)document.getProperty(JspColoringUpdater.class);
        if (jspColoringUpdater == null) {
            jspColoringUpdater = new JspColoringUpdater(document);
            document.putProperty(JspColoringUpdater.class, jspColoringUpdater);
        }
        return jspColoringUpdater;
    }

    private JspColoringUpdater(Document document) {
        this.doc = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmbedding(String string, int n, int n2, int n3, int n4) {
        if (n >= n2) {
            LOGGER.log(Level.WARNING, "startOffset >= endOffset: " + n + " >= " + n2);
            return;
        }
        Language language = Language.find((String)string);
        if (language == null) {
            LOGGER.log(Level.WARNING, "No " + string + " language found! (" + n + " - " + n2 + ")");
            return;
        }
        ((BaseDocument)this.doc).extWriteLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JspTokenId.language());
            if (tokenSequence == null) {
                LOGGER.log(Level.WARNING, "Trying to create embedding for " + string + " [" + n + " - " + n2 + "]: cannot get HTML token sequence!");
                return;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            boolean bl = true;
            boolean bl2 = false;
            do {
                Token token = tokenSequence.token();
                boolean bl3 = tokenSequence.moveNext();
                boolean bl4 = bl2 = !bl3 || tokenSequence.offset() >= n2;
                if (bl3) {
                    tokenSequence.movePrevious();
                }
                if (tokenSequence.embedded(language) == null) {
                    if (!tokenSequence.createEmbedding(language, bl ? n3 : 0, bl2 ? n4 : 0)) {
                        LOGGER.log(Level.WARNING, "Cannot create embedding for " + string + " [" + n + " - " + n2 + "] (" + ((Object)token.text()).toString() + ")");
                    } else {
                        LOGGER.log(Level.INFO, "Embedding for " + string + " created [" + n + " - " + n2 + "] (" + this.printEmbeddedText(token, bl ? n3 : 0, bl2 ? n4 : 0) + ")");
                    }
                }
                bl = false;
                if (bl2) continue;
                tokenSequence.moveNext();
            } while (!bl2);
        }
        finally {
            ((BaseDocument)this.doc).extWriteUnlock();
        }
    }

    private CharSequence printEmbeddedText(Token token, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(token.text());
        if (n > 0) {
            stringBuffer.insert(n, '[');
        }
        if (n2 > 0) {
            stringBuffer.insert(stringBuffer.length() - n2, ']');
        }
        return stringBuffer;
    }
}

