/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class PersistenceUnitWizard
implements WizardDescriptor.InstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private Project project;
    private PersistenceUnitWizardDescriptor descriptor;
    private static final Logger LOG = Logger.getLogger(PersistenceUnitWizard.class.getName());

    public static PersistenceUnitWizard create() {
        return new PersistenceUnitWizard();
    }

    public String name() {
        return NbBundle.getMessage(PersistenceUnitWizard.class, (String)"LBL_WizardTitle");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.descriptor = new PersistenceUnitWizardDescriptor(this.project);
        this.panels = new WizardDescriptor.Panel[]{this.descriptor};
        wizardDescriptor.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(PersistenceUnitWizard.class, (String)"Templates/Persistence/PersistenceUnit"));
        Wizards.mergeSteps((WizardDescriptor)wizardDescriptor, (WizardDescriptor.Panel[])this.panels, null);
    }

    public Set instantiate() throws IOException {
        Object object;
        PersistenceUnit persistenceUnit = null;
        LOG.fine("Instantiating...");
        if (this.descriptor.isContainerManaged()) {
            LOG.fine("Creating a container managed PU");
            persistenceUnit = new PersistenceUnit();
            if (this.descriptor.getDatasource() != null && !"".equals(this.descriptor.getDatasource())) {
                if (this.descriptor.isJTA()) {
                    persistenceUnit.setJtaDataSource(this.descriptor.getDatasource());
                } else {
                    persistenceUnit.setNonJtaDataSource(this.descriptor.getDatasource());
                    persistenceUnit.setTransactionType("RESOURCE_LOCAL");
                }
            }
            if (this.descriptor.isNonDefaultProviderEnabled()) {
                Library library;
                object = this.descriptor.getNonDefaultProvider();
                persistenceUnit.setProvider((String)object);
                if (((String)object).equals("org.hibernate.ejb.HibernatePersistence") && (library = LibraryManager.getDefault().getLibrary("hibernate-support")) != null) {
                    Util.addLibraryToProject(this.project, library);
                }
            }
        } else {
            LOG.fine("Creating an application managed PU");
            persistenceUnit = ProviderUtil.buildPersistenceUnit(this.descriptor.getPersistenceUnitName(), this.descriptor.getSelectedProvider(), this.descriptor.getPersistenceConnection());
            persistenceUnit.setTransactionType("RESOURCE_LOCAL");
            object = PersistenceLibrarySupport.getLibrary(this.descriptor.getSelectedProvider());
            if (object != null) {
                Util.addLibraryToProject(this.project, (Library)object);
            }
        }
        persistenceUnit.setName(this.descriptor.getPersistenceUnitName());
        ProviderUtil.setTableGeneration(persistenceUnit, this.descriptor.getTableGeneration(), this.project);
        try {
            LOG.fine("Retrieving PUDataObject");
            object = ProviderUtil.getPUDataObject(this.project);
            ((PUDataObject)((Object)object)).addPersistenceUnit(persistenceUnit);
            LOG.fine("Saving PUDataObject");
            ((PUDataObject)((Object)object)).save();
            LOG.fine("Saved");
            return Collections.singleton(object.getPrimaryFile());
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            LOG.log(Level.FINE, "Invalid persistence.xml: " + invalidPersistenceXmlException.getPath(), invalidPersistenceXmlException);
            return Collections.emptySet();
        }
    }
}

