/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;

public class DbSchemaEjbGenerator {
    private GeneratedTables genTables;
    private Map beans = new HashMap();
    private List relations = new ArrayList();
    private SchemaElement schemaElement;

    public DbSchemaEjbGenerator(GeneratedTables generatedTables, SchemaElement schemaElement) {
        this.schemaElement = schemaElement;
        this.genTables = generatedTables;
        this.buildCMPSet();
    }

    public static boolean isJoinTable(TableElement tableElement) {
        ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
        if (foreignKeyElementArray == null || foreignKeyElementArray.length != 2) {
            return false;
        }
        int n = foreignKeyElementArray[0].getColumns().length + foreignKeyElementArray[1].getColumns().length;
        if (n < tableElement.getColumns().length) {
            return false;
        }
        String string = tableElement.getName().getName();
        for (int i = 0; i < 2; ++i) {
            if (!string.equals(foreignKeyElementArray[i].getReferencedTable().getName().getName())) continue;
            return false;
        }
        return !DbSchemaEjbGenerator.isFkUnique(foreignKeyElementArray[0]) && !DbSchemaEjbGenerator.isFkUnique(foreignKeyElementArray[1]);
    }

    private boolean isForeignKey(ForeignKeyElement[] foreignKeyElementArray, ColumnElement columnElement) {
        if (foreignKeyElementArray == null) {
            return false;
        }
        for (int i = 0; i < foreignKeyElementArray.length; ++i) {
            if (foreignKeyElementArray[i].getColumn(columnElement.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public EntityClass[] getBeans() {
        return this.beans.values().toArray(new EntityClass[this.beans.size()]);
    }

    public EntityRelation[] getRelations() {
        return this.relations.toArray(new EntityRelation[this.relations.size()]);
    }

    private EntityClass getBean(String string) {
        return (EntityClass)this.beans.get(string);
    }

    private EntityClass addBean(String string) {
        EntityClass entityClass = this.getBean(string);
        if (entityClass != null) {
            return entityClass;
        }
        entityClass = new EntityClass(this.genTables.getCatalog(), this.genTables.getSchema(), string, this.genTables.getRootFolder(string), this.genTables.getPackageName(string), this.genTables.getClassName(string), this.genTables.getUniqueConstraints(string));
        this.beans.put(string, entityClass);
        return entityClass;
    }

    private void addAllTables() {
        LinkedList<TableElement> linkedList = new LinkedList<TableElement>();
        for (String string : this.genTables.getTableNames()) {
            TableElement tableElement = this.schemaElement.getTable(DBIdentifier.create((String)string));
            if (DbSchemaEjbGenerator.isJoinTable(tableElement)) {
                linkedList.add(tableElement);
                continue;
            }
            this.addBean(string);
        }
        for (TableElement tableElement : linkedList) {
            this.addJoinTable(tableElement);
        }
    }

    private String[] localColumnNames(ForeignKeyElement foreignKeyElement) {
        ColumnPairElement[] columnPairElementArray = foreignKeyElement.getColumnPairs();
        String[] stringArray = new String[columnPairElementArray.length];
        for (int i = 0; i < columnPairElementArray.length; ++i) {
            stringArray[i] = columnPairElementArray[i].getLocalColumn().getName().getName();
        }
        return stringArray;
    }

    private String[] referencedColumnNames(ForeignKeyElement foreignKeyElement) {
        ColumnPairElement[] columnPairElementArray = foreignKeyElement.getColumnPairs();
        String[] stringArray = new String[columnPairElementArray.length];
        for (int i = 0; i < columnPairElementArray.length; ++i) {
            stringArray[i] = columnPairElementArray[i].getReferencedColumn().getName().getName();
        }
        return stringArray;
    }

    private String getRoleName(ForeignKeyElement foreignKeyElement, String string) {
        ColumnPairElement[] columnPairElementArray = foreignKeyElement.getColumnPairs();
        if (columnPairElementArray == null || columnPairElementArray.length > 1) {
            return string;
        }
        return EntityMember.makeClassName(columnPairElementArray[0].getLocalColumn().getName().getName());
    }

    private void addJoinTable(TableElement tableElement) {
        ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
        String string = foreignKeyElementArray[0].getReferencedTable().getName().getName();
        String string2 = foreignKeyElementArray[1].getReferencedTable().getName().getName();
        EntityClass entityClass = this.getBean(string);
        EntityClass entityClass2 = this.getBean(string2);
        String string3 = this.getRoleName(foreignKeyElementArray[0], entityClass.getClassName());
        String string4 = this.getRoleName(foreignKeyElementArray[1], entityClass2.getClassName());
        String string5 = EntityMember.makeRelationshipFieldName(entityClass2.getClassName(), true);
        String string6 = EntityMember.makeRelationshipFieldName(entityClass.getClassName(), true);
        string5 = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass), string5, null);
        List list = this.getFieldNames(entityClass2);
        if (string.equals(string2)) {
            list.add(string5);
        }
        string6 = DbSchemaEjbGenerator.uniqueAlgorithm(list, string6, null);
        RelationshipRole relationshipRole = new RelationshipRole(string3, entityClass.getClassName(), string5, true, true, false);
        entityClass.addRole(relationshipRole);
        RelationshipRole relationshipRole2 = new RelationshipRole(string4, entityClass2.getClassName(), string6, true, true, false);
        entityClass2.addRole(relationshipRole2);
        EntityRelation entityRelation = new EntityRelation(relationshipRole, relationshipRole2);
        this.relations.add(entityRelation);
        entityRelation.setRelationName(EntityMember.makeClassName(tableElement.getName().getName()));
        entityClass.getCMPMapping().getJoinTableMapping().put(string5, tableElement.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinTableColumnMapping = new CMPMappingModel.JoinTableColumnMapping();
        joinTableColumnMapping.setColumns(this.getColumnNames(foreignKeyElementArray[0].getColumns()));
        joinTableColumnMapping.setReferencedColumns(this.getColumnNames(foreignKeyElementArray[0].getReferencedColumns()));
        joinTableColumnMapping.setInverseColumns(this.getColumnNames(foreignKeyElementArray[1].getColumns()));
        joinTableColumnMapping.setReferencedInverseColumns(this.getColumnNames(foreignKeyElementArray[1].getReferencedColumns()));
        entityClass.getCMPMapping().getJoinTableColumnMppings().put(string5, joinTableColumnMapping);
        entityClass2.getCMPMapping().getJoinTableMapping().put(string6, tableElement.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinTableColumnMapping2 = new CMPMappingModel.JoinTableColumnMapping();
        joinTableColumnMapping2.setColumns(this.getColumnNames(foreignKeyElementArray[1].getColumns()));
        joinTableColumnMapping2.setReferencedColumns(this.getColumnNames(foreignKeyElementArray[1].getReferencedColumns()));
        joinTableColumnMapping2.setInverseColumns(this.getColumnNames(foreignKeyElementArray[0].getColumns()));
        joinTableColumnMapping2.setReferencedInverseColumns(this.getColumnNames(foreignKeyElementArray[0].getReferencedColumns()));
        entityClass2.getCMPMapping().getJoinTableColumnMppings().put(string6, joinTableColumnMapping2);
    }

    private String[] getColumnNames(ColumnElement[] columnElementArray) {
        String[] stringArray = new String[columnElementArray.length];
        for (int i = 0; i < columnElementArray.length; ++i) {
            stringArray[i] = columnElementArray[i].getName().getName();
        }
        return stringArray;
    }

    private static boolean containsSameColumns(ColumnElement[] columnElementArray, UniqueKeyElement uniqueKeyElement) {
        if (columnElementArray.length == uniqueKeyElement.getColumns().length) {
            for (int i = 0; i < columnElementArray.length; ++i) {
                if (uniqueKeyElement.getColumn(columnElementArray[i].getName()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean containsColumns(ColumnElement[] columnElementArray, UniqueKeyElement uniqueKeyElement) {
        if (uniqueKeyElement == null) {
            return false;
        }
        for (int i = 0; i < columnElementArray.length; ++i) {
            if (uniqueKeyElement.getColumn(columnElementArray[i].getName()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isFkUnique(ForeignKeyElement foreignKeyElement) {
        UniqueKeyElement[] uniqueKeyElementArray = foreignKeyElement.getDeclaringTable().getUniqueKeys();
        if (uniqueKeyElementArray == null) {
            return false;
        }
        ColumnElement[] columnElementArray = foreignKeyElement.getColumns();
        for (int i = 0; i < uniqueKeyElementArray.length; ++i) {
            if (!DbSchemaEjbGenerator.containsSameColumns(columnElementArray, uniqueKeyElementArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isNullable(ForeignKeyElement foreignKeyElement) {
        ColumnElement[] columnElementArray = foreignKeyElement.getColumns();
        int n = columnElementArray != null ? columnElementArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (columnElementArray[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    private static UniqueKeyElement getPrimaryOrCandidateKey(TableElement tableElement) {
        UniqueKeyElement uniqueKeyElement = tableElement.getPrimaryKey();
        if (uniqueKeyElement != null) {
            return uniqueKeyElement;
        }
        UniqueKeyElement[] uniqueKeyElementArray = tableElement.getUniqueKeys();
        if (uniqueKeyElementArray == null || uniqueKeyElementArray.length == 0) {
            return null;
        }
        uniqueKeyElement = uniqueKeyElementArray[0];
        for (int i = 1; i < uniqueKeyElementArray.length; ++i) {
            if (uniqueKeyElementArray[i].getColumns().length >= uniqueKeyElement.getColumns().length) continue;
            uniqueKeyElement = uniqueKeyElementArray[i];
        }
        return uniqueKeyElement;
    }

    private void generatePkField(ColumnElement columnElement, boolean bl, boolean bl2) {
        EntityMember entityMember = EntityMember.create(columnElement);
        entityMember.setPrimaryKey(bl, bl2);
        EntityClass entityClass = this.getBean(columnElement.getDeclaringTable().getName().getName());
        entityMember.setMemberName(DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass), entityMember.getMemberName(), null));
        entityClass.getFields().add(entityMember);
    }

    private void generateRelationship(ForeignKeyElement foreignKeyElement) {
        String string = foreignKeyElement.getDeclaringTable().getName().getName();
        String string2 = foreignKeyElement.getReferencedTable().getName().getName();
        boolean bl = DbSchemaEjbGenerator.isFkUnique(foreignKeyElement);
        EntityClass entityClass = this.getBean(string2);
        if (entityClass == null) {
            return;
        }
        EntityClass entityClass2 = this.getBean(string);
        if (entityClass2 == null) {
            return;
        }
        String string3 = EntityMember.makeRelationshipFieldName(entityClass2.getClassName(), !bl);
        string3 = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass), string3, null);
        RelationshipRole relationshipRole = new RelationshipRole(this.getRoleName(foreignKeyElement, entityClass.getClassName()), entityClass.getClassName(), string3, false, !bl, !this.isNullable(foreignKeyElement), this.isNullable(foreignKeyElement));
        entityClass.addRole(relationshipRole);
        String string4 = EntityMember.makeRelationshipFieldName(entityClass.getClassName(), false);
        if (!this.containsColumns(foreignKeyElement.getColumns(), DbSchemaEjbGenerator.getPrimaryOrCandidateKey(foreignKeyElement.getDeclaringTable()))) {
            string4 = EntityMember.makeRelationshipFieldName(relationshipRole.getRoleName(), false);
        }
        string4 = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(entityClass2), string4, null);
        RelationshipRole relationshipRole2 = new RelationshipRole(this.getRoleName(foreignKeyElement, entityClass2.getClassName()), entityClass2.getClassName(), string4, !bl, false, false, this.isNullable(foreignKeyElement));
        entityClass2.addRole(relationshipRole2);
        EntityRelation entityRelation = new EntityRelation(relationshipRole2, relationshipRole);
        entityRelation.setRelationName(relationshipRole2.getEntityName() + '-' + relationshipRole.getEntityName());
        this.relations.add(entityRelation);
        entityClass2.getCMPMapping().getCmrFieldMapping().put(string4, this.localColumnNames(foreignKeyElement));
        entityClass.getCMPMapping().getCmrFieldMapping().put(string3, this.referencedColumnNames(foreignKeyElement));
    }

    private void reset() {
        this.beans.clear();
        this.relations.clear();
    }

    private void buildCMPSet() {
        this.reset();
        this.addAllTables();
        Iterator iterator = this.beans.keySet().iterator();
        while (iterator.hasNext()) {
            int n;
            String string = iterator.next().toString();
            TableElement tableElement = this.schemaElement.getTable(DBIdentifier.create((String)string));
            ColumnElement[] columnElementArray = tableElement.getColumns();
            UniqueKeyElement uniqueKeyElement = DbSchemaEjbGenerator.getPrimaryOrCandidateKey(tableElement);
            ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
            for (n = 0; n < columnElementArray.length; ++n) {
                if (uniqueKeyElement != null && uniqueKeyElement.getColumn(columnElementArray[n].getName()) != null) {
                    this.generatePkField(columnElementArray[n], true, uniqueKeyElement.getColumns().length == 1);
                    continue;
                }
                if (this.isForeignKey(foreignKeyElementArray, columnElementArray[n])) continue;
                this.generatePkField(columnElementArray[n], false, false);
            }
            for (n = 0; foreignKeyElementArray != null && foreignKeyElementArray.length > n; ++n) {
                this.generateRelationship(foreignKeyElementArray[n]);
            }
            EntityClass entityClass = this.getBean(string);
            entityClass.usePkField(uniqueKeyElement != null && uniqueKeyElement.getColumns().length == 1);
            entityClass.setIsForTable(tableElement.isTable());
        }
        this.makeRelationsUnique();
    }

    private List getFieldNames(EntityClass entityClass) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EntityMember object : entityClass.getFields()) {
            arrayList.add(object.getMemberName());
        }
        for (RelationshipRole relationshipRole : entityClass.getRoles()) {
            arrayList.add(relationshipRole.getFieldName());
        }
        return arrayList;
    }

    private EntityRelation[] makeRelationsUnique() {
        EntityRelation[] entityRelationArray = this.getRelations();
        ArrayList arrayList = new ArrayList(entityRelationArray.length);
        for (int i = 0; i < entityRelationArray.length; ++i) {
            entityRelationArray[i].makeRoleNamesUnique();
            String string = entityRelationArray[i].getRelationName();
            entityRelationArray[i].setRelationName(DbSchemaEjbGenerator.uniqueAlgorithm(arrayList, string, "-"));
        }
        return entityRelationArray;
    }

    private static String uniqueAlgorithm(List list, String string, String string2) {
        String string3 = string;
        int n = 0;
        while (list.contains(string3)) {
            String string4 = string2 == null ? "" : string2;
            string3 = string + string4 + String.valueOf(++n);
        }
        list.add(string3);
        return string3;
    }
}

