/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.DOMHelper;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PersistenceHelper {
    private static final String PERSISTENCE_UNIT_TAG = "persistence-unit";
    private static final String PROPERTIES_TAG = "properties";
    private static final String NAME_ATTR = "name";
    private static final String EXCLUDE_UNLISTED_CLASSES_TAG = "exclude-unlisted-classes";
    private static final String TRANSACTION_TYPE_ATTR = "transaction-type";
    private static final String RESOURCE_LOCAL_VALUE = "RESOURCE_LOCAL";
    private static final String JTA_DATA_SOURCE_TAG = "jta-data-source";
    private static final String NON_JTA_DATA_SOURCE_TAG = "non-jta-data-source";

    public static PersistenceUnit getPersistenceUnit(Project project) {
        DOMHelper dOMHelper;
        Element element;
        FileObject fileObject = PersistenceHelper.getPersistenceXML(project);
        if (fileObject != null && (element = (dOMHelper = new DOMHelper(fileObject)).findElement(PERSISTENCE_UNIT_TAG)) != null) {
            String string = element.getAttribute(NAME_ATTR);
            Datasource datasource = null;
            NodeList nodeList = element.getElementsByTagName(JTA_DATA_SOURCE_TAG);
            if (nodeList.getLength() > 0) {
                Element element2 = (Element)nodeList.item(0);
                String string2 = dOMHelper.getValue(element2);
                datasource = RestUtils.getDatasource(project, string2);
            }
            return new PersistenceUnit(string, datasource);
        }
        return null;
    }

    public static void modifyPersistenceXml(Project project, boolean bl) throws IOException {
        FileObject fileObject = PersistenceHelper.getPersistenceXML(project);
        DOMHelper dOMHelper = new DOMHelper(fileObject);
        PersistenceHelper.unsetExcludeEnlistedClasses(dOMHelper);
        if (bl) {
            PersistenceHelper.switchToResourceLocalTransaction(dOMHelper);
        }
        dOMHelper.save();
    }

    public static void unsetExcludeEnlistedClasses(Project project) throws IOException {
        FileObject fileObject = PersistenceHelper.getPersistenceXML(project);
        PersistenceHelper.unsetExcludeEnlistedClasses(new DOMHelper(fileObject));
    }

    private static void unsetExcludeEnlistedClasses(DOMHelper dOMHelper) throws IOException {
        Element element = dOMHelper.findElement(PERSISTENCE_UNIT_TAG);
        NodeList nodeList = element.getElementsByTagName(EXCLUDE_UNLISTED_CLASSES_TAG);
        if (nodeList.getLength() > 0) {
            dOMHelper.setValue((Element)nodeList.item(0), "false");
        } else {
            element.insertBefore(dOMHelper.createElement(EXCLUDE_UNLISTED_CLASSES_TAG, "false"), dOMHelper.findElement(PROPERTIES_TAG));
        }
    }

    private static void switchToResourceLocalTransaction(DOMHelper dOMHelper) throws IOException {
        Element element = dOMHelper.findElement(PERSISTENCE_UNIT_TAG);
        element.setAttribute(TRANSACTION_TYPE_ATTR, RESOURCE_LOCAL_VALUE);
        NodeList nodeList = element.getElementsByTagName(JTA_DATA_SOURCE_TAG);
        String string = null;
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            string = dOMHelper.getValue(element2);
            Element element3 = dOMHelper.createElement(NON_JTA_DATA_SOURCE_TAG, string);
            element.replaceChild(element3, element2);
        }
    }

    public static Element getPropertiesElement(Document document) {
        NodeList nodeList = document.getElementsByTagName(PROPERTIES_TAG);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private static FileObject getPersistenceXML(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.getPersistenceXml();
        }
        return null;
    }

    public static class PersistenceUnit {
        private String name;
        private Datasource datasource;

        public PersistenceUnit(String string, Datasource datasource) {
            this.name = string;
            this.datasource = datasource;
        }

        public String getName() {
            return this.name;
        }

        public Datasource getDatasource() {
            return this.datasource;
        }
    }
}

