/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.StaticText;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.util.ConversionUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class StaticTextRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"onClick", "onDblClick", "onMouseUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver"};

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("span", component);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        StaticText st = (StaticText)component;
        this.addCoreAttributes(context, component, writer, null);
        StaticTextRenderer.addStringAttributes(context, component, writer, stringAttributes);
        if (st.getToolTip() != null) {
            writer.writeAttribute("title", (Object)st.getToolTip(), null);
        }
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        StaticText staticText = (StaticText)component;
        String currentValue = ConversionUtilities.convertValueToString(component, staticText.getText());
        String style = staticText.getStyle();
        String styleClass = staticText.getStyleClass();
        if (currentValue != null) {
            ArrayList<Object> parameterList = new ArrayList<Object>();
            Iterator kids = component.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (!(kid instanceof UIParameter)) continue;
                parameterList.add(((UIParameter)kid).getValue());
            }
            String message = null;
            message = parameterList.size() > 0 ? MessageFormat.format(currentValue, parameterList.toArray(new Object[parameterList.size()])) : currentValue;
            if (message != null) {
                if (staticText.isEscape()) {
                    writer.writeText((Object)message, "value");
                } else {
                    writer.write(message);
                }
            }
        }
        writer.endElement("span");
    }
}

