/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Message;
import com.sun.rave.web.ui.renderer.AbstractRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.FacesMessageUtils;
import com.sun.rave.web.ui.util.MessageUtil;
import com.sun.rave.web.ui.util.RenderingUtilities;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageRenderer
extends AbstractRenderer {
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Message message = (Message)component;
        String forComponentId = message.getFor();
        FacesMessage msg = null;
        Iterator msgIt = null;
        if (Beans.isDesignTime()) {
            String summary = null;
            if (forComponentId == null || forComponentId.length() == 0) {
                summary = MessageUtil.getMessage(context, "com.sun.rave.web.ui.renderer.Bundle", "Message.default.summary");
                this.renderMessage(context, component, writer, new FacesMessage(summary));
            } else {
                summary = MessageUtil.getMessage(context, "com.sun.rave.web.ui.renderer.Bundle", "Message.for.summary", (Object[])new String[]{forComponentId});
                String detail = MessageUtil.getMessage(context, "com.sun.rave.web.ui.renderer.Bundle", "Message.for.detail", (Object[])new String[]{forComponentId});
                this.renderMessage(context, component, writer, new FacesMessage(summary, detail));
            }
        } else if (forComponentId != null && (msgIt = FacesMessageUtils.getMessageIterator(context, forComponentId, (UIComponent)message)).hasNext()) {
            msg = (FacesMessage)msgIt.next();
            this.renderMessage(context, component, writer, msg);
        }
    }

    public void renderMessage(FacesContext context, UIComponent component, ResponseWriter writer, FacesMessage fMsg) throws IOException {
        Message message = (Message)component;
        String summary = null;
        String detail = null;
        if (message.isShowSummary() && (summary = fMsg.getSummary()) != null && summary.length() <= 0) {
            summary = null;
        }
        if (message.isShowDetail() && (detail = fMsg.getDetail()) != null && detail.length() <= 0) {
            detail = null;
        }
        if (summary == null && detail == null) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        boolean wroteSpanId = false;
        boolean wroteDivId = false;
        String style = message.getStyle();
        String styleClass = message.getStyleClass();
        if (summary != null || detail != null) {
            this.renderUserStyles(context, message, writer, style, styleClass);
            wroteDivId = true;
        }
        String severityStyleClass = null;
        if (fMsg.getSeverity() == FacesMessage.SEVERITY_INFO) {
            severityStyleClass = theme.getStyleClass("MsgInfo");
        } else if (fMsg.getSeverity() == FacesMessage.SEVERITY_WARN) {
            severityStyleClass = theme.getStyleClass("MsgWarn");
        } else if (fMsg.getSeverity() == FacesMessage.SEVERITY_ERROR) {
            severityStyleClass = theme.getStyleClass("MsgError");
        } else if (fMsg.getSeverity() == FacesMessage.SEVERITY_FATAL) {
            severityStyleClass = theme.getStyleClass("MsgFatal");
        }
        if (summary != null) {
            styleClass = severityStyleClass == null || severityStyleClass.length() == 0 || Beans.isDesignTime() ? theme.getStyleClass("MsgFldSumTxt") : severityStyleClass;
            this.renderMessageText(context, message, writer, summary, styleClass, wroteSpanId);
            wroteSpanId = true;
        }
        if (detail != null) {
            styleClass = severityStyleClass == null || severityStyleClass.length() == 0 || Beans.isDesignTime() ? theme.getStyleClass("MsgFldTxt") : severityStyleClass;
            if (summary != null) {
                detail = " " + detail;
            }
            this.renderMessageText(context, message, writer, detail, styleClass, wroteSpanId);
        }
        if (wroteSpanId) {
            writer.endElement("span");
        }
        if (wroteDivId) {
            writer.endElement("div");
        }
    }

    private void renderMessageText(FacesContext context, Message message, ResponseWriter writer, String msgText, String textStyleClass, boolean wroteOpeningSpanId) throws IOException {
        if (!wroteOpeningSpanId) {
            writer.startElement("span", (UIComponent)message);
            writer.writeAttribute("class", (Object)textStyleClass, "class");
        }
        writer.writeText((Object)msgText, null);
    }

    private void renderUserStyles(FacesContext context, Message message, ResponseWriter writer, String userStyle, String styleClass) throws IOException {
        String id = message.getClientId(context);
        writer.startElement("div", (UIComponent)message);
        writer.writeAttribute("id", (Object)id, "id");
        if (userStyle != null && userStyle.length() > 0) {
            writer.writeAttribute("style", (Object)userStyle, "style");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)message, styleClass);
    }
}

