/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.faces;

import com.sun.rave.web.ui.model.Option;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.faces.FacesException;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.model.SelectItem;
import javax.sql.RowSet;

public class ResultSetPropertyResolver
extends PropertyResolver {
    public static final String CURRENT_ROW_KEY = "currentRow";
    public static final String SELECT_ITEMS_KEY = "selectItems";
    public static final String OPTIONS_KEY = "options";
    protected PropertyResolver nested;

    public ResultSetPropertyResolver(PropertyResolver nested) {
        this.nested = nested;
    }

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        Object o;
        if (base instanceof ResultSet) {
            if (CURRENT_ROW_KEY.equals(property)) {
                return new RowData((ResultSet)base);
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                return new SelectItemsData((ResultSet)base);
            }
            if (OPTIONS_KEY.equals(property)) {
                return new OptionsData((ResultSet)base);
            }
        } else {
            if (base instanceof RowData) {
                return ((RowData)base).getData(property.toString());
            }
            if (base instanceof SelectItemsData) {
                return ((SelectItemsData)base).getSelectItems(property.toString());
            }
            if (base instanceof OptionsData) {
                return ((OptionsData)base).getOptions(property.toString());
            }
        }
        if ((o = this.nested.getValue(base, property)) instanceof ResultSet) {
            ResultSetPropertyResolver.initResultSet((ResultSet)o);
        }
        return o;
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        Object o = this.nested.getValue(base, index);
        if (o instanceof ResultSet) {
            ResultSetPropertyResolver.initResultSet((ResultSet)o);
        }
        return o;
    }

    public void setValue(Object base, Object property, Object value) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof RowData) {
            ((RowData)base).setData(property.toString(), value);
            return;
        }
        this.nested.setValue(base, property, value);
    }

    public void setValue(Object base, int index, Object value) throws EvaluationException, PropertyNotFoundException {
        this.nested.setValue(base, index, value);
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof ResultSet && (CURRENT_ROW_KEY.equals(property) || SELECT_ITEMS_KEY.equals(property) || OPTIONS_KEY.equals(property))) {
            return true;
        }
        if (base instanceof RowData) {
            return false;
        }
        if (base instanceof SelectItemsData) {
            return true;
        }
        if (base instanceof OptionsData) {
            return true;
        }
        return this.nested.isReadOnly(base, property);
    }

    public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        return this.nested.isReadOnly(base, index);
    }

    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof ResultSet) {
            if (CURRENT_ROW_KEY.equals(property)) {
                return RowData.class;
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                return SelectItemsData.class;
            }
            if (OPTIONS_KEY.equals(property)) {
                return OptionsData.class;
            }
        } else {
            if (base instanceof RowData) {
                return ((RowData)base).getDataType(property.toString());
            }
            if (base instanceof SelectItemsData) {
                return ArrayList.class;
            }
            if (base instanceof OptionsData) {
                return ArrayList.class;
            }
        }
        return this.nested.getType(base, property);
    }

    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        return this.nested.getType(base, index);
    }

    public static void initResultSet(ResultSet resultSet) {
        block7: {
            try {
                if (resultSet.isBeforeFirst()) {
                    try {
                        resultSet.first();
                    }
                    catch (SQLException x) {}
                }
            }
            catch (SQLException x) {
                if (!(resultSet instanceof RowSet)) break block7;
                try {
                    ((RowSet)resultSet).execute();
                    resultSet.first();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public class OptionsData {
        protected ResultSet resultSet;
        protected ResultSetMetaData metadata;

        public OptionsData(ResultSet resultSet) {
            this.resultSet = resultSet;
            try {
                this.metadata = resultSet.getMetaData();
            }
            catch (SQLException x) {
                throw new FacesException((Throwable)x);
            }
        }

        public Object getOptions(String columns) {
            String[] args;
            String col;
            String itemValueName = null;
            String itemLabelName = null;
            String itemDescriptionName = null;
            ArrayList<String> cols = new ArrayList<String>();
            boolean quoteOpen = false;
            int currStart = 0;
            for (int i = 0; i < columns.length(); ++i) {
                char c = columns.charAt(i);
                if (c == '\'') {
                    quoteOpen = !quoteOpen;
                    continue;
                }
                if (c != ',' || quoteOpen) continue;
                col = columns.substring(currStart, i);
                if (col.length() > 0) {
                    cols.add(col);
                }
                currStart = i + 1;
            }
            if (currStart < columns.length()) {
                col = columns.substring(currStart);
                cols.add(col);
            }
            if ((args = cols.toArray(new String[cols.size()])).length < 1) {
                throw new IllegalArgumentException();
            }
            itemValueName = args[0];
            if (args.length > 1) {
                itemLabelName = args[1];
            }
            if (args.length > 2) {
                itemDescriptionName = args[2];
            }
            ArrayList<Option> list = new ArrayList<Option>();
            try {
                ResultSetPropertyResolver.initResultSet(this.resultSet);
                int resultSetIndexSave = this.resultSet.getRow();
                this.resultSet.first();
                while (!this.resultSet.isAfterLast()) {
                    if (itemLabelName == null) {
                        list.add(new Option(this.resultSet.getObject(itemValueName)));
                    } else if (itemDescriptionName == null) {
                        list.add(new Option(this.resultSet.getObject(itemValueName), this.resultSet.getObject(itemLabelName).toString()));
                    } else {
                        list.add(new Option(this.resultSet.getObject(itemValueName), this.resultSet.getObject(itemLabelName).toString(), this.resultSet.getObject(itemDescriptionName).toString()));
                    }
                    this.resultSet.next();
                }
                if (resultSetIndexSave > 0) {
                    this.resultSet.absolute(resultSetIndexSave);
                } else {
                    this.resultSet.first();
                }
            }
            catch (SQLException x) {
                x.printStackTrace();
            }
            return list;
        }
    }

    public class SelectItemsData {
        protected ResultSet resultSet;
        protected ResultSetMetaData metadata;

        public SelectItemsData(ResultSet resultSet) {
            this.resultSet = resultSet;
            try {
                this.metadata = resultSet.getMetaData();
            }
            catch (SQLException x) {
                throw new FacesException((Throwable)x);
            }
        }

        public Object getSelectItems(String columns) {
            String[] args;
            String col;
            String itemValueName = null;
            String itemLabelName = null;
            String itemDescriptionName = null;
            ArrayList<String> cols = new ArrayList<String>();
            boolean quoteOpen = false;
            int currStart = 0;
            for (int i = 0; i < columns.length(); ++i) {
                char c = columns.charAt(i);
                if (c == '\'') {
                    quoteOpen = !quoteOpen;
                    continue;
                }
                if (c != ',' || quoteOpen) continue;
                col = columns.substring(currStart, i);
                if (col.length() > 0) {
                    cols.add(col);
                }
                currStart = i + 1;
            }
            if (currStart < columns.length()) {
                col = columns.substring(currStart);
                cols.add(col);
            }
            if ((args = cols.toArray(new String[cols.size()])).length < 1) {
                throw new IllegalArgumentException();
            }
            itemValueName = args[0];
            if (args.length > 1) {
                itemLabelName = args[1];
            }
            if (args.length > 2) {
                itemDescriptionName = args[2];
            }
            ArrayList<SelectItem> list = new ArrayList<SelectItem>();
            try {
                ResultSetPropertyResolver.initResultSet(this.resultSet);
                int resultSetIndexSave = this.resultSet.getRow();
                this.resultSet.first();
                while (!this.resultSet.isAfterLast()) {
                    if (itemLabelName == null) {
                        list.add(new SelectItem(this.resultSet.getObject(itemValueName)));
                    } else if (itemDescriptionName == null) {
                        list.add(new SelectItem(this.resultSet.getObject(itemValueName), this.resultSet.getObject(itemLabelName).toString()));
                    } else {
                        list.add(new SelectItem(this.resultSet.getObject(itemValueName), this.resultSet.getObject(itemLabelName).toString(), this.resultSet.getObject(itemDescriptionName).toString()));
                    }
                    this.resultSet.next();
                }
                if (resultSetIndexSave > 0) {
                    this.resultSet.absolute(resultSetIndexSave);
                } else {
                    this.resultSet.first();
                }
            }
            catch (SQLException x) {
                x.printStackTrace();
            }
            return list;
        }
    }

    public class RowData {
        protected ResultSet resultSet;
        protected ResultSetMetaData metadata;
        protected ArrayList columnNameList;

        public RowData(ResultSet resultSet) {
            this.resultSet = resultSet;
            try {
                this.metadata = resultSet.getMetaData();
                this.columnNameList = new ArrayList();
                int cols = this.metadata.getColumnCount();
                for (int i = 1; i <= cols; ++i) {
                    this.columnNameList.add(this.metadata.getColumnName(i));
                }
            }
            catch (SQLException x) {
                throw new FacesException((Throwable)x);
            }
        }

        public Class getDataType(String column) throws PropertyNotFoundException {
            if (!this.columnNameList.contains(column)) {
                throw new PropertyNotFoundException("Invalid column name: " + column);
            }
            try {
                return Class.forName(this.metadata.getColumnClassName(this.columnNameList.indexOf(column) + 1));
            }
            catch (Exception x) {
                return null;
            }
        }

        public Object getData(String column) throws PropertyNotFoundException {
            if (!this.columnNameList.contains(column)) {
                throw new PropertyNotFoundException("Invalid column name: " + column);
            }
            try {
                ResultSetPropertyResolver.initResultSet(this.resultSet);
                return this.resultSet.getObject(column);
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }

        public Object setData(String column, Object value) throws PropertyNotFoundException {
            if (!this.columnNameList.contains(column)) {
                throw new PropertyNotFoundException("Invalid column name: " + column);
            }
            try {
                ResultSetPropertyResolver.initResultSet(this.resultSet);
                Object previous = this.resultSet.getObject(column);
                if (previous == null && value == null) {
                    return previous;
                }
                if (previous != null && value != null && previous.equals(value)) {
                    return previous;
                }
                this.resultSet.updateObject(column, value);
                return previous;
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }
}

