/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.Table;
import com.sun.rave.web.ui.component.TableColumn;
import com.sun.rave.web.ui.component.TableFooterBase;
import com.sun.rave.web.ui.component.TableRowGroup;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.LogUtil;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.context.FacesContext;

public class TableFooter
extends TableFooterBase
implements NamingContainer {
    private Table table = null;
    private TableColumn tableColumn = null;
    private TableRowGroup tableRowGroup = null;
    private int sortLevel = -1;

    public int getSortLevel() {
        if (this.sortLevel == -1) {
            TableColumn col = this.getTableColumnAncestor();
            TableRowGroup group = this.getTableRowGroupAncestor();
            if (col != null && group != null) {
                this.sortLevel = group.getSortLevel(col.getSortCriteria());
            } else {
                this.log("getSortLevel", "Cannot obtain sort level, TableColumn or TableRowGroup is null");
            }
        }
        return this.sortLevel;
    }

    public Table getTableAncestor() {
        if (this.table == null) {
            TableFooter component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.table = (Table)((Object)component);
                break;
            }
        }
        return this.table;
    }

    public TableColumn getTableColumnAncestor() {
        if (this.tableColumn == null) {
            TableFooter component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableColumn)) continue;
                this.tableColumn = (TableColumn)((Object)component);
                break;
            }
        }
        return this.tableColumn;
    }

    public TableRowGroup getTableRowGroupAncestor() {
        if (this.tableRowGroup == null) {
            TableFooter component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof TableRowGroup)) continue;
                this.tableRowGroup = (TableRowGroup)((Object)component);
                break;
            }
        }
        return this.tableRowGroup;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.table = null;
        this.tableColumn = null;
        this.tableRowGroup = null;
        this.sortLevel = -1;
        super.encodeBegin(context);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

