/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JEditorPane;
import org.netbeans.lib.editor.bookmarks.actions.ClearDocumentBookmarksAction;
import org.netbeans.lib.editor.bookmarks.actions.GotoBookmarkAction;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class WrapperBookmarkAction
extends NodeAction {
    static final long serialVersionUID = 0L;
    private Action originalAction;

    public WrapperBookmarkAction(Action action) {
        this.originalAction = action;
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        String string = (String)this.originalAction.getValue("ShortDescription");
        assert (string != null);
        return string;
    }

    public void performAction(Node[] nodeArray) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie;
        if (nodeArray != null && nodeArray.length == 1 && (editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class)) != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            JEditorPane jEditorPane = jEditorPaneArray[0];
            ActionEvent actionEvent = new ActionEvent(jEditorPane, 0, "");
            this.originalAction.actionPerformed(actionEvent);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        EditorCookie editorCookie;
        if (nodeArray != null && nodeArray.length == 1 && (editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class)) != null) {
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            return jEditorPaneArray != null && jEditorPaneArray.length > 0;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return (String)this.originalAction.getValue("IconResource");
    }

    public static final class ClearDocumentBookmarks
    extends WrapperBookmarkAction {
        public ClearDocumentBookmarks() {
            super((Action)((Object)new ClearDocumentBookmarksAction()));
        }
    }

    public static final class Previous
    extends WrapperBookmarkAction {
        public Previous() {
            super((Action)((Object)GotoBookmarkAction.createPrevious()));
        }
    }

    public static final class Next
    extends WrapperBookmarkAction {
        public Next() {
            super((Action)((Object)GotoBookmarkAction.createNext()));
        }
    }
}

