/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeDecoder
implements Iterator<byte[]>,
Iterable<byte[]> {
    static final int[] opcodeLengths = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 99, 99, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 0, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5, 1, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 5, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private byte[] code;
    int currentIndex;

    public BytecodeDecoder(byte[] byArray) {
        this.code = byArray;
        this.currentIndex = 0;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIndex < this.code.length) {
            return true;
        }
        if (this.currentIndex != this.code.length) {
            throw new IllegalStateException("Bad end " + this.currentIndex + " vs. " + this.code.length);
        }
        return false;
    }

    @Override
    public byte[] next() {
        int n;
        int n2;
        int n3;
        int n4 = BytecodeDecoder.toInt(this.code[this.currentIndex]);
        if (n4 == 196) {
            n3 = BytecodeDecoder.toInt(this.code[this.currentIndex + 1]);
            switch (n3) {
                case 132: {
                    n2 = 6;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: {
                    n2 = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad wide instruction at index " + this.currentIndex + " wide instruction " + n3);
                }
            }
        } else {
            n2 = opcodeLengths[n4];
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("Bad bytecode at index " + this.currentIndex + " opcode " + n4);
        }
        if (n2 == 99) {
            switch (n4) {
                case 171: {
                    n3 = 4 - this.currentIndex % 4;
                    n = this.currentIndex + n3 + 4;
                    int n5 = BytecodeDecoder.toInt(this.code[n], this.code[n + 1], this.code[n + 2], this.code[n + 3]);
                    n2 = n3 + 8 + n5 * 8;
                    break;
                }
                case 170: {
                    n3 = 4 - this.currentIndex % 4;
                    n = this.currentIndex + n3 + 4;
                    int n5 = BytecodeDecoder.toInt(this.code[n], this.code[n + 1], this.code[n + 2], this.code[n + 3]);
                    int n6 = BytecodeDecoder.toInt(this.code[n + 4], this.code[n + 5], this.code[n + 6], this.code[n + 7]);
                    n2 = n3 + 12 + (n6 - n5 + 1) * 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad bytecode at index " + this.currentIndex);
                }
            }
        }
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray[n] = this.code[this.currentIndex + n];
        }
        this.currentIndex += n2;
        return byArray;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Byte code is read only");
    }

    static int toInt(byte by) {
        return by & 0xFF;
    }

    static int toInt(byte by, byte by2) {
        return BytecodeDecoder.toInt(by) << 8 | BytecodeDecoder.toInt(by2);
    }

    static int toInt(byte by, byte by2, byte by3, byte by4) {
        return BytecodeDecoder.toInt(by) << 24 | BytecodeDecoder.toInt(by2) << 16 | BytecodeDecoder.toInt(by3) << 8 | BytecodeDecoder.toInt(by4);
    }
}

