/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.pretty.CharBuffer;
import org.netbeans.modules.java.source.pretty.DanglingElseChecker;
import org.netbeans.modules.java.source.pretty.WidthEstimator;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.PositionEstimator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VeryPretty
extends JCTree.Visitor {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    private static final String REPLACEMENT = "%[a-z]*%";
    private static final String ERROR = "<error>";
    private final CodeStyle cs;
    private final CharBuffer out;
    private final Name.Table names;
    private final CommentHandler commentHandler;
    private final Symtab symbols;
    private final Types types;
    private final TreeInfo treeinfo;
    private final WidthEstimator widthEstimator;
    private final DanglingElseChecker danglingElseChecker;
    public Name enclClassName;
    private int indentSize;
    private int prec;
    private LinkedList<Comment> pendingComments = null;
    private int lastReadCommentIdx = -1;
    private JCTree.JCCompilationUnit origUnit;
    private CompilationInfo cInfo;
    private int fromOffset = -1;
    private int toOffset = -1;
    private boolean containsError = false;
    private final Map<Tree, ?> tree2Tag;
    private final Map<Object, int[]> tag2Span;
    private int initialOffset = 0;

    public VeryPretty(CompilationInfo compilationInfo) {
        this(compilationInfo, CodeStyle.getDefault(null), null, null);
    }

    public VeryPretty(CompilationInfo compilationInfo, CodeStyle codeStyle) {
        this(compilationInfo, codeStyle, null, null);
    }

    public VeryPretty(Context context, CodeStyle codeStyle) {
        this(context, codeStyle, null, null);
    }

    public VeryPretty(CompilationInfo compilationInfo, CodeStyle codeStyle, Map<Tree, ?> map, Map<?, int[]> map2) {
        this(JavaSourceAccessor.getINSTANCE().getJavacTask(compilationInfo).getContext(), codeStyle, map, map2);
        this.cInfo = compilationInfo;
        this.origUnit = (JCTree.JCCompilationUnit)compilationInfo.getCompilationUnit();
    }

    public VeryPretty(CompilationInfo compilationInfo, CodeStyle codeStyle, Map<Tree, ?> map, Map<?, int[]> map2, int n) {
        this(compilationInfo, codeStyle, map, map2);
        this.initialOffset = n;
    }

    public VeryPretty(Context context) {
        this(context, CodeStyle.getDefault(null), null, null);
    }

    public VeryPretty(Context context, CodeStyle codeStyle, Map<Tree, ?> map, Map<?, int[]> map2) {
        this.names = Name.Table.instance((Context)context);
        this.enclClassName = this.names.empty;
        this.commentHandler = CommentHandlerService.instance(context);
        this.symbols = Symtab.instance(context);
        this.types = Types.instance(context);
        this.treeinfo = TreeInfo.instance((Context)context);
        this.widthEstimator = new WidthEstimator(context);
        this.danglingElseChecker = new DanglingElseChecker();
        this.prec = -1;
        this.cs = codeStyle;
        this.out = new CharBuffer(codeStyle.getRightMargin(), codeStyle.getTabSize(), codeStyle.expandTabToSpaces());
        this.indentSize = codeStyle.getIndentSize();
        this.tree2Tag = map;
        this.tag2Span = map2;
    }

    public void setInitialOffset(int n) {
        this.initialOffset = n < 0 ? 0 : n;
    }

    public int getInitialOffset() {
        return this.initialOffset;
    }

    public String toString() {
        return this.out.toString();
    }

    public void toLeftMargin() {
        this.out.toLeftMargin();
    }

    public void reset(int n) {
        this.out.setLength(0);
        this.out.leftMargin = n;
    }

    public int indent() {
        int n = this.out.leftMargin;
        this.out.leftMargin = n + this.indentSize;
        return n;
    }

    public void undent(int n) {
        this.out.leftMargin = n;
    }

    public void newline() {
        this.out.nlTerm();
    }

    public void blankline() {
        this.out.blanklines(1);
    }

    public int setPrec(int n) {
        int n2 = this.prec;
        this.prec = n;
        return n2;
    }

    public final void print(String string) {
        if (string == null) {
            return;
        }
        this.out.append(string);
    }

    public final void print(Name name) {
        this.out.appendUtf8((byte[])name.table.names, name.index, name.len);
    }

    public void print(JCTree jCTree) {
        if (jCTree == null) {
            return;
        }
        this.blankLines(jCTree, true);
        this.toLeftMargin();
        this.printPrecedingComments(jCTree, true);
        this.doAccept(jCTree);
        this.printTrailingComments(jCTree, true);
        this.blankLines(jCTree, false);
    }

    private void doAccept(JCTree jCTree) {
        Object k;
        int n = this.toString().length();
        jCTree.accept(this);
        int n2 = this.toString().length();
        Object k2 = k = this.tree2Tag != null ? (Object)this.tree2Tag.get(jCTree) : null;
        if (k != null) {
            this.tag2Span.put(k, new int[]{n + this.initialOffset, n2 + this.initialOffset});
        }
    }

    public String reformat(JCTree jCTree, int n, int n2, int n3) {
        this.reset(n3);
        this.fromOffset = n;
        this.toOffset = n2;
        this.print(jCTree);
        return this.containsError ? null : this.out.toString();
    }

    public void printPackage(JCTree.JCExpression jCExpression) {
        if (jCExpression != null) {
            this.blankLines(this.cs.getBlankLinesBeforePackage());
            this.print("package ");
            this.printExpr(jCExpression);
            this.print(';');
            this.blankLines(this.cs.getBlankLinesAfterPackage());
        }
    }

    public String getMethodHeader(MethodTree methodTree, String string) {
        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)methodTree;
        this.printAnnotations(jCMethodDecl.mods.annotations);
        string = this.replace(string, "%annotations");
        this.printFlags(jCMethodDecl.mods.flags);
        string = this.replace(string, "%flags%");
        if (jCMethodDecl.name == this.names.init) {
            this.print(this.enclClassName);
            string = this.replace(string, "%name%");
        } else {
            if (jCMethodDecl.typarams != null) {
                this.printTypeParameters(jCMethodDecl.typarams);
                this.needSpace();
                string = this.replace(string, "%typeparameters%");
            }
            this.print(jCMethodDecl.restype);
            string = this.replace(string, "%type%");
            this.out.clear();
            this.print(jCMethodDecl.name);
            string = this.replace(string, "%name%");
        }
        this.print('(');
        this.wrapTrees(jCMethodDecl.params, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
        this.print(')');
        string = this.replace(string, "%parameters%");
        if (jCMethodDecl.thrown.nonEmpty()) {
            this.print(" throws ");
            this.wrapTrees(jCMethodDecl.thrown, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
            string = this.replace(string, "%throws%");
        }
        return string.replaceAll(REPLACEMENT, "");
    }

    public String getClassHeader(ClassTree classTree, String string) {
        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)classTree;
        this.printAnnotations(jCClassDecl.mods.annotations);
        string = this.replace(string, "%annotations");
        long l = jCClassDecl.mods.flags;
        if ((l & 0x4000L) != 0L) {
            this.printFlags(l & 0xFFFFFFFFFFFFFDEFL);
        } else {
            this.printFlags(l & 0xFFFFFFFFFFFFF9FFL);
        }
        string = this.replace(string, "%flags%");
        if ((l & 0x200L) != 0L) {
            this.print("interface ");
            this.print(jCClassDecl.name);
            string = this.replace(string, "%name%");
            this.printTypeParameters(jCClassDecl.typarams);
            string = this.replace(string, "%typeparameters%");
            if (jCClassDecl.implementing.nonEmpty()) {
                this.print(" extends ");
                this.wrapTrees(jCClassDecl.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                string = this.replace(string, "%extends%");
            }
        } else {
            if ((l & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((l & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(jCClassDecl.name);
            string = this.replace(string, "%name%");
            this.printTypeParameters(jCClassDecl.typarams);
            string = this.replace(string, "%typeparameters%");
            if (jCClassDecl.extending != null) {
                this.print(" extends ");
                this.print(jCClassDecl.extending);
                string = this.replace(string, "%extends%");
            }
            if (jCClassDecl.implementing.nonEmpty()) {
                this.print(" implements ");
                this.wrapTrees(jCClassDecl.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                string = this.replace(string, "%implements%");
            }
        }
        return string.replaceAll(REPLACEMENT, "");
    }

    public String getVariableHeader(VariableTree variableTree, String string) {
        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)variableTree;
        this.printAnnotations(jCVariableDecl.mods.annotations);
        string = this.replace(string, "%annotations");
        this.printFlags(jCVariableDecl.mods.flags);
        string = this.replace(string, "%flags%");
        this.print(jCVariableDecl.vartype);
        string = this.replace(string, "%type%");
        this.needSpace();
        this.print(jCVariableDecl.name);
        string = this.replace(string, "%name%");
        return string.replaceAll(REPLACEMENT, "");
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        this.printPackage(jCCompilationUnit.pid);
        List<JCTree> list = jCCompilationUnit.defs;
        ArrayList<JCTree.JCImport> arrayList = new ArrayList<JCTree.JCImport>();
        while (list.nonEmpty() && ((JCTree)list.head).getTag() == 2) {
            arrayList.add((JCTree.JCImport)list.head);
            list = list.tail;
        }
        this.printImportsBlock(arrayList);
        while (list.nonEmpty()) {
            this.printStat((JCTree)list.head, true, false);
            this.newline();
            list = list.tail;
        }
    }

    @Override
    public void visitImport(JCTree.JCImport jCImport) {
        this.print("import ");
        if (jCImport.staticImport) {
            this.print("static ");
        }
        this.print(this.fullName(jCImport.qualid));
        this.print(';');
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        int n;
        int n2;
        Name name;
        block41: {
            block38: {
                Object object;
                name = this.enclClassName;
                this.enclClassName = jCClassDecl.name;
                this.toLeftMargin();
                this.printAnnotations(jCClassDecl.mods.annotations);
                long l = jCClassDecl.mods.flags;
                if ((l & 0x4000L) != 0L) {
                    this.printFlags(l & 0xFFFFFFFFFFFFFDEFL);
                } else {
                    this.printFlags(l & 0xFFFFFFFFFFFFF9FFL);
                }
                if ((l & 0x200L) != 0L || (l & 0x2000L) != 0L) {
                    if ((l & 0x2000L) != 0L) {
                        this.print('@');
                    }
                    this.print("interface ");
                    this.print(jCClassDecl.name);
                    this.printTypeParameters(jCClassDecl.typarams);
                    if (jCClassDecl.implementing.nonEmpty()) {
                        this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                        this.wrapTrees(jCClassDecl.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                } else {
                    if ((l & 0x4000L) != 0L) {
                        this.print("enum ");
                    } else {
                        if ((l & 0x400L) != 0L) {
                            this.print("abstract ");
                        }
                        this.print("class ");
                    }
                    this.print(jCClassDecl.name);
                    this.printTypeParameters(jCClassDecl.typarams);
                    if (jCClassDecl.extending != null) {
                        this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                        this.print(jCClassDecl.extending);
                    }
                    if (jCClassDecl.implementing.nonEmpty()) {
                        this.wrap("implements ", this.cs.wrapExtendsImplementsKeyword());
                        this.wrapTrees(jCClassDecl.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                }
                n = n2 = this.cs.indentTopLevelClassMembers() ? this.indent() : this.out.leftMargin;
                switch (this.cs.getClassDeclBracePlacement()) {
                    case NEW_LINE: {
                        this.newline();
                        this.toColExactly(n2);
                        break;
                    }
                    case NEW_LINE_HALF_INDENTED: {
                        this.newline();
                        this.toColExactly(n += this.indentSize >> 1);
                        break;
                    }
                    case NEW_LINE_INDENTED: {
                        this.newline();
                        n = this.out.leftMargin;
                        this.toColExactly(n);
                    }
                }
                if (this.cs.spaceBeforeClassDeclLeftBrace()) {
                    this.needSpace();
                }
                this.print('{');
                boolean bl = true;
                List<JCTree> list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (!this.isSynthetic((JCTree)list.head)) {
                        bl = false;
                        break;
                    }
                    list = list.tail;
                }
                if (bl) break block38;
                this.blankLines(this.cs.getBlankLinesAfterClassHeader());
                if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
                    boolean bl2 = true;
                    boolean bl3 = false;
                    object = jCClassDecl.defs;
                    while (((List)object).nonEmpty()) {
                        if (VeryPretty.isEnumerator((JCTree)((List)object).head)) {
                            if (bl2) {
                                this.toColExactly(this.out.leftMargin);
                                bl2 = false;
                            } else {
                                this.print(this.cs.spaceBeforeComma() ? " ," : ",");
                                switch (this.cs.wrapEnumConstants()) {
                                    case WRAP_IF_LONG: {
                                        int n3 = this.cs.getRightMargin();
                                        if (this.widthEstimator.estimateWidth((JCTree)((List)object).head, n3 - this.out.col) + this.out.col + 1 <= n3) {
                                            if (!this.cs.spaceAfterComma()) break;
                                            this.print(' ');
                                            break;
                                        }
                                    }
                                    case WRAP_ALWAYS: {
                                        this.toColExactly(this.out.leftMargin);
                                        break;
                                    }
                                    case WRAP_NEVER: {
                                        if (!this.cs.spaceAfterComma()) break;
                                        this.print(' ');
                                    }
                                }
                            }
                            this.printStat((JCTree)((List)object).head, true, false);
                        } else if (!this.isSynthetic((JCTree)((List)object).head)) {
                            bl3 = true;
                        }
                        object = ((List)object).tail;
                    }
                    if (bl3) {
                        this.print(";");
                        this.newline();
                    }
                }
                boolean bl4 = true;
                List<JCTree> list2 = jCClassDecl.defs;
                while (list2.nonEmpty()) {
                    block40: {
                        block39: {
                            object = (JCTree)list2.head;
                            if (VeryPretty.isEnumerator((JCTree)object)) break block39;
                            if (this.isSynthetic((JCTree)object)) break block40;
                            this.toColExactly(this.out.leftMargin);
                            this.printStat((JCTree)object, true, bl4);
                            this.newline();
                        }
                        bl4 = false;
                    }
                    list2 = list2.tail;
                }
                break block41;
            }
            this.printEmptyBlockComments(jCClassDecl, false);
        }
        this.toColExactly(n);
        this.undent(n2);
        this.print('}');
        this.enclClassName = name;
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        if ((jCMethodDecl.mods.flags & 0x1000L) == 0L && jCMethodDecl.name != this.names.init || this.enclClassName != null) {
            Name name = this.enclClassName;
            this.enclClassName = null;
            this.printAnnotations(jCMethodDecl.mods.annotations);
            this.printFlags(jCMethodDecl.mods.flags);
            if (jCMethodDecl.name == this.names.init || jCMethodDecl.name.contentEquals(name)) {
                this.print(name);
            } else {
                if (jCMethodDecl.typarams != null) {
                    this.printTypeParameters(jCMethodDecl.typarams);
                    this.needSpace();
                }
                this.print(jCMethodDecl.restype);
                this.needSpace();
                this.print(jCMethodDecl.name);
            }
            this.print(this.cs.spaceBeforeMethodDeclParen() ? " (" : "(");
            if (this.cs.spaceWithinMethodDeclParens() && jCMethodDecl.params.nonEmpty()) {
                this.print(' ');
            }
            this.wrapTrees(jCMethodDecl.params, this.cs.wrapMethodParams(), this.cs.alignMultilineMethodParams() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            if (this.cs.spaceWithinMethodDeclParens() && jCMethodDecl.params.nonEmpty()) {
                this.needSpace();
            }
            this.print(')');
            if (jCMethodDecl.thrown.nonEmpty()) {
                this.wrap("throws ", this.cs.wrapThrowsKeyword());
                this.wrapTrees(jCMethodDecl.thrown, this.cs.wrapThrowsList(), this.cs.alignMultilineThrows() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            }
            if (jCMethodDecl.body != null) {
                this.printBlock(jCMethodDecl.body, jCMethodDecl.body.stats, this.cs.getMethodDeclBracePlacement(), this.cs.spaceBeforeMethodDeclLeftBrace());
            } else {
                this.print(';');
            }
            this.enclClassName = name;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        boolean bl = (jCVariableDecl.mods.flags & 0x4000L) == 0L;
        this.printAnnotations(jCVariableDecl.mods.annotations);
        if (bl) {
            this.printFlags(jCVariableDecl.mods.flags);
            if ((jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
                if (Tree.Kind.ARRAY_TYPE == jCVariableDecl.vartype.getKind()) {
                    this.printExpr(((JCTree.JCArrayTypeTree)jCVariableDecl.vartype).elemtype);
                } else {
                    this.printExpr(jCVariableDecl.vartype);
                }
                this.print("...");
            } else {
                this.print(jCVariableDecl.vartype);
            }
        }
        this.needSpace();
        if (!ERROR.contentEquals(jCVariableDecl.name)) {
            this.print(jCVariableDecl.name);
        }
        if (jCVariableDecl.init != null) {
            if (bl) {
                this.printVarInit(jCVariableDecl);
            } else {
                JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)jCVariableDecl.init;
                if (jCNewClass.args.nonEmpty()) {
                    this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
                    if (this.cs.spaceWithinMethodCallParens()) {
                        this.print(' ');
                    }
                    this.wrapTrees(jCNewClass.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    this.print(this.cs.spaceWithinMethodCallParens() ? " )" : ")");
                }
                if (jCNewClass.def != null) {
                    Name name = this.enclClassName;
                    this.enclClassName = jCNewClass.def.name;
                    this.printBlock(null, jCNewClass.def.defs, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeClassDeclLeftBrace());
                    this.enclClassName = name;
                }
            }
        }
        if (this.prec == -1 && bl) {
            this.print(';');
        }
    }

    public void printVarInit(JCTree.JCVariableDecl jCVariableDecl) {
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print('=');
        int n = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(jCVariableDecl.init, n - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundAssignOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundAssignOps()) break;
                this.print(' ');
            }
        }
        this.printNoParenExpr(jCVariableDecl.init);
    }

    @Override
    public void visitSkip(JCTree.JCSkip jCSkip) {
        this.print(';');
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        this.printFlags(jCBlock.flags, false);
        this.printBlock(jCBlock, jCBlock.stats, this.cs.getOtherBracePlacement(), (jCBlock.flags & 8L) != 0L ? this.cs.spaceBeforeStaticInitLeftBrace() : false);
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        boolean bl;
        this.print("do");
        if (this.cs.spaceBeforeDoLeftBrace()) {
            this.print(' ');
        }
        this.printIndentedStat(jCDoWhileLoop.body, this.cs.redundantDoWhileBraces(), this.cs.spaceBeforeDoLeftBrace(), this.cs.wrapDoWhileStatement());
        boolean bl2 = bl = jCDoWhileLoop.body.getKind() == Tree.Kind.BLOCK || this.cs.redundantDoWhileBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (this.cs.placeWhileOnNewLine() || !bl) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeWhile()) {
            this.needSpace();
        }
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(jCDoWhileLoop.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " );" : ");");
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(jCWhileLoop.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " )" : ")");
        this.printIndentedStat(jCWhileLoop.body, this.cs.redundantWhileBraces(), this.cs.spaceBeforeWhileLeftBrace(), this.cs.wrapWhileStatement());
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        List list;
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        int n = this.out.col;
        if (jCForLoop.init.nonEmpty()) {
            if (((JCTree.JCStatement)jCForLoop.init.head).getTag() == 5) {
                this.printNoParenExpr((JCTree)jCForLoop.init.head);
                list = jCForLoop.init.tail;
                while (list.nonEmpty()) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.print(", " + jCVariableDecl.name + " = ");
                    this.printNoParenExpr(jCVariableDecl.init);
                    list = list.tail;
                }
            } else {
                this.printExprs(jCForLoop.init);
            }
        }
        list = this.cs.spaceBeforeSemi() ? " ;" : ";";
        this.print((String)((Object)list));
        if (jCForLoop.cond != null) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int n2 = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(jCForLoop.cond, n2 - this.out.col) + this.out.col + 1 <= n2) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.toColExactly(this.cs.alignMultilineFor() ? n : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printNoParenExpr(jCForLoop.cond);
        }
        this.print((String)((Object)list));
        if (jCForLoop.step.nonEmpty()) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int n3 = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(jCForLoop.step, n3 - this.out.col) + this.out.col + 1 <= n3) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.toColExactly(this.cs.alignMultilineFor() ? n : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printExprs(jCForLoop.step);
        }
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(jCForLoop.body, this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        this.toColExactly(this.cs.absoluteLabelIndent() ? 0 : this.out.leftMargin);
        this.print(jCLabeledStatement.label);
        this.print(':');
        int n = this.out.leftMargin;
        this.out.leftMargin += this.cs.getLabelIndent();
        this.toColExactly(this.out.leftMargin);
        this.printStat(jCLabeledStatement.body);
        this.undent(n);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        this.print("switch");
        this.print(this.cs.spaceBeforeSwitchParen() ? " (" : "(");
        if (this.cs.spaceWithinSwitchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(jCSwitch.selector);
        this.print(this.cs.spaceWithinSwitchParens() ? " )" : ")");
        int n = this.out.leftMargin;
        switch (this.cs.getOtherBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(n);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(n += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                this.toColExactly(n += this.indentSize);
            }
        }
        if (this.cs.spaceBeforeSwitchLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        if (jCSwitch.cases.nonEmpty()) {
            this.newline();
            this.printStats(jCSwitch.cases);
            this.toColExactly(n);
        }
        this.print('}');
    }

    @Override
    public void visitCase(JCTree.JCCase jCCase) {
        int n = this.cs.indentCasesFromSwitch() ? this.indent() : this.out.leftMargin;
        this.toLeftMargin();
        if (jCCase.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printNoParenExpr(jCCase.pat);
        }
        this.print(':');
        this.newline();
        this.indent();
        this.printStats(jCCase.stats);
        this.undent(n);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        this.print("synchronized");
        this.print(this.cs.spaceBeforeSynchronizedParen() ? " (" : "(");
        if (this.cs.spaceWithinSynchronizedParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(jCSynchronized.lock);
        this.print(this.cs.spaceWithinSynchronizedParens() ? " )" : ")");
        this.printBlock((JCTree)jCSynchronized.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeSynchronizedLeftBrace());
    }

    @Override
    public void visitTry(JCTree.JCTry jCTry) {
        this.print("try");
        this.printBlock((JCTree)jCTry.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeTryLeftBrace());
        List<JCTree.JCCatch> list = jCTry.catchers;
        while (list.nonEmpty()) {
            this.printStat((JCTree)list.head);
            list = list.tail;
        }
        if (jCTry.finalizer != null) {
            if (this.cs.placeFinallyOnNewLine()) {
                this.newline();
                this.toLeftMargin();
            } else if (this.cs.spaceBeforeFinally()) {
                this.needSpace();
            }
            this.print("finally");
            this.printBlock((JCTree)jCTry.finalizer, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeFinallyLeftBrace());
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch jCCatch) {
        if (this.cs.placeCatchOnNewLine()) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeCatch()) {
            this.needSpace();
        }
        this.print("catch");
        this.print(this.cs.spaceBeforeCatchParen() ? " (" : "(");
        if (this.cs.spaceWithinCatchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(jCCatch.param);
        this.print(this.cs.spaceWithinCatchParens() ? " )" : ")");
        this.printBlock((JCTree)jCCatch.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeCatchLeftBrace());
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        int n;
        this.printExpr(jCConditional.cond, 2);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                n = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(jCConditional.truepart, n - this.out.col) + this.out.col + 1 <= n) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? "? " : "?");
        this.printExpr(jCConditional.truepart, 3);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                n = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(jCConditional.falsepart, n - this.out.col) + this.out.col + 1 <= n) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? ": " : ":");
        this.printExpr(jCConditional.falsepart, 3);
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        boolean bl;
        this.print("if");
        this.print(this.cs.spaceBeforeIfParen() ? " (" : "(");
        if (this.cs.spaceWithinIfParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(jCIf.cond);
        this.print(this.cs.spaceWithinIfParens() ? " )" : ")");
        boolean bl2 = bl = jCIf.thenpart.getKind() == Tree.Kind.BLOCK && this.cs.redundantIfBraces() != CodeStyle.BracesGenerationStyle.ELIMINATE || this.cs.redundantIfBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (jCIf.elsepart != null && this.danglingElseChecker.hasDanglingElse(jCIf.thenpart)) {
            this.printBlock((JCTree)jCIf.thenpart, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeIfLeftBrace());
            bl = true;
        } else {
            this.printIndentedStat(jCIf.thenpart, this.cs.redundantIfBraces(), this.cs.spaceBeforeIfLeftBrace(), this.cs.wrapIfStatement());
        }
        if (jCIf.elsepart != null) {
            if (this.cs.placeElseOnNewLine() || !bl) {
                this.newline();
                this.toLeftMargin();
            } else if (this.cs.spaceBeforeElse()) {
                this.needSpace();
            }
            this.print("else");
            if (jCIf.elsepart.getKind() == Tree.Kind.IF && this.cs.specialElseIf()) {
                this.needSpace();
                this.printStat(jCIf.elsepart);
            } else {
                this.printIndentedStat(jCIf.elsepart, this.cs.redundantIfBraces(), this.cs.spaceBeforeElseLeftBrace(), this.cs.wrapIfStatement());
            }
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        this.printNoParenExpr(jCExpressionStatement.expr);
        if (this.prec == -1) {
            this.print(';');
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
        this.print("break");
        if (jCBreak.label != null) {
            this.needSpace();
            this.print(jCBreak.label);
        }
        this.print(';');
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
        this.print("continue");
        if (jCContinue.label != null) {
            this.needSpace();
            this.print(jCContinue.label);
        }
        this.print(';');
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        this.print("return");
        if (jCReturn.expr != null) {
            this.needSpace();
            this.printNoParenExpr(jCReturn.expr);
        }
        this.print(';');
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        this.print("throw ");
        this.printNoParenExpr(jCThrow.expr);
        this.print(';');
    }

    @Override
    public void visitAssert(JCTree.JCAssert jCAssert) {
        this.print("assert ");
        this.printExpr(jCAssert.cond);
        if (jCAssert.detail != null) {
            this.print(this.cs.spaceBeforeColon() ? " :" : ":");
            switch (this.cs.wrapAssert()) {
                case WRAP_IF_LONG: {
                    int n = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(jCAssert.detail, n - this.out.col) + this.out.col + 1 <= n) {
                        if (!this.cs.spaceAfterColon()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterColon()) break;
                    this.print(' ');
                }
            }
            this.printExpr(jCAssert.detail);
        }
        this.print(';');
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        int n = this.prec;
        this.prec = 15;
        if (jCMethodInvocation.meth.getTag() == 34) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCMethodInvocation.meth;
            this.printExpr(jCFieldAccess.selected);
            this.print('.');
            if (jCFieldAccess.selected.getTag() == 26) {
                switch (this.cs.wrapChainedMethodCalls()) {
                    case WRAP_IF_LONG: {
                        int n2 = this.cs.getRightMargin();
                        int n3 = jCFieldAccess.name.length();
                        if (jCMethodInvocation.typeargs.nonEmpty()) {
                            n3 += this.widthEstimator.estimateWidth(jCMethodInvocation.typeargs, n2 - this.out.col - n3) + 2;
                        }
                        if ((n3 += this.widthEstimator.estimateWidth(jCMethodInvocation.args, n2 - this.out.col - n3) + 2) + this.out.col <= n2) break;
                    }
                    case WRAP_ALWAYS: {
                        this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                }
            }
            if (jCMethodInvocation.typeargs.nonEmpty()) {
                this.printTypeArguments(jCMethodInvocation.typeargs);
            }
            this.print(jCFieldAccess.name);
        } else {
            if (jCMethodInvocation.typeargs.nonEmpty()) {
                this.printTypeArguments(jCMethodInvocation.typeargs);
            }
            this.printExpr(jCMethodInvocation.meth);
        }
        this.prec = n;
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens() && jCMethodInvocation.args.nonEmpty()) {
            this.print(' ');
        }
        this.wrapTrees(jCMethodInvocation.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() && jCMethodInvocation.args.nonEmpty() ? " )" : ")");
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        if (jCNewClass.encl != null) {
            this.printExpr(jCNewClass.encl);
            this.print('.');
        }
        this.print("new ");
        if (jCNewClass.typeargs.nonEmpty()) {
            this.print("<");
            this.printExprs(jCNewClass.typeargs);
            this.print(">");
        }
        if (jCNewClass.encl == null) {
            this.print(jCNewClass.clazz);
        } else if (jCNewClass.clazz.type != null) {
            this.print(jCNewClass.clazz.type.tsym.name);
        } else {
            this.print(jCNewClass.clazz);
        }
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens() && jCNewClass.args.nonEmpty()) {
            this.print(' ');
        }
        this.wrapTrees(jCNewClass.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() && jCNewClass.args.nonEmpty() ? " )" : ")");
        if (jCNewClass.def != null) {
            Name name = this.enclClassName;
            this.enclClassName = jCNewClass.def.name;
            this.printBlock(null, jCNewClass.def.defs, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeClassDeclLeftBrace(), true);
            this.enclClassName = name;
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        if (jCNewArray.elemtype != null) {
            this.print("new ");
            int n = jCNewArray.elems != null ? 1 : 0;
            JCTree.JCExpression jCExpression = jCNewArray.elemtype;
            while (jCExpression.getTag() == 38) {
                ++n;
                jCExpression = ((JCTree.JCArrayTypeTree)jCExpression).elemtype;
            }
            this.printExpr(jCExpression);
            List<JCTree.JCExpression> list = jCNewArray.dims;
            while (list.nonEmpty()) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ " : "[");
                this.printNoParenExpr((JCTree)list.head);
                this.print(this.cs.spaceWithinArrayInitBrackets() ? " ]" : "]");
                list = list.tail;
            }
            while (--n >= 0) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ ]" : "[]");
            }
        }
        if (jCNewArray.elems != null) {
            if (this.cs.spaceBeforeArrayInitLeftBrace()) {
                this.needSpace();
            }
            this.print('{');
            if (this.cs.spaceWithinBraces()) {
                this.print(' ');
            }
            this.wrapTrees(jCNewArray.elems, this.cs.wrapArrayInit(), this.cs.alignMultilineArrayInit() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            this.print(this.cs.spaceWithinBraces() ? " }" : "}");
        }
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        this.print('(');
        if (this.cs.spaceWithinParens()) {
            this.print(' ');
        }
        this.printExpr(jCParens.expr);
        this.print(this.cs.spaceWithinParens() ? " )" : ")");
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        int n = this.out.col;
        this.printExpr(jCAssign.lhs, 2);
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print('=');
        int n2 = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(jCAssign.rhs, n2 - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundAssignOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.cs.alignMultilineAssignment() ? n : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundAssignOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(jCAssign.rhs, 1);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        int n = this.out.col;
        this.printExpr(jCAssignOp.lhs, 3);
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print(this.treeinfo.operatorName(jCAssignOp.getTag() - 17));
        this.print('=');
        int n2 = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(jCAssignOp.rhs, n2 - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundAssignOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.cs.alignMultilineAssignment() ? n : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundAssignOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(jCAssignOp.rhs, 2);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        int n = TreeInfo.opPrec((int)jCUnary.getTag());
        Name name = this.treeinfo.operatorName(jCUnary.getTag());
        if (jCUnary.getTag() <= 51) {
            if (this.cs.spaceAroundUnaryOps()) {
                this.needSpace();
                this.print(name);
                this.print(' ');
            } else {
                this.print(name);
            }
            this.printExpr(jCUnary.arg, n);
        } else {
            this.printExpr(jCUnary.arg, n);
            if (this.cs.spaceAroundUnaryOps()) {
                this.print(' ');
                this.print(name);
                this.print(' ');
            } else {
                this.print(name);
            }
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        int n = TreeInfo.opPrec((int)jCBinary.getTag());
        Name name = this.treeinfo.operatorName(jCBinary.getTag());
        int n2 = this.out.col;
        this.printExpr(jCBinary.lhs, n);
        if (this.cs.spaceAroundBinaryOps()) {
            this.print(' ');
        }
        this.print(name);
        int n3 = this.cs.getRightMargin();
        switch (this.cs.wrapBinaryOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(jCBinary.rhs, n3 - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundBinaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.cs.alignMultilineBinaryOp() ? n2 : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundBinaryOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(jCBinary.rhs, n + 1);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.print(this.cs.spaceWithinTypeCastParens() ? "( " : "(");
        this.print(jCTypeCast.clazz);
        this.print(this.cs.spaceWithinTypeCastParens() ? " )" : ")");
        if (this.cs.spaceAfterTypeCast()) {
            this.needSpace();
        }
        if (this.origUnit != null && TreePath.getPath(this.origUnit, (Tree)jCTypeCast.expr) != null) {
            int n = TreeInfo.getStartPos(jCTypeCast.expr);
            int n2 = TreeInfo.getEndPos((JCTree)jCTypeCast.expr, (Map)((Object)this.origUnit.endPositions));
            this.print(this.cInfo.getText().substring(n, n2));
            return;
        }
        this.printExpr(jCTypeCast.expr, 14);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.printExpr(jCInstanceOf.expr, 10);
        this.print(" instanceof ");
        this.print(jCInstanceOf.clazz);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.printExpr(jCArrayAccess.indexed, 15);
        this.print('[');
        this.printExpr(jCArrayAccess.index);
        this.print(']');
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        this.printExpr(jCFieldAccess.selected, 15);
        this.print('.');
        this.print(jCFieldAccess.name);
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        this.print(jCIdent.name);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        if (this.origUnit != null && this.cInfo != null && this.cInfo.getTrees().getSourcePositions().getStartPosition(this.origUnit, jCLiteral) >= 0L && this.cInfo.getTrees().getSourcePositions().getEndPosition(this.origUnit, jCLiteral) >= 0L) {
            TokenSequence<JavaTokenId> tokenSequence = this.cInfo.getTreeUtilities().tokensFor(jCLiteral);
            boolean bl = false;
            while (tokenSequence.moveNext()) {
                this.print(((Object)tokenSequence.token().text()).toString());
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        switch (jCLiteral.typetag) {
            case 4: {
                this.print(jCLiteral.value.toString());
                break;
            }
            case 5: {
                this.print(jCLiteral.value.toString() + "L");
                break;
            }
            case 6: {
                this.print(jCLiteral.value.toString() + "F");
                break;
            }
            case 7: {
                this.print(jCLiteral.value.toString());
                break;
            }
            case 2: {
                this.print("'" + Convert.quote(String.valueOf((char)((Number)jCLiteral.value).intValue())) + "'");
                break;
            }
            case 10: {
                this.print("\"" + Convert.quote((String)jCLiteral.value) + "\"");
                break;
            }
            case 8: {
                this.print(jCLiteral.getValue().toString());
                break;
            }
            case 17: {
                this.print("null");
                break;
            }
            default: {
                this.print(jCLiteral.value.toString());
            }
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        this.print(this.symbols.typeOfTag[jCPrimitiveTypeTree.typetag].tsym.name);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        this.printExpr(jCArrayTypeTree.elemtype);
        this.print("[]");
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        this.printExpr(jCTypeApply.clazz);
        this.print('<');
        this.printExprs(jCTypeApply.arguments);
        this.print('>');
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        this.print(jCTypeParameter.name);
        if (jCTypeParameter.bounds.nonEmpty()) {
            this.print(" extends ");
            this.printExprs(jCTypeParameter.bounds, " & ");
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        this.print("" + (Object)((Object)jCWildcard.kind.kind));
        if (jCWildcard.kind.kind != BoundKind.UNBOUND) {
            this.printExpr(jCWildcard.inner);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
        this.printAnnotations(jCModifiers.annotations);
        this.printFlags(jCModifiers.flags);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
        this.print("@");
        this.printExpr(jCAnnotation.annotationType);
        if (jCAnnotation.args.nonEmpty()) {
            this.print(this.cs.spaceBeforeAnnotationParen() ? " (" : "(");
            if (this.cs.spaceWithinAnnotationParens()) {
                this.print(' ');
            }
            this.printExprs(jCAnnotation.args);
            this.print(this.cs.spaceWithinAnnotationParens() ? " )" : ")");
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        this.printExpr(jCEnhancedForLoop.getVariable());
        String string = this.cs.spaceBeforeColon() ? " :" : ":";
        this.print(this.cs.spaceAfterColon() ? string + " " : string);
        this.printExpr(jCEnhancedForLoop.getExpression());
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(jCEnhancedForLoop.getStatement(), this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        this.print("(let " + letExpr.defs + " in " + letExpr.expr + ")");
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        this.print("(ERROR)");
        this.containsError = true;
    }

    @Override
    public void visitTree(JCTree jCTree) {
        this.print("(UNKNOWN: " + jCTree + ")");
        this.newline();
    }

    private void print(char c) {
        this.out.append(c);
    }

    private void needSpace() {
        this.out.needSpace();
    }

    private void blankLines(int n) {
        this.out.blanklines(n);
    }

    private void blankLines(JCTree jCTree, boolean bl) {
        if (jCTree == null) {
            return;
        }
        int n = 0;
        switch (jCTree.getKind()) {
            case CLASS: {
                int n2 = n = bl ? this.cs.getBlankLinesBeforeClass() : this.cs.getBlankLinesAfterClass();
                if (((JCTree.JCClassDecl)jCTree).defs.nonEmpty() && !bl) {
                    n = 0;
                } else {
                    this.out.blanklines(n);
                }
                return;
            }
            case METHOD: {
                if ((((JCTree.JCMethodDecl)jCTree).mods.flags & 0x1000L) == 0L && ((JCTree.JCMethodDecl)jCTree).name != this.names.init || this.enclClassName != null) {
                    n = bl ? this.cs.getBlankLinesBeforeMethods() : this.cs.getBlankLinesAfterMethods();
                    this.out.blanklines(n);
                    this.toLeftMargin();
                }
                return;
            }
            case VARIABLE: {
                if (this.enclClassName != null && this.enclClassName != this.names.empty && (((JCTree.JCVariableDecl)jCTree).mods.flags & 0x4000L) == 0L) {
                    n = bl ? this.cs.getBlankLinesBeforeFields() : this.cs.getBlankLinesAfterFields();
                    this.out.blanklines(n);
                    if (bl) {
                        this.toLeftMargin();
                    }
                }
                return;
            }
        }
    }

    private void toColExactly(int n) {
        if (n < this.out.col) {
            this.newline();
        }
        this.out.toCol(n);
    }

    private void printQualified(Symbol symbol) {
        if (symbol.owner != null && symbol.owner.name.len > 0 && !(symbol.type instanceof Type.TypeVar) && !(symbol.owner instanceof Symbol.MethodSymbol)) {
            if (symbol.owner instanceof Symbol.PackageSymbol) {
                this.printAllQualified(symbol.owner);
            } else {
                this.printQualified(symbol.owner);
            }
            this.print('.');
        }
        this.print(symbol.name);
    }

    private void printAllQualified(Symbol symbol) {
        if (symbol.owner != null && symbol.owner.name.len > 0) {
            this.printAllQualified(symbol.owner);
            this.print('.');
        }
        this.print(symbol.name);
    }

    private void printAnnotations(List<JCTree.JCAnnotation> list) {
        while (list.nonEmpty()) {
            this.printNoParenExpr((JCTree)list.head);
            if (list.tail != null && list.tail.nonEmpty()) {
                switch (this.cs.wrapAnnotations()) {
                    case WRAP_IF_LONG: {
                        int n = this.cs.getRightMargin();
                        if (this.widthEstimator.estimateWidth((JCTree)list.tail.head, n - this.out.col) + this.out.col + 1 <= n) {
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.toColExactly(this.out.leftMargin);
                        break;
                    }
                    case WRAP_NEVER: {
                        this.print(' ');
                    }
                }
            } else {
                this.toColExactly(this.out.leftMargin);
            }
            list = list.tail;
        }
    }

    public void printFlags(long l) {
        this.printFlags(l, true);
    }

    public void printFlags(long l, boolean bl) {
        this.print(TreeInfo.flagNames(l));
        if ((l & 0xFFFL) != 0L) {
            if (this.cs.placeNewLineAfterModifiers()) {
                this.toColExactly(this.out.leftMargin);
            } else if (bl) {
                this.needSpace();
            }
        }
    }

    public void printBlock(JCTree jCTree, JCTree jCTree2, Tree.Kind kind) {
        switch (kind) {
            case ENHANCED_FOR_LOOP: 
            case FOR_LOOP: {
                this.printIndentedStat(jCTree2, this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
                break;
            }
            case WHILE_LOOP: {
                this.printIndentedStat(jCTree2, this.cs.redundantWhileBraces(), this.cs.spaceBeforeWhileLeftBrace(), this.cs.wrapWhileStatement());
                break;
            }
            case IF: {
                this.printIndentedStat(jCTree2, this.cs.redundantIfBraces(), this.cs.spaceBeforeIfLeftBrace(), this.cs.wrapIfStatement());
                break;
            }
            case DO_WHILE_LOOP: {
                this.printIndentedStat(jCTree2, this.cs.redundantDoWhileBraces(), this.cs.spaceBeforeDoLeftBrace(), this.cs.wrapDoWhileStatement());
                if (this.cs.placeWhileOnNewLine()) {
                    this.newline();
                    this.toLeftMargin();
                    break;
                }
                if (!this.cs.spaceBeforeWhile()) break;
                this.needSpace();
            }
        }
    }

    public void printImportsBlock(java.util.List<? extends JCTree> list) {
        boolean bl;
        boolean bl2 = bl = !list.isEmpty();
        if (bl) {
            this.blankLines(this.cs.getBlankLinesBeforeImports());
        }
        for (JCTree jCTree : list) {
            this.printStat(jCTree);
            this.newline();
        }
        if (bl) {
            this.blankLines(this.cs.getBlankLinesAfterImports());
        }
    }

    public void eatChars(int n) {
        this.out.eatAwayChars(n);
    }

    private void printExpr(JCTree jCTree) {
        this.printExpr(jCTree, 0);
    }

    private void printNoParenExpr(JCTree jCTree) {
        while (jCTree instanceof JCTree.JCParens) {
            jCTree = ((JCTree.JCParens)jCTree).expr;
        }
        this.printExpr(jCTree, 0);
    }

    private void printExpr(JCTree jCTree, int n) {
        if (jCTree == null) {
            this.print("/*missing*/");
        } else {
            int n2 = this.prec;
            this.prec = n;
            this.doAccept(jCTree);
            this.prec = n2;
        }
    }

    private <T extends JCTree> void printExprs(List<T> list) {
        String string = this.cs.spaceBeforeComma() ? " ," : ",";
        this.printExprs(list, this.cs.spaceAfterComma() ? string + " " : string);
    }

    private <T extends JCTree> void printExprs(List<T> list, String string) {
        if (list.nonEmpty()) {
            this.printNoParenExpr((JCTree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                this.print(string);
                this.printNoParenExpr((JCTree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    private void printStat(JCTree jCTree) {
        this.printStat(jCTree, false, false);
    }

    private void printStat(JCTree jCTree, boolean bl, boolean bl2) {
        if (jCTree == null) {
            this.print(';');
        } else {
            if (!bl2) {
                this.blankLines(jCTree, true);
            }
            this.printPrecedingComments(jCTree, !bl);
            this.printExpr(jCTree, -1);
            int n = jCTree.getTag();
            if (26 <= n && n <= 90) {
                this.print(';');
            }
            this.printTrailingComments(jCTree, !bl);
            this.blankLines(jCTree, false);
        }
    }

    private void printIndentedStat(JCTree jCTree, CodeStyle.BracesGenerationStyle bracesGenerationStyle, boolean bl, CodeStyle.WrapStyle wrapStyle) {
        if (this.fromOffset >= 0 && this.toOffset >= 0 && (TreeInfo.getStartPos(jCTree) < this.fromOffset || TreeInfo.getEndPos((JCTree)jCTree, (Map)((Object)this.origUnit.endPositions)) > this.toOffset)) {
            bracesGenerationStyle = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
        }
        switch (bracesGenerationStyle) {
            case GENERATE: {
                this.printBlock(jCTree, this.cs.getOtherBracePlacement(), bl);
                return;
            }
            case ELIMINATE: {
                List<JCTree.JCStatement> list;
                while (jCTree instanceof JCTree.JCBlock && !(list = ((JCTree.JCBlock)jCTree).stats).isEmpty() && !list.tail.nonEmpty() && !(list.head instanceof JCTree.JCVariableDecl)) {
                    this.printPrecedingComments(jCTree, true);
                    jCTree = (JCTree)list.head;
                }
            }
            case LEAVE_ALONE: {
                if (jCTree instanceof JCTree.JCBlock) {
                    this.printBlock(jCTree, this.cs.getOtherBracePlacement(), bl);
                    return;
                }
                int n = this.indent();
                switch (wrapStyle) {
                    case WRAP_NEVER: {
                        if (bl) {
                            this.needSpace();
                        }
                        this.printStat(jCTree);
                        this.undent(n);
                        return;
                    }
                    case WRAP_IF_LONG: {
                        int n2 = this.out.harden();
                        int n3 = this.out.col;
                        int n4 = this.out.used;
                        int n5 = this.out.leftMargin;
                        try {
                            if (bl) {
                                this.needSpace();
                            }
                            this.printStat(jCTree);
                            this.undent(n);
                            this.out.restore(n2);
                            return;
                        }
                        catch (Throwable throwable) {
                            this.out.restore(n2);
                            this.out.col = n3;
                            this.out.used = n4;
                            this.out.leftMargin = n5;
                        }
                    }
                    case WRAP_ALWAYS: {
                        if (this.out.col > 0) {
                            this.newline();
                        }
                        this.toLeftMargin();
                        this.printStat(jCTree);
                        this.undent(n);
                    }
                }
            }
        }
    }

    private <T extends JCTree> void printStats(List<T> list) {
        this.printStats(list, false);
    }

    private <T extends JCTree> void printStats(List<T> list, boolean bl) {
        boolean bl2 = true;
        List<Object> list2 = list;
        while (list2.nonEmpty()) {
            JCTree jCTree = (JCTree)list2.head;
            if (!this.isSynthetic(jCTree)) {
                this.toColExactly(this.out.leftMargin);
                this.printStat(jCTree, bl, bl2);
                bl2 = false;
            }
            list2 = list2.tail;
        }
    }

    private void printBlock(JCTree jCTree, CodeStyle.BracePlacement bracePlacement, boolean bl) {
        List<JCTree> list;
        JCTree jCTree2;
        if (jCTree instanceof JCTree.JCBlock) {
            jCTree2 = jCTree;
            list = ((JCTree.JCBlock)jCTree).stats;
        } else {
            jCTree2 = null;
            list = List.of(jCTree);
        }
        this.printBlock(jCTree2, list, bracePlacement, bl);
    }

    private void printBlock(JCTree jCTree, List<? extends JCTree> list, CodeStyle.BracePlacement bracePlacement, boolean bl) {
        this.printBlock(jCTree, list, bracePlacement, bl, false);
    }

    private void printBlock(JCTree jCTree, List<? extends JCTree> list, CodeStyle.BracePlacement bracePlacement, boolean bl, boolean bl2) {
        int n;
        int n2 = n = this.indent();
        switch (bracePlacement) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(n);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(n2 += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                n2 = this.out.leftMargin;
                this.toColExactly(n2);
            }
        }
        if (bl) {
            this.needSpace();
        }
        this.print('{');
        boolean bl3 = true;
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            if (!this.isSynthetic((JCTree)list2.head)) {
                bl3 = false;
                break;
            }
            list2 = list2.tail;
        }
        if (bl3) {
            this.printEmptyBlockComments(jCTree, bl2);
        } else {
            if (bl2) {
                this.blankLines(this.cs.getBlankLinesAfterClassHeader());
            } else {
                this.newline();
            }
            this.printStats(list, bl2);
        }
        this.toColExactly(n2);
        this.undent(n);
        this.print('}');
    }

    private void printTypeParameters(List<JCTree.JCTypeParameter> list) {
        if (list.nonEmpty()) {
            this.print('<');
            this.printExprs(list);
            this.print('>');
        }
    }

    private void printTypeArguments(List<? extends JCTree.JCExpression> list) {
        if (list.nonEmpty()) {
            this.print('<');
            this.printExprs(list);
            this.print('>');
        }
    }

    private void printPrecedingComments(JCTree jCTree, boolean bl) {
        CommentSet commentSet = this.commentHandler.getComments(jCTree);
        if (!commentSet.getPrecedingComments().isEmpty()) {
            for (Comment comment : commentSet.getPrecedingComments()) {
                this.printComment(comment, true, bl);
            }
            return;
        }
        LinkedList<Comment> linkedList = new LinkedList<Comment>();
        if (this.cInfo != null) {
            int n = TreeInfo.getStartPos(jCTree);
            int n2 = TreeInfo.getEndPos((JCTree)jCTree, (Map)((Object)this.origUnit.endPositions));
            if (n >= 0 && n2 >= 0) {
                if (this.pendingComments != null) {
                    linkedList.addAll(this.pendingComments);
                    this.pendingComments = null;
                }
                TokenSequence tokenSequence = this.cInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                tokenSequence.move(n);
                if (PositionEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)tokenSequence, PositionEstimator.Direction.BACKWARD) == null) {
                    tokenSequence.moveStart();
                }
                int n3 = -2;
                while (tokenSequence.moveNext() && PositionEstimator.nonRelevant.contains(tokenSequence.token().id())) {
                    if (tokenSequence.index() <= this.lastReadCommentIdx) continue;
                    switch ((JavaTokenId)tokenSequence.token().id()) {
                        case LINE_COMMENT: {
                            linkedList.add(Comment.create(Comment.Style.LINE, tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length(), n3, tokenSequence.token().toString()));
                            n3 = 0;
                            break;
                        }
                        case BLOCK_COMMENT: {
                            linkedList.add(Comment.create(Comment.Style.BLOCK, tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length(), n3, tokenSequence.token().toString()));
                            n3 = -2;
                            break;
                        }
                        case JAVADOC_COMMENT: {
                            linkedList.add(Comment.create(Comment.Style.JAVADOC, tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length(), n3, tokenSequence.token().toString()));
                            n3 = -2;
                            break;
                        }
                        case WHITESPACE: {
                            String string = tokenSequence.token().toString();
                            linkedList.add(Comment.create(Comment.Style.WHITESPACE, -2, -2, -2, string));
                            int n4 = string.lastIndexOf(10);
                            if (n4 < 0) {
                                if (n3 < 0) break;
                                n3 += string.length();
                                break;
                            }
                            n3 = string.length() - n4 - 1;
                        }
                    }
                    this.lastReadCommentIdx = tokenSequence.index();
                }
            }
        }
        for (Comment comment : linkedList) {
            this.printComment(comment, true, bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printTrailingComments(JCTree jCTree, boolean bl) {
        Comment comment;
        int n;
        CommentSet commentSet = this.commentHandler.getComments(jCTree);
        if (!commentSet.getTrailingComments().isEmpty()) {
            Iterator<Comment> iterator = commentSet.getTrailingComments().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                Comment comment2 = iterator.next();
                this.printComment(comment2, false, bl);
            }
        }
        LinkedList<Comment> linkedList = new LinkedList<Comment>();
        if (this.cInfo != null && (n = TreeInfo.getEndPos((JCTree)jCTree, (Map)((Object)this.origUnit.endPositions))) >= 0) {
            if (this.pendingComments == null) {
                this.pendingComments = new LinkedList();
            }
            comment = this.cInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            comment.move(n);
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = -2;
            block8: while (comment.moveNext() && (PositionEstimator.nonRelevant.contains(comment.token().id()) || PositionEstimator.isSeparator((JavaTokenId)comment.token().id()))) {
                if (comment.index() <= this.lastReadCommentIdx) continue;
                switch ((JavaTokenId)comment.token().id()) {
                    case LINE_COMMENT: {
                        this.pendingComments.add(Comment.create(Comment.Style.LINE, comment.offset(), comment.offset() + comment.token().length(), n2, comment.token().toString()));
                        if (!bl2) {
                            linkedList.addAll(this.pendingComments);
                            this.pendingComments = new LinkedList();
                            bl2 = true;
                        }
                        n2 = 0;
                        break;
                    }
                    case BLOCK_COMMENT: {
                        this.pendingComments.add(Comment.create(Comment.Style.BLOCK, comment.offset(), comment.offset() + comment.token().length(), n2, comment.token().toString()));
                        n2 = -2;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        this.pendingComments.add(Comment.create(Comment.Style.JAVADOC, comment.offset(), comment.offset() + comment.token().length(), n2, comment.token().toString()));
                        n2 = -2;
                        break;
                    }
                    case WHITESPACE: {
                        String string = comment.token().toString();
                        this.pendingComments.add(Comment.create(Comment.Style.WHITESPACE, -2, -2, -2, string));
                        int n3 = string.lastIndexOf(10);
                        if (n3 >= 0) {
                            if (n2 == 0) {
                                if (!bl3) {
                                    linkedList.addAll(this.pendingComments);
                                    this.pendingComments = new LinkedList();
                                }
                                bl3 = true;
                            } else if (!bl2) {
                                linkedList.addAll(this.pendingComments);
                                this.pendingComments = new LinkedList();
                            }
                            bl2 = true;
                        }
                        if (n3 < 0) {
                            if (n2 < 0) break;
                            n2 += string.length();
                            break;
                        }
                        n2 = string.length() - n3 - 1;
                        break;
                    }
                    case LBRACE: 
                    case RBRACE: 
                    case SEMICOLON: {
                        linkedList.addAll(this.pendingComments);
                        this.pendingComments = null;
                        n2 = -2;
                        break block8;
                    }
                }
                this.lastReadCommentIdx = comment.index();
            }
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            comment = (Comment)iterator.next();
            this.printComment(comment, false, bl);
        }
        return;
    }

    private void printEmptyBlockComments(JCTree jCTree, boolean bl) {
        int n;
        LinkedList<Comment> linkedList = new LinkedList<Comment>();
        if (this.cInfo != null && (n = TreeInfo.getEndPos((JCTree)jCTree, (Map)((Object)this.origUnit.endPositions)) - 1) >= 0) {
            Comment comment = this.cInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            comment.move(n);
            PositionEstimator.moveToSrcRelevant((TokenSequence<JavaTokenId>)comment, PositionEstimator.Direction.BACKWARD);
            int n2 = -2;
            while (comment.moveNext() && PositionEstimator.nonRelevant.contains(comment.token().id())) {
                if (comment.index() <= this.lastReadCommentIdx) continue;
                switch ((JavaTokenId)comment.token().id()) {
                    case LINE_COMMENT: {
                        linkedList.add(Comment.create(Comment.Style.LINE, comment.offset(), comment.offset() + comment.token().length(), n2, comment.token().toString()));
                        n2 = 0;
                        break;
                    }
                    case BLOCK_COMMENT: {
                        linkedList.add(Comment.create(Comment.Style.BLOCK, comment.offset(), comment.offset() + comment.token().length(), n2, comment.token().toString()));
                        n2 = -2;
                        break;
                    }
                    case JAVADOC_COMMENT: {
                        linkedList.add(Comment.create(Comment.Style.JAVADOC, comment.offset(), comment.offset() + comment.token().length(), n2, comment.token().toString()));
                        n2 = -2;
                        break;
                    }
                    case WHITESPACE: {
                        String string = comment.token().toString();
                        linkedList.add(Comment.create(Comment.Style.WHITESPACE, -2, -2, -2, string));
                        int n3 = string.lastIndexOf(10);
                        if (n3 < 0) {
                            if (n2 < 0) break;
                            n2 += string.length();
                            break;
                        }
                        n2 = string.length() - n3 - 1;
                    }
                }
                this.lastReadCommentIdx = comment.index();
            }
        }
        for (Comment comment : linkedList) {
            this.printComment(comment, false, bl);
        }
    }

    private void printComment(Comment comment, boolean bl, boolean bl2) {
        if (Comment.Style.WHITESPACE == comment.style()) {
            return;
        }
        String string = comment.getText();
        boolean bl3 = string.charAt(0) != '/';
        LinkedList<CommentLine> linkedList = new LinkedList<CommentLine>();
        int n = -1;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                linkedList.add(new CommentLine(n, n < 0 ? 0 : i - n, string));
                n = -1;
                continue;
            }
            if (c <= ' ' || n >= 0) continue;
            n = i;
        }
        if (n >= 0 && n < n2) {
            linkedList.add(new CommentLine(n, n2 - n, string));
        }
        if (comment.indent() == 0) {
            if (!bl && this.out.lastBlankLines == 0) {
                this.newline();
            }
            this.out.toLineStart();
        } else if (comment.indent() > 0 && !bl) {
            if (this.out.lastBlankLines == 0) {
                this.newline();
            }
            this.toLeftMargin();
        } else {
            this.needSpace();
        }
        if (bl3) {
            switch (comment.style()) {
                case LINE: {
                    this.print("// ");
                    break;
                }
                case BLOCK: {
                    this.print("/* ");
                    break;
                }
                case JAVADOC: {
                    this.print("/**");
                    this.newline();
                    this.toLeftMargin();
                    this.print(" * ");
                }
            }
        }
        ((CommentLine)linkedList.removeFirst()).print(this.out.col);
        while (!linkedList.isEmpty()) {
            this.newline();
            this.toLeftMargin();
            CommentLine commentLine = (CommentLine)linkedList.removeFirst();
            if (bl3) {
                this.print(" * ");
            } else if (commentLine.body.charAt(commentLine.startPos) == '*') {
                this.print(' ');
            }
            commentLine.print(this.out.col);
        }
        if (bl3) {
            switch (comment.style()) {
                case BLOCK: {
                    this.print(" */");
                    break;
                }
                case JAVADOC: {
                    this.newline();
                    this.toLeftMargin();
                    this.print(" */");
                }
            }
        }
        if (comment.indent() >= 0 || comment.style() != Comment.Style.BLOCK) {
            this.newline();
            this.toLeftMargin();
        } else {
            this.needSpace();
        }
    }

    private void wrap(String string, CodeStyle.WrapStyle wrapStyle) {
        switch (wrapStyle) {
            case WRAP_IF_LONG: {
                if (string.length() + this.out.col + 1 <= this.cs.getRightMargin()) {
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                this.print(' ');
            }
        }
        this.print(string);
    }

    private <T extends JCTree> void wrapTrees(List<T> list, CodeStyle.WrapStyle wrapStyle, int n) {
        boolean bl = true;
        List<Object> list2 = list;
        while (list2.nonEmpty()) {
            if (!bl) {
                this.print(this.cs.spaceBeforeComma() ? " ," : ",");
                switch (wrapStyle) {
                    case WRAP_IF_LONG: {
                        int n2 = this.cs.getRightMargin();
                        if (this.widthEstimator.estimateWidth((JCTree)list2.head, n2 - this.out.col) + this.out.col + 1 <= n2) {
                            if (!this.cs.spaceAfterComma()) break;
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.toColExactly(n);
                        break;
                    }
                    case WRAP_NEVER: {
                        if (!this.cs.spaceAfterComma()) break;
                        this.print(' ');
                    }
                }
            }
            this.printNoParenExpr((JCTree)list2.head);
            bl = false;
            list2 = list2.tail;
        }
    }

    private Name fullName(JCTree jCTree) {
        switch (jCTree.getTag()) {
            case 35: {
                return ((JCTree.JCIdent)jCTree).name;
            }
            case 34: {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCTree;
                Name name = this.fullName(jCFieldAccess.selected);
                return name != null && name.len > 0 ? name.append('.', jCFieldAccess.name) : jCFieldAccess.name;
            }
        }
        return null;
    }

    private boolean isSynthetic(JCTree jCTree) {
        if (jCTree.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)jCTree).mods.flags & 0x1000000000L) != 0L;
        }
        if (jCTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && this.origUnit != null) {
            JCTree.JCExpressionStatement jCExpressionStatement = (JCTree.JCExpressionStatement)jCTree;
            if (jCExpressionStatement.expr.getKind() == Tree.Kind.METHOD_INVOCATION) {
                JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)jCExpressionStatement.getExpression();
                if (jCMethodInvocation.meth.getKind() == Tree.Kind.IDENTIFIER) {
                    JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCMethodInvocation.getMethodSelect();
                    if (jCIdent.name == this.names._super) {
                        return TreeInfo.getEndPos((JCTree)jCTree, (Map)((Object)this.origUnit.endPositions)) < 0 && jCTree.pos != 0 && jCTree.pos != -2;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isEnumerator(JCTree jCTree) {
        return jCTree.getTag() == 5 && (((JCTree.JCVariableDecl)jCTree).mods.flags & 0x4000L) != 0L;
    }

    private String replace(String string, String string2) {
        string = string.replace(string2, this.out.toString());
        this.out.clear();
        return string;
    }

    private class CommentLine {
        private int startPos;
        private int length;
        private String body;

        CommentLine(int n, int n2, String string) {
            this.length = n2;
            this.startPos = this.length == 0 ? 0 : n;
            this.body = string;
        }

        public void print(int n) {
            if (this.length > 0) {
                int n2 = this.startPos + this.length;
                for (int i = this.startPos; i < n2; ++i) {
                    VeryPretty.this.out.append(this.body.charAt(i));
                }
            }
        }
    }
}

