/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.OutputFileObject;
import org.netbeans.modules.java.source.util.Iterators;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFileManager
extends CachingFileManager {
    private ClassPath scp;
    private final Set<File> filteredFiles = new HashSet<File>();
    private boolean filtered;
    private String outputRoot;

    public OutputFileManager(CachingArchiveProvider cachingArchiveProvider, ClassPath classPath, ClassPath classPath2) {
        super(cachingArchiveProvider, classPath, false, true);
        assert (classPath2 != null && classPath != null);
        this.scp = classPath2;
    }

    public final boolean isFiltered() {
        return this.filtered;
    }

    public final synchronized void setFilteredFiles(Set<File> set) {
        assert (set != null);
        this.filteredFiles.clear();
        this.filteredFiles.addAll(set);
        this.filtered = true;
    }

    public final synchronized void clearFilteredFiles() {
        this.filteredFiles.clear();
        this.filtered = false;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) {
        Iterable<JavaFileObject> iterable = super.list(location, string, set, bl);
        if (this.filteredFiles.isEmpty()) {
            return iterable;
        }
        Iterable<JavaFileObject> iterable2 = Iterators.filter(iterable, new Comparable<JavaFileObject>(){

            @Override
            public int compareTo(JavaFileObject javaFileObject) {
                File file = ((FileObjects.FileBase)javaFileObject).f;
                return OutputFileManager.this.filteredFiles.contains(file) ? 0 : -1;
            }
        });
        return iterable2;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        Object object;
        if (kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException();
        }
        File file = null;
        if (this.outputRoot != null) {
            file = new File(this.outputRoot);
        } else {
            int n = fileObject != null ? this.getActiveRoot(fileObject) : this.getActiveRoot(FileObjects.convertPackage2Folder(string));
            if (n == -1) {
                throw new InvalidSourcePath();
            }
            if (n < 0) {
                Logger.getLogger(OutputFileManager.class.getName()).warning("No output for class: " + string + " sibling: " + fileObject + " srcRoots: " + this.scp + " cacheRoots: " + this.cp);
                throw new InvalidSourcePath();
            }
            assert (n < this.cp.entries().size()) : "index " + n + " class: " + string + " sibling: " + fileObject + " srcRoots: " + this.scp + " cacheRoots: " + this.cp;
            file = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(n)).getURL().toExternalForm()));
        }
        String string2 = string.replace('.', File.separatorChar);
        String string3 = string2 + '.' + (this.outputRoot != null ? "sig" : "class");
        int n = string3.lastIndexOf(File.separatorChar);
        if (n != -1) {
            object = string3.substring(0, n);
            new File(file, (String)object).mkdirs();
        } else {
            file.mkdirs();
        }
        object = FileUtil.normalizeFile((File)new File(file, string3));
        return OutputFileObject.create(file, (File)object);
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, javax.tools.FileObject fileObject) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        assert (string != null);
        assert (string2 != null);
        if (fileObject == null) {
            throw new IllegalArgumentException("sibling == null");
        }
        int n = this.getActiveRoot(fileObject);
        if (n == -1) {
            throw new InvalidSourcePath();
        }
        assert (n >= 0 && n < this.cp.entries().size());
        File file = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(n)).getURL().toExternalForm()));
        File file2 = string.length() == 0 ? file : new File(file, FileObjects.convertPackage2Folder(string));
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException();
        }
        File file3 = FileUtil.normalizeFile((File)new File(file2, string2));
        return OutputFileObject.create(file, file3);
    }

    private int getActiveRoot(javax.tools.FileObject fileObject) throws IOException {
        List list = this.scp.entries();
        int n = list.size();
        if (n == 1) {
            return 0;
        }
        if (n == 0) {
            return -1;
        }
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            URL uRL = ((ClassPath.Entry)iterator.next()).getURL();
            if (this.isParentOf(uRL, fileObject.toUri().toURL())) {
                return n2;
            }
            ++n2;
        }
        return -2;
    }

    private boolean isParentOf(URL uRL, URL uRL2) throws IOException {
        assert (uRL != null && uRL2 != null);
        return uRL2.toExternalForm().startsWith(uRL.toExternalForm());
    }

    private int getActiveRoot(String string) {
        String string2;
        List list = this.scp.entries();
        int n = list.size();
        if (n == 1) {
            return 0;
        }
        if (n == 0) {
            return -1;
        }
        String string3 = null;
        int n2 = string.lastIndexOf(47);
        if (n2 < 0) {
            string2 = string;
        } else {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        n2 = string2.indexOf(36);
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            FileObject fileObject;
            FileObject fileObject2 = ((ClassPath.Entry)iterator.next()).getRoot();
            if (fileObject2 != null && (fileObject = fileObject2.getFileObject(string3)) != null && fileObject.getFileObject(string2, "java") != null) {
                return n3;
            }
            ++n3;
        }
        return -2;
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        if ("output-root".equals(string)) {
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException();
            }
            this.outputRoot = iterator.next();
            if (this.outputRoot.length() <= 0) {
                this.outputRoot = null;
            }
            return true;
        }
        return super.handleOption(string, iterator);
    }

    public class InvalidSourcePath
    extends IllegalStateException {
    }
}

