/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.spi.java.loaders.RenameHandler;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class JavaNode
extends DataNode
implements ChangeListener {
    private static final String EXECUTABLE_BADGE_URL = "org/netbeans/modules/java/resources/executable-badge.png";
    private static final String NEEDS_COMPILE_BADGE_URL = "org/netbeans/modules/java/resources/needs-compile.png";
    private static final long serialVersionUID = -7396485743899766258L;
    private static final String JAVA_ICON_BASE = "org/netbeans/modules/java/resources/class.png";
    private static final String CLASS_ICON_BASE = "org/netbeans/modules/java/resources/clazz.gif";
    private static final Image NEEDS_COMPILE;
    private static final Image IS_EXECUTABLE_CLASS;
    private FileBuiltQuery.Status status;
    private final AtomicBoolean isCompiled;
    private ChangeListener executableListener;
    private final AtomicBoolean isExecutable;
    private static final RequestProcessor WORKER;

    public JavaNode(final DataObject dataObject, boolean bl) {
        super(dataObject, Children.LEAF);
        this.setIconBaseWithExtension(bl ? JAVA_ICON_BASE : CLASS_ICON_BASE);
        Logger.getLogger("TIMER").log(Level.FINE, "JavaNode", new Object[]{dataObject.getPrimaryFile(), this});
        if (bl) {
            this.isCompiled = new AtomicBoolean(true);
            WORKER.post((Runnable)new BuildStatusTask(this));
            this.isExecutable = new AtomicBoolean(false);
            WORKER.post((Runnable)new ExecutableTask(this));
            dataObject.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                        Logger.getLogger("TIMER").log(Level.FINE, "JavaNode", new Object[]{dataObject.getPrimaryFile(), this});
                        WORKER.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                JavaNode javaNode = JavaNode.this;
                                synchronized (javaNode) {
                                    JavaNode.this.status = null;
                                    JavaNode.this.executableListener = null;
                                    WORKER.post((Runnable)new BuildStatusTask(JavaNode.this));
                                    WORKER.post((Runnable)new ExecutableTask(JavaNode.this));
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.isCompiled = null;
            this.isExecutable = null;
        }
    }

    public void setName(String string) {
        RenameHandler renameHandler = JavaNode.getRenameHandler();
        if (renameHandler == null) {
            super.setName(string);
        } else {
            try {
                renameHandler.handleRename((Node)this, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.setName(string);
            }
        }
    }

    private static synchronized RenameHandler getRenameHandler() {
        Collection collection = Lookup.getDefault().lookupAll(RenameHandler.class);
        if (collection.size() == 0) {
            return null;
        }
        if (collection.size() > 1) {
            ErrorManager.getDefault().log(16, "Multiple instances of RenameHandler found in Lookup; only using first one: " + collection);
        }
        return (RenameHandler)collection.iterator().next();
    }

    protected final Sheet createSheet() {
        Sheet sheet = super.createSheet();
        if (JavaNode.getRenameHandler() != null) {
            sheet.get("properties").put(this.createNameProperty());
        }
        Sheet.Set set = new Sheet.Set();
        set.setName("classpaths");
        set.setDisplayName(NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_sheet_classpaths"));
        set.setShortDescription(NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_sheet_classpaths"));
        set.put(new Node.Property[]{new ClasspathProperty("classpath/compile", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_compile_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_compile_classpath")), new ClasspathProperty("classpath/execute", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_execute_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_execute_classpath")), new ClasspathProperty("classpath/boot", NbBundle.getMessage(JavaNode.class, (String)"PROP_JavaNode_boot_classpath"), NbBundle.getMessage(JavaNode.class, (String)"HINT_JavaNode_boot_classpath"))});
        sheet.put(set);
        return sheet;
    }

    private Node.Property createNameProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getMessage(DataObject.class, (String)"PROP_name"), NbBundle.getMessage(DataObject.class, (String)"HINT_name")){

            public String getValue() {
                return JavaNode.this.getName();
            }

            public Object getValue(String string) {
                if ("suppressCustomEditor".equals(string)) {
                    return Boolean.TRUE;
                }
                return super.getValue(string);
            }

            public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                JavaNode.this.setName(string);
            }

            public boolean canWrite() {
                return JavaNode.this.canRename();
            }
        };
        return readWrite;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        WORKER.post((Runnable)new BuildStatusTask(this));
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        return this.enhanceIcon(image);
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        return this.enhanceIcon(image);
    }

    private Image enhanceIcon(Image image) {
        if (this.isCompiled != null && !this.isCompiled.get()) {
            image = Utilities.mergeImages((Image)image, (Image)NEEDS_COMPILE, (int)16, (int)0);
        }
        if (this.isExecutable != null && this.isExecutable.get()) {
            image = Utilities.mergeImages((Image)image, (Image)IS_EXECUTABLE_CLASS, (int)10, (int)6);
        }
        return image;
    }

    static {
        URL uRL = JavaNode.class.getClassLoader().getResource(NEEDS_COMPILE_BADGE_URL);
        String string = "<img src=\"" + uRL + "\">&nbsp;" + NbBundle.getMessage(JavaNode.class, (String)"TP_NeedsCompileBadge");
        NEEDS_COMPILE = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)NEEDS_COMPILE_BADGE_URL), (String)string);
        URL uRL2 = JavaNode.class.getClassLoader().getResource(EXECUTABLE_BADGE_URL);
        String string2 = "<img src=\"" + uRL2 + "\">&nbsp;" + NbBundle.getMessage(JavaNode.class, (String)"TP_ExecutableBadge");
        IS_EXECUTABLE_CLASS = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)EXECUTABLE_BADGE_URL), (String)string2);
        WORKER = new RequestProcessor("Java Node Badge Processor", 1);
    }

    private static class ExecutableTask
    implements Runnable {
        private final JavaNode node;

        public ExecutableTask(JavaNode javaNode) {
            this.node = javaNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileObject fileObject;
            Object object;
            ChangeListener changeListener;
            JavaNode javaNode = this.node;
            synchronized (javaNode) {
                changeListener = this.node.executableListener;
            }
            javaNode = this.node.getDataObject().getPrimaryFile();
            if (changeListener == null) {
                changeListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        WORKER.post((Runnable)new ExecutableTask(ExecutableTask.this.node));
                    }
                };
                try {
                    ExecutableFilesIndex.DEFAULT.addChangeListener(javaNode.getURL(), changeListener);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
                object = this.node;
                synchronized (object) {
                    if (this.node.executableListener == null) {
                        this.node.executableListener = changeListener;
                    }
                }
            }
            FileObject fileObject2 = fileObject = (object = ClassPath.getClassPath((FileObject)javaNode, (String)"classpath/source")) != null ? object.findOwnerRoot((FileObject)javaNode) : null;
            if (fileObject != null) {
                try {
                    boolean bl = ExecutableFilesIndex.DEFAULT.isMainClass(fileObject.getURL(), javaNode.getURL());
                    boolean bl2 = this.node.isExecutable.getAndSet(bl);
                    if (bl != bl2) {
                        this.node.fireIconChange();
                        this.node.fireOpenedIconChange();
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
        }
    }

    private static class BuildStatusTask
    implements Runnable {
        private JavaNode node;

        public BuildStatusTask(JavaNode javaNode) {
            this.node = javaNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            boolean bl2;
            FileBuiltQuery.Status status = null;
            JavaNode javaNode = this.node;
            synchronized (javaNode) {
                status = this.node.status;
            }
            if (status == null) {
                javaNode = this.node.getDataObject().getPrimaryFile();
                status = FileBuiltQuery.getStatus((FileObject)javaNode);
                JavaNode javaNode2 = this.node;
                synchronized (javaNode2) {
                    if (status != null && this.node.status == null) {
                        this.node.status = status;
                        this.node.status.addChangeListener(WeakListeners.change((ChangeListener)this.node, (Object)this.node.status));
                    }
                }
            }
            if ((bl2 = status != null ? status.isBuilt() : true) != (bl = this.node.isCompiled.getAndSet(bl2))) {
                this.node.fireIconChange();
                this.node.fireOpenedIconChange();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClasspathProperty
    extends PropertySupport.ReadOnly<String> {
        private final String id;

        public ClasspathProperty(String string, String string2, String string3) {
            super(string, String.class, string2, string3);
            this.id = string;
            this.setValue("oneline", false);
        }

        public String getValue() {
            ClassPath classPath = ClassPath.getClassPath((FileObject)JavaNode.this.getDataObject().getPrimaryFile(), (String)this.id);
            if (classPath != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (ClassPath.Entry entry : classPath.entries()) {
                    URL uRL = entry.getURL();
                    String string = uRL.toExternalForm();
                    if (uRL.getProtocol().equals("file")) {
                        string = new File(URI.create(string)).getAbsolutePath();
                    } else if (uRL.getProtocol().equals("jar") && string.endsWith("!/")) {
                        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                        assert (uRL2 != null) : uRL;
                        if (uRL2.getProtocol().equals("file")) {
                            string = new File(URI.create(uRL2.toExternalForm())).getAbsolutePath();
                        }
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            return NbBundle.getMessage(JavaNode.class, (String)"LBL_JavaNode_classpath_unknown");
        }
    }
}

