/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reportgenerator.api;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.netbeans.modules.reportgenerator.api.GenerateReportAction;
import org.netbeans.modules.reportgenerator.api.ReportCustomizationOptions;
import org.netbeans.modules.reportgenerator.customization.ReportCustomizationPanel;
import org.netbeans.modules.reportgenerator.generator.DataObjectSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizeReportAction
extends AbstractAction {
    public static final String ACCELERATOR = "alt shift F11";
    private static final Icon icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/reportgenerator/api/impl/resources/images/customizeReport.png"));
    private static final String label = NbBundle.getMessage(GenerateReportAction.class, (String)"NAME_Customize_Report");
    private DataObject mDataObject;

    public CustomizeReportAction(DataObject dataObject) {
        super(label, icon);
        this.mDataObject = dataObject;
        this.putValue("Name", label);
        this.putValue("ShortDescription", label);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(ACCELERATOR));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ReportCustomizationOptions reportCustomizationOptions = DataObjectSettings.getOrStoreOptions(this.mDataObject);
        ReportCustomizationPanel reportCustomizationPanel = new ReportCustomizationPanel(reportCustomizationOptions);
        reportCustomizationPanel.setPreferredSize(new Dimension(300, 300));
        String string = NbBundle.getMessage(CustomizeReportAction.class, (String)"NAME_Customize_Report");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)reportCustomizationPanel, string, true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            reportCustomizationOptions.setGenerateVerboseReport(reportCustomizationPanel.isGenerateVerboseReport());
            reportCustomizationOptions.setIncludeOnlyElementsWithDocumentation(reportCustomizationPanel.isIncludeOnlyElementsWithDocumentation());
        }
    }
}

