/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JsUtils {
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    public static final String[] CALL_KEYWORDS = new String[]{"true", "false", "null"};
    public static final String[] JAVASCRIPT_KEYWORDS = new String[]{"break", "case", "catch", "continue", "default", "delete", "do", "else", "false", "finally", "for", "function", "if", "in", "instanceof", "new", "null", "return", "switch", "this", "throw", "true", "try", "typeof", "undefined", "var", "void", "while", "with"};
    public static final String[] JAVASCRIPT_RESERVED_WORDS = new String[]{"abstract", "boolean", "byte", "char", "class", "const", "debugger", "double", "enum", "export", "extends", "final", "float", "goto", "implements", "import", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "super", "synchronized", "throws", "transient", "volatile"};

    private JsUtils() {
    }

    public static boolean isJsFile(FileObject fileObject) {
        return "text/javascript".equals(fileObject.getMIMEType());
    }

    public static boolean isJsOrJsonDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return "text/javascript".equals(string) || "text/x-json".equals(string);
    }

    public static boolean isJsonFile(FileObject fileObject) {
        return fileObject != null && "json".equals(fileObject.getExt());
    }

    public static boolean isRhtmlDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return RHTML_MIME_TYPE.equals(string);
    }

    public static boolean isOperator(String string) {
        if (string.length() == 0) {
            return false;
        }
        switch (string.charAt(0)) {
            case '+': {
                return string.equals("+") || string.equals("+@");
            }
            case '-': {
                return string.equals("-") || string.equals("-@");
            }
            case '*': {
                return string.equals("*") || string.equals("**");
            }
            case '<': {
                return string.equals("<") || string.equals("<<") || string.equals("<=") || string.equals("<=>");
            }
            case '>': {
                return string.equals(">") || string.equals(">>") || string.equals(">=");
            }
            case '=': {
                return string.equals("=") || string.equals("==") || string.equals("===") || string.equals("=~");
            }
            case '!': {
                return string.equals("!=") || string.equals("!~");
            }
            case '&': {
                return string.equals("&") || string.equals("&&");
            }
            case '|': {
                return string.equals("|") || string.equals("||");
            }
            case '[': {
                return string.equals("[]") || string.equals("[]=");
            }
            case '%': {
                return string.equals("%");
            }
            case '/': {
                return string.equals("/");
            }
            case '~': {
                return string.equals("~");
            }
            case '^': {
                return string.equals("^");
            }
            case '`': {
                return string.equals("`");
            }
        }
        return false;
    }

    public static boolean isSafeIdentifierName(String string, int n) {
        char c;
        int n2;
        for (n2 = n; n2 < string.length() && ((c = string.charAt(n2)) == '$' || c == '@' || c == ':'); ++n2) {
        }
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (!(c >= 'a' && c <= 'z' || c == '_' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '?' || c == '=' || c == '!')) {
                return JsUtils.isOperator(string);
            }
            ++n2;
        }
        return true;
    }

    public static String getIdentifierWarning(String string, int n) {
        if (JsUtils.isSafeIdentifierName(string, n)) {
            return null;
        }
        return NbBundle.getMessage(JsUtils.class, (String)"UnsafeIdentifierName");
    }

    public static boolean isValidJsModuleName(String string) {
        String[] stringArray;
        if (string.trim().length() == 0) {
            return false;
        }
        for (String string2 : stringArray = string.split("::")) {
            if (JsUtils.isValidJsClassName(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJsClassName(String string) {
        if (JsUtils.isJsKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (JsUtils.isStrictIdentifierChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJsLocalVarName(String string) {
        if (JsUtils.isJsKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJsMethodName(String string) {
        if (JsUtils.isJsKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (JsUtils.isOperator(string)) {
            return true;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return i == string.length() - 1 && (c == '!' || c == '=' || c == '?');
        }
        return true;
    }

    public static boolean isValidJsIdentifier(String string) {
        if (JsUtils.isJsKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJsKeyword(String string) {
        for (String string2 : JAVASCRIPT_KEYWORDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getLineCommentPrefix() {
        return "//";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$';
    }

    public static boolean isStrictIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$';
    }

    public static boolean isRowWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n'; ++n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static boolean isRowEmpty(String string, int n) throws BadLocationException {
        try {
            char c;
            if (n < string.length() && (c = string.charAt(n)) != '\n' && (c != '\r' || n != string.length() - 1 && string.charAt(n + 1) != '\n')) {
                return false;
            }
            return n == 0 || string.charAt(n - 1) == '\n';
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowLastNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n' && (c != '\r' || n2 != string.length() - 1 && string.charAt(n2 + 1) != '\n'); ++n2) {
            }
            --n2;
            while (n2 >= 0) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                --n2;
            }
            return -1;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowFirstNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            if (n2 < string.length()) {
                for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                }
                ++n2;
            }
            while (n2 < string.length()) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowStart(String string, int n) throws BadLocationException {
        try {
            for (int i = n - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
            return 0;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static boolean endsWith(StringBuilder stringBuilder, String string) {
        int n = string.length();
        if (stringBuilder.length() < n) {
            return false;
        }
        int n2 = stringBuilder.length() - n;
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.charAt(n2) != string.charAt(i)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String truncate(String string, int n) {
        assert (n > 3);
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n - 3) + "...";
    }

    public static String normalizeTypeString(String string) {
        if (string.indexOf("Array<") != -1) {
            String[] stringArray = string.split("\\|");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                if (string2.startsWith("Array<") && string2.endsWith(">")) {
                    stringBuilder.append(string2.substring(6, string2.length() - 1));
                    stringBuilder.append("[]");
                    continue;
                }
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        return string;
    }
}

