/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.mozilla.javascript.Node;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.TypeSearcher;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.NbUtilities;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTypeSearcher
implements TypeSearcher {
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\:|\\.|\\$)*){2,}");
    private NameKind cachedKind;
    private String cachedString = "/";

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) || c == ':') continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCase(String string) {
        return camelCasePattern.matcher(string).matches();
    }

    private NameKind adjustKind(NameKind nameKind, String string) {
        if (string.equals(this.cachedString)) {
            return this.cachedKind;
        }
        if (nameKind == NameKind.CASE_INSENSITIVE_PREFIX && (JsTypeSearcher.isAllUpper(string) && string.length() > 1 || JsTypeSearcher.isCamelCase(string))) {
            nameKind = NameKind.CAMEL_CASE;
        }
        this.cachedString = string;
        this.cachedKind = nameKind;
        return nameKind;
    }

    public Set<? extends TypeSearcher.GsfTypeDescriptor> getDeclaredTypes(Index index, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, TypeSearcher.Helper helper) {
        Set<IndexedElement> set;
        JsIndex jsIndex = JsIndex.get(index);
        if (jsIndex == null) {
            return Collections.emptySet();
        }
        if ((nameKind = this.adjustKind(nameKind, string)) == NameKind.CASE_INSENSITIVE_PREFIX) {
            string = string.toLowerCase();
        }
        HashSet<JsTypeDescriptor> hashSet = new HashSet<JsTypeDescriptor>();
        int n = string.lastIndexOf(46);
        if (n != -1 && (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX)) {
            String string2 = string.substring(n + 1);
            String object = string.substring(0, n);
            set = jsIndex.getElements(string2, object, nameKind, enumSet, null);
        } else {
            set = jsIndex.getAllNames(string, nameKind, enumSet, null);
        }
        for (IndexedElement indexedElement : set) {
            hashSet.add(new JsTypeDescriptor(indexedElement, helper));
        }
        return hashSet;
    }

    public String getMimetype() {
        return "text/javascript";
    }

    private class JsTypeDescriptor
    extends TypeSearcher.GsfTypeDescriptor {
        private final IndexedElement element;
        private String projectName;
        private Icon projectIcon;
        private final TypeSearcher.Helper helper;
        private boolean isLibrary;
        private static final String ICON_PATH = "org/netbeans/modules/javascript/editing/javascript.png";

        public JsTypeDescriptor(IndexedElement indexedElement, TypeSearcher.Helper helper) {
            this.element = indexedElement;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                File file = FileUtil.toFile((FileObject)fileObject);
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    this.projectName = projectInformation.getDisplayName();
                    this.projectIcon = projectInformation.getIcon();
                }
            } else {
                this.isLibrary = true;
                Logger.getLogger(JsTypeSearcher.class.getName()).fine("No fileobject for " + this.element.toString() + " with fileurl=" + this.element.getFilenameUrl());
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            if (this.isLibrary) {
                return new ImageIcon(Utilities.loadImage((String)ICON_PATH));
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            CompilationInfo[] compilationInfoArray = new CompilationInfo[1];
            Node node = AstUtilities.getForeignNode(this.element, compilationInfoArray);
            if (node != null) {
                int n = AstUtilities.getRange(node).getStart();
                int n2 = LexUtilities.getLexerOffset(compilationInfoArray[0], n);
                if (n2 == -1) {
                    n2 = 0;
                }
                NbUtilities.open(this.element.getFileObject(), n2, this.element.getName());
                return;
            }
            FileObject fileObject = this.element.getFileObject();
            if (fileObject == null) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JsTypeSearcher.class, (String)"FileDeleted"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.helper.open(fileObject, (ElementHandle)this.element);
        }

        public String getContextName() {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string = this.element.getIn() != null ? this.element.getIn() + "." + this.element.getName() : this.element.getName();
            if (this.element.getName().equals(string)) {
                string = null;
            }
            if (string != null) {
                stringBuilder.append(" (");
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }
    }
}

