/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Node;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.CodeStyle;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsPretty {
    private final CompilationInfo info;
    private final BaseDocument doc;
    private final TokenSequence<? extends JsTokenId> ts;
    private final int begin;
    private final int end;
    private final LinkedList<Diff> diffs = new LinkedList();
    private int indent;
    private int lastHandledOffset = -1;
    private final int indentSize;
    private final int continuationIndentSize;
    private final int tabSize;
    private Stack<StackItem> stack = new Stack();
    private boolean isIncreasingLine = false;

    public JsPretty(CompilationInfo compilationInfo, BaseDocument baseDocument, int n, int n2, CodeStyle codeStyle) {
        this.info = compilationInfo;
        this.doc = baseDocument;
        this.begin = n;
        this.end = n2;
        this.ts = LexUtilities.getPositionedSequence(this.doc, 0, false);
        this.indentSize = codeStyle.getIndentSize();
        this.continuationIndentSize = codeStyle.getContinuationIndentSize();
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        this.tabSize = preferences.getInt("spaces-per-tab", 4);
    }

    public void format() {
        JsParseResult jsParseResult = AstUtilities.getParseResult(this.info);
        Node node = jsParseResult.getRootNode();
        if (node != null) {
            this.walk(node);
        }
        this.acceptNode(null);
    }

    private void walk(Node node) {
        if (this.ignoredType(node.getType())) {
            return;
        }
        this.acceptNode(node);
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            switch (node.getType()) {
                case 125: {
                    if (node2.getType() == 7) {
                        this.visitIf(node);
                        break;
                    }
                    this.visitOtherBlock(node);
                    break;
                }
                case 128: {
                    JsTokenId jsTokenId = (JsTokenId)this.ts.token().id();
                    if (jsTokenId == JsTokenId.WHILE) {
                        this.visitWhile(node);
                        break;
                    }
                    if (jsTokenId == JsTokenId.FOR) {
                        this.visitOtherBlock(node);
                        break;
                    }
                    if (node2.getType() == 118) {
                        this.visitOtherBlock(node);
                        break;
                    }
                    this.visitDefault(node);
                    break;
                }
                case 130: {
                    this.visitContinuation(node);
                    break;
                }
                case 111: 
                case 112: {
                    this.visitCase(node);
                    break;
                }
                case 110: {
                    this.visitOtherBlock(node);
                    break;
                }
                case 64: {
                    this.visitObjectLit(node);
                    break;
                }
                case 119: {
                    this.visitWith(node);
                    break;
                }
                case 77: {
                    this.visitBlockWithoutIndenting(node);
                    break;
                }
                case 120: {
                    this.visitCatch(node);
                    break;
                }
                default: {
                    this.visitDefault(node);
                }
            }
        }
    }

    private Node next(Node node) {
        if (node == null) {
            return null;
        }
        while ((node = node.getNext()) != null && this.ignoredType(node.getType())) {
        }
        return node;
    }

    private boolean ignoredType(int n) {
        switch (n) {
            case 5: 
            case 127: 
            case 131: 
            case 157: {
                return true;
            }
        }
        return false;
    }

    private void visitDefault(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.walk(node2);
                node2 = this.next(node2);
            }
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitContinuation(Node node) {
        this.increaseContinuation("visitContinuation " + node);
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.walk(node2);
                node2 = this.next(node2);
            }
        }
        this.decreaseContinuation("visitContinuation");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitObjectLit(Node node) {
        this.increaseIndent("visitObjectLit");
        if (node.hasChildren()) {
            boolean bl = true;
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getType() == 157) {
                    if (bl) {
                        bl = false;
                    } else {
                        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(this.doc, node2.getSourceStart());
                        tokenSequence.movePrevious();
                        Token<? extends JsTokenId> token = LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                        if (token.id() != JsTokenId.EOL) {
                            this.addDiff(node2.getSourceStart(), node2.getSourceStart(), "\n" + this.getIndent(), "visitObjectLit");
                        }
                    }
                }
                this.walk(node2);
            }
        }
        this.decreaseIndent("visitObjectLit");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitOtherBlock(Node node) {
        if (node.hasChildren()) {
            this.increaseIndent("visitOtherBlock");
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getSourceEnd() - node2.getSourceStart() > 0) {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
            this.decreaseIndent("visitOtherBlock");
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitBlockWithoutIndenting(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                this.walk(node2);
                node2 = this.next(node2);
            }
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitCatch(Node node) {
        this.increaseIndent("visitCatch");
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getType() == 125) {
                    this.visitBlockWithoutIndenting(node2);
                } else {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
        }
        this.decreaseIndent("visitCatch");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitWith(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getType() == 125) {
                    this.visitBlockWithoutIndenting(node2);
                } else {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
        }
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitCase(Node node) {
        this.increaseIndent("visitCase");
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getType() == 125) {
                    this.visitBlockWithoutIndenting(node2);
                } else {
                    this.walk(node2);
                }
                node2 = this.next(node2);
            }
        }
        this.decreaseIndent("visitCase");
        this.acceptOffset(node.getSourceEnd());
    }

    private void visitWhile(Node node) {
        Node node2 = node.getFirstChild();
        if (this.ignoredType(node2.getType())) {
            this.walk(node2);
            node2 = this.next(node2);
        }
        if (this.isWithoutBlock(node2)) {
            this.increaseIndent("visitWhile");
            this.walk(node2);
            this.decreaseIndent("visitWhile");
            node2 = this.next(node2);
        }
        while (node2 != null) {
            this.walk(node2);
            node2 = this.next(node2);
        }
    }

    private void visitIf(Node node) {
        Node node2 = node.getFirstChild();
        assert (node2.getType() == 7);
        this.walk(node2);
        node2 = this.next(node2);
        if (this.isWithoutBlock(node2)) {
            this.increaseIndent("visitIf 1");
            this.walk(node2);
            this.decreaseIndent("visitIf 1 after " + node2);
            node2 = this.next(node2);
        } else {
            this.walk(node2);
            node2 = this.next(node2);
        }
        if (node2 != null && node2.getType() != 125) {
            this.acceptToken(JsTokenId.ELSE);
            this.increaseIndent("visitIf 2");
            this.walk(node2);
            this.decreaseIndent("visitIf 2");
            node2 = this.next(node2);
        }
        while (node2 != null) {
            this.walk(node2);
            node2 = this.next(node2);
        }
    }

    private void acceptNode(Node node) {
        if (node == null) {
            node = new Node(-1);
        } else {
            if (node.getType() == 47 && node.getSourceEnd() > this.ts.offset()) {
                this.acceptOffset(node.getSourceStart());
                this.ts.move(node.getSourceEnd());
                this.ts.moveNext();
                return;
            }
            if (node.getSourceStart() < this.ts.offset()) {
                return;
            }
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                if (node.getSourceStart() > node2.getSourceStart()) {
                    return;
                }
                if (node.getType() == 37) {
                    return;
                }
            }
        }
        int n = node.getSourceStart();
        do {
            Token token = this.ts.token();
            int n2 = this.ts.offset();
            if (n2 >= n) {
                if (token.id() != JsTokenId.EOL && token.id() != JsTokenId.LBRACE) {
                    this.handleToken((Token<? extends JsTokenId>)token, "1 acceptToken(" + node + ")");
                }
                return;
            }
            this.handleToken((Token<? extends JsTokenId>)token, "2 acceptToken(" + node + ")");
        } while (this.ts.moveNext());
    }

    private void acceptOffset(int n) {
        do {
            Token token = this.ts.token();
            int n2 = this.ts.offset();
            if (n2 >= n) {
                if (token.id() != JsTokenId.EOL && token.id() != JsTokenId.LBRACE) {
                    this.handleToken((Token<? extends JsTokenId>)token, "1 acceptToken(" + n + ")");
                }
                return;
            }
            this.handleToken((Token<? extends JsTokenId>)token, "2 acceptOffset(" + n + ")");
        } while (this.ts.moveNext());
    }

    private void acceptToken(JsTokenId jsTokenId) {
        do {
            Token token;
            JsTokenId jsTokenId2;
            if ((jsTokenId2 = (JsTokenId)(token = this.ts.token()).id()) == jsTokenId) {
                if (token.id() != JsTokenId.EOL && token.id() != JsTokenId.LBRACE) {
                    this.handleToken((Token<? extends JsTokenId>)token, "1 acceptToken(" + (Object)((Object)jsTokenId) + ")");
                }
                this.ts.moveNext();
                return;
            }
            this.handleToken((Token<? extends JsTokenId>)token, "2 acceptToken(" + (Object)((Object)jsTokenId) + ")");
        } while (this.ts.moveNext());
    }

    private void handleToken(Token<? extends JsTokenId> token, String string) {
        int n = this.ts.offset();
        if (n <= this.lastHandledOffset) {
            return;
        }
        this.lastHandledOffset = n;
        JsTokenId jsTokenId = (JsTokenId)token.id();
        int n2 = token.length();
        switch (jsTokenId) {
            case WHITESPACE: {
                if (n != 0) break;
                this.addDiff(n, n + n2, "", "handleToken WHITESPACE");
                break;
            }
            case EOL: {
                int n3 = n + n2;
                boolean bl = false;
                if (n3 < this.end) {
                    try {
                        int n4 = Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)n3);
                        if (n4 != -1) {
                            int n5 = n4 - n3;
                            TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(this.doc, n, false);
                            tokenSequence.moveNext();
                            Token<? extends JsTokenId> token2 = LexUtilities.findNextNonWsNonComment(tokenSequence);
                            String string2 = null;
                            if (this.indent > 0 && token2.id() == JsTokenId.LBRACE && !this.diffs.isEmpty()) {
                                bl = true;
                                string2 = this.diffs.getFirst().text;
                            } else {
                                string2 = this.getIndent();
                            }
                            this.addDiff(n3, n3 + n5, string2, "handleToken EOL - " + this.ts.offset());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
                if (bl) break;
                this.newLine("handleToken EOL");
                break;
            }
            case LPAREN: {
                this.increaseContinuation("handleToken LPAREN");
                break;
            }
            case RPAREN: {
                this.decreaseContinuation("handleToken RPAREN");
                break;
            }
            case LINE_COMMENT: 
            case BLOCK_COMMENT: {
                break;
            }
            case LBRACE: {
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(this.doc, n);
                tokenSequence.moveNext();
                Token<? extends JsTokenId> token3 = LexUtilities.findNext(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                int n6 = tokenSequence.offset();
                if (token3.id() == JsTokenId.EOL || token3.id() == JsTokenId.RBRACE) break;
                this.addDiff(n6, n6, "\n" + this.getIndent(), "handleToken LBRACE");
                this.newLine("handleToken LBRACE");
                break;
            }
            case RBRACE: {
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(this.doc, n);
                int n7 = tokenSequence.offset();
                tokenSequence.movePrevious();
                Token<? extends JsTokenId> token4 = LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
                if (token4.id() == JsTokenId.EOL || token4.id() == JsTokenId.LBRACE) break;
                boolean bl = false;
                this.addDiff(n7, n7, "\n" + this.getIndent(), "handleToken RBRACE");
                this.newLine("handleToken RBRACE");
                if (!bl) break;
                this.increaseIndent("handleToken RBRACE");
            }
        }
    }

    private boolean isWithoutBlock(Node node) {
        boolean bl = false;
        if (node.getType() == 125) {
            int n = this.ts.offset();
            this.ts.move(node.getSourceStart());
            this.ts.moveNext();
            if (this.ts.token().id() != JsTokenId.LBRACE) {
                bl = true;
            }
            this.ts.move(n);
            this.ts.moveNext();
        } else {
            bl = true;
        }
        return bl;
    }

    private void newLine(String string) {
        this.isIncreasingLine = false;
    }

    private void increase(int n, String string) {
        if (!this.stack.isEmpty() && this.isIncreasingLine) {
            this.stack.peek().tip = false;
            this.indent -= this.stack.peek().indent;
        }
        this.indent += n;
        this.stack.push(new StackItem(n));
        this.isIncreasingLine = true;
    }

    private void decrease(String string) {
        StackItem stackItem = this.stack.pop();
        if (this.isIncreasingLine) {
            this.indent -= stackItem.indent;
            assert (this.indent >= 0);
            if (!this.stack.isEmpty() && !this.stack.peek().tip) {
                this.stack.peek().tip = true;
                this.indent += this.stack.peek().indent;
            } else {
                this.isIncreasingLine = false;
            }
        } else if (stackItem.tip) {
            this.indent -= stackItem.indent;
            assert (this.indent >= 0);
        }
    }

    private void increaseIndent(String string) {
        this.increase(this.indentSize, string);
    }

    private void increaseContinuation(String string) {
        this.increase(this.continuationIndentSize, string);
    }

    private void decreaseIndent(String string) {
        this.decrease(string);
    }

    private void decreaseContinuation(String string) {
        this.decrease(string);
    }

    private String getIndent() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (!bl) {
            while (n + this.tabSize <= this.indent) {
                stringBuilder.append('\t');
                n += this.tabSize;
            }
        }
        while (n < this.indent) {
            stringBuilder.append(" ");
            ++n;
        }
        return stringBuilder.toString();
    }

    private void addDiff(int n, int n2, String string, String string2) {
        if (n < this.begin || n2 > this.end) {
            return;
        }
        if (n2 < this.doc.getLength()) {
            this.diffs.addFirst(new Diff(n, n2, string));
        }
    }

    LinkedList<Diff> getDiffs() {
        return this.diffs;
    }

    static class Diff {
        final int start;
        final int end;
        final String text;

        Diff(int n, int n2, String string) {
            this.start = n;
            this.end = n2;
            this.text = string;
        }

        public String toString() {
            return "Diff<" + this.start + "," + this.end + ">: [" + this.text + "]";
        }
    }

    private class StackItem {
        int indent;
        boolean tip = true;

        StackItem(int n) {
            this.indent = n;
        }

        public String toString() {
            return "[" + this.indent + "," + this.tip + "]";
        }
    }
}

