/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Language;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.KeystrokeHandler;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsf.spi.DefaultLanguageConfig;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsCodeCompletion;
import org.netbeans.modules.javascript.editing.JsDeclarationFinder;
import org.netbeans.modules.javascript.editing.JsFormatter;
import org.netbeans.modules.javascript.editing.JsIndexer;
import org.netbeans.modules.javascript.editing.JsKeystrokeHandler;
import org.netbeans.modules.javascript.editing.JsOccurrenceFinder;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.JsRenameHandler;
import org.netbeans.modules.javascript.editing.JsSemanticAnalyzer;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsLanguage
extends DefaultLanguageConfig {
    private FileObject jsStubsFO;

    public String getLineCommentPrefix() {
        return JsUtils.getLineCommentPrefix();
    }

    public boolean isIdentifierChar(char c) {
        return JsUtils.isIdentifierChar(c);
    }

    public Language getLexerLanguage() {
        return JsTokenId.language();
    }

    public Collection<FileObject> getCoreLibraries() {
        return Collections.singletonList(this.getJsStubs());
    }

    private FileObject getJsStubs() {
        if (this.jsStubsFO == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-javascript-editing.jar", null, false);
            if (file != null) {
                File file2 = new File(file.getParentFile().getParentFile().getAbsoluteFile(), "jsstubs");
                assert (file2.exists() && file2.isDirectory()) : "No stubs found";
                this.jsStubsFO = FileUtil.toFileObject((File)file2);
            } else {
                String string = System.getProperty("xtest.js.home");
                if (string == null) {
                    throw new RuntimeException("xtest.js.home property has to be set when running within binary distribution");
                }
                File file3 = new File(string + File.separator + "jsstubs");
                if (file3.exists()) {
                    this.jsStubsFO = FileUtil.toFileObject((File)file3);
                }
            }
        }
        return this.jsStubsFO;
    }

    public String getDisplayName() {
        return "JavaScript";
    }

    public String getPreferredExtension() {
        return "js";
    }

    public Map<String, String> getSourceGroupNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("RubyProject", "ruby");
        hashMap.put("RailsProject", "ruby");
        hashMap.put("WebProject", "java");
        return hashMap;
    }

    public KeystrokeHandler getKeystrokeHandler() {
        return new JsKeystrokeHandler();
    }

    public boolean hasFormatter() {
        return true;
    }

    public Formatter getFormatter() {
        return new JsFormatter();
    }

    public Parser getParser() {
        return new JsParser();
    }

    public CodeCompletionHandler getCompletionHandler() {
        return new JsCodeCompletion();
    }

    public boolean hasStructureScanner() {
        return true;
    }

    public StructureScanner getStructureScanner() {
        return new JsAnalyzer();
    }

    public Indexer getIndexer() {
        return new JsIndexer();
    }

    public DeclarationFinder getDeclarationFinder() {
        return new JsDeclarationFinder();
    }

    public SemanticAnalyzer getSemanticAnalyzer() {
        return new JsSemanticAnalyzer();
    }

    public boolean hasOccurrencesFinder() {
        return true;
    }

    public OccurrencesFinder getOccurrencesFinder() {
        return new JsOccurrenceFinder();
    }

    public InstantRenamer getInstantRenamer() {
        return new JsRenameHandler();
    }
}

