/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.javascript.editing.ClassCache;
import org.netbeans.modules.javascript.editing.DuplicateElementSet;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.IndexedFunction;
import org.netbeans.modules.javascript.editing.IndexedPackage;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.Pair;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsIndex {
    static int MAX_SEARCH_ITEMS = 120;
    private static final boolean ALL_REACHABLE = !Boolean.getBoolean("javascript.checkincludes");
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";
    public static final Set<Index.SearchScope> ALL_SCOPE = EnumSet.allOf(Index.SearchScope.class);
    public static final Set<Index.SearchScope> SOURCE_SCOPE = EnumSet.of(Index.SearchScope.SOURCE);
    private static final Set<String> TERMS_FQN = Collections.singleton("fqn");
    private static final Set<String> TERMS_BASE = Collections.singleton("base");
    private static final Set<String> TERMS_EXTEND = Collections.singleton("extend");
    private final Index index;

    public JsIndex(Index index) {
        this.index = index;
    }

    public static JsIndex get(Index index) {
        return new JsIndex(index);
    }

    private boolean search(String string, String string2, NameKind nameKind, Set<Index.SearchResult> set, Set<Index.SearchScope> set2, Set<String> set3) {
        try {
            this.index.search(string, string2, nameKind, set2, set, set3);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        String string2 = JsIndex.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(CLUSTER_URL)) {
                string = JsIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            return URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-javascript-editing.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    public Pair<Set<IndexedElement>, Boolean> getConstructors(String string, NameKind nameKind, Set<Index.SearchScope> set) {
        return this.getUnknownFunctions(string, nameKind, set, true, null, true, false);
    }

    public Set<IndexedElement> getAllNames(String string, NameKind nameKind, Set<Index.SearchScope> set, JsParseResult jsParseResult) {
        return this.getUnknownFunctions(string, nameKind, set, false, jsParseResult, true, true).getA();
    }

    public Pair<Set<IndexedElement>, Boolean> getAllNamesTruncated(String string, NameKind nameKind, Set<Index.SearchScope> set, JsParseResult jsParseResult) {
        return this.getUnknownFunctions(string, nameKind, set, false, jsParseResult, true, true);
    }

    public Map<String, String> getAllExtends() {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search("extend", "", NameKind.CASE_INSENSITIVE_PREFIX, hashSet, ALL_SCOPE, TERMS_EXTEND);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray = searchResult.getValues("extend");
            if (stringArray == null) continue;
            for (String string : stringArray) {
                int n = string.indexOf(59) + 1;
                int n2 = string.indexOf(59, n) + 1;
                String string2 = string.substring(n, n2 - 1);
                String string3 = string.substring(n2);
                hashMap.put(string2, string3);
            }
        }
        return hashMap;
    }

    public String getExtends(String string, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search("extend", string.toLowerCase(), NameKind.CASE_INSENSITIVE_PREFIX, hashSet, set, TERMS_EXTEND);
        String string2 = string.toLowerCase() + ";";
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray = searchResult.getValues("extend");
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                int n;
                int n2;
                if (!string3.startsWith(string2) || !string.equals(string3.substring(n2 = string2.length(), n = string3.indexOf(59, n2)))) continue;
                return string3.substring(n + 1);
            }
        }
        return null;
    }

    public Set<IndexedElement> getElements(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set, JsParseResult jsParseResult) {
        return this.getByFqn(string, string2, nameKind, set, false, jsParseResult, true, true, false);
    }

    public Set<IndexedElement> getElementsByFqn(String string, NameKind nameKind, Set<Index.SearchScope> set, JsParseResult jsParseResult) {
        String string2 = string;
        int n = string2.lastIndexOf(46);
        String string3 = null;
        if (n != -1) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        return this.getByFqn(string2, string3, nameKind, set, false, jsParseResult, true, true, false);
    }

    public Set<IndexedElement> getAllElements(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set, JsParseResult jsParseResult) {
        return this.getByFqn(string, string2, nameKind, set, false, jsParseResult, true, true, true);
    }

    public Set<IndexedFunction> getFunctions(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set, JsParseResult jsParseResult, boolean bl) {
        return this.getByFqn(string, string2, nameKind, set, false, jsParseResult, bl, false, false);
    }

    private Pair<Set<IndexedElement>, Boolean> getUnknownFunctions(String string, NameKind nameKind, Set<Index.SearchScope> set, boolean bl, JsParseResult jsParseResult, boolean bl2, boolean bl3) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string2 = "base";
        Set<String> set2 = TERMS_BASE;
        NameKind nameKind2 = nameKind;
        if (nameKind == NameKind.EXACT_NAME) {
            nameKind = NameKind.PREFIX;
        }
        String string3 = string.toLowerCase();
        this.search(string2, string3, nameKind, hashSet, set, set2);
        HashSet<IndexedElement> hashSet2 = new HashSet<IndexedElement>();
        String string4 = null;
        if (jsParseResult != null) {
            try {
                string4 = jsParseResult.getFile().getFileObject().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray = searchResult.getValues(string2);
            if (stringArray == null) continue;
            if (jsParseResult != null) {
                String string5 = searchResult.getPersistentUrl();
                if (string4 == null || !string4.equals(string5)) {
                    int n;
                    int n2 = n = string5.indexOf("jsstubs") != -1 ? 1 : 0;
                    if (n == 0 && !this.isReachable(jsParseResult, string5)) continue;
                }
            }
            for (String string6 : stringArray) {
                block24: {
                    if (nameKind == NameKind.PREFIX && !string6.startsWith(string3) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string6.regionMatches(true, 0, string3, 0, string3.length())) continue;
                    if (nameKind == NameKind.CASE_INSENSITIVE_REGEXP) {
                        int n = string6.indexOf(59);
                        assert (n != -1);
                        String string7 = string6.substring(0, n);
                        try {
                            if (!string7.matches(string3)) {
                                continue;
                            }
                            break block24;
                        }
                        catch (Exception exception) {
                            break block24;
                        }
                    }
                    if (nameKind2 == NameKind.EXACT_NAME && string6.length() > string3.length() && string6.charAt(string3.length()) != ';') continue;
                }
                assert (searchResult != null);
                String string8 = null;
                int n = string6.indexOf(59);
                assert (n != -1);
                string8 = string6.substring(0, n);
                String string9 = null;
                int n3 = string6.indexOf(59, ++n);
                assert (n3 != -1);
                if (n3 > n + 1) {
                    string9 = string6.substring(n, n3);
                }
                int n4 = ++n3;
                n3 = string6.indexOf(59, n4);
                assert (n3 != -1);
                if (n3 > n4) {
                    string8 = string6.substring(n4, n3);
                    if (nameKind == NameKind.PREFIX && !string8.startsWith(string) || nameKind == NameKind.EXACT_NAME && !string8.equals(string)) continue;
                }
                ++n3;
                if (!bl2 && string9 != null) continue;
                String string10 = null;
                IndexedElement indexedElement = IndexedElement.create(string6, searchResult.getPersistentUrl(), string10, string8, string9, n3, this, false);
                boolean bl4 = indexedElement instanceof IndexedFunction;
                if (bl4 && !bl2) continue;
                if (bl) {
                    if (indexedElement.getKind() == ElementKind.PROPERTY && string9 == null && Character.isUpperCase(string8.charAt(0))) {
                        indexedElement.setKind(ElementKind.CONSTRUCTOR);
                    } else if (indexedElement.getKind() != ElementKind.CONSTRUCTOR) {
                        continue;
                    }
                } else if (!bl4 && !bl3) continue;
                hashSet2.add(indexedElement);
                if (hashSet2.size() != MAX_SEARCH_ITEMS) continue;
                return new Pair<Set<IndexedElement>, Boolean>(hashSet2, true);
            }
        }
        return new Pair<Set<IndexedElement>, Boolean>(hashSet2, false);
    }

    private Set<IndexedElement> getByFqn(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set, boolean bl, JsParseResult jsParseResult, boolean bl2, boolean bl3, boolean bl4) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string3 = "fqn";
        Set<String> set2 = TERMS_FQN;
        NameKind nameKind2 = nameKind;
        if (nameKind == NameKind.EXACT_NAME) {
            nameKind = NameKind.PREFIX;
        }
        if (nameKind == NameKind.CASE_INSENSITIVE_PREFIX || nameKind == NameKind.CASE_INSENSITIVE_REGEXP) {
            // empty if block
        }
        Set<IndexedElement> set3 = bl4 ? new DuplicateElementSet() : new HashSet();
        String string4 = null;
        if (jsParseResult != null) {
            try {
                string4 = jsParseResult.getFile().getFileObject().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(string2);
        boolean bl5 = false;
        boolean bl6 = string2 == null;
        while (true) {
            String string5 = string2 != null && string2.length() > 0 ? string2 + "." + string : string;
            String string6 = string5.toLowerCase();
            this.search(string3, string6, nameKind, hashSet, set, set2);
            for (Index.SearchResult searchResult : hashSet) {
                String[] stringArray = searchResult.getValues(string3);
                if (stringArray == null) continue;
                if (jsParseResult != null) {
                    String string7 = searchResult.getPersistentUrl();
                    if (string4 == null || !string4.equals(string7)) {
                        int n;
                        int n2 = n = string7.indexOf("jsstubs") != -1 ? 1 : 0;
                        if (n == 0 && !this.isReachable(jsParseResult, string7)) continue;
                    }
                }
                for (String string8 : stringArray) {
                    int n;
                    block32: {
                        if (nameKind == NameKind.PREFIX && !string8.startsWith(string6) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string8.regionMatches(true, 0, string6, 0, string6.length())) continue;
                        if (nameKind == NameKind.CASE_INSENSITIVE_REGEXP) {
                            int n3 = string8.indexOf(59);
                            assert (n3 != -1);
                            String string9 = string8.substring(0, n3);
                            try {
                                if (!string9.matches(string6)) {
                                    continue;
                                }
                                break block32;
                            }
                            catch (Exception exception) {
                                break block32;
                            }
                        }
                        if (nameKind2 == NameKind.EXACT_NAME && string8.length() > string6.length() && string8.charAt(string6.length()) != ';') continue;
                    }
                    assert (searchResult != null);
                    String string10 = null;
                    int n4 = string8.indexOf(59);
                    assert (n4 != -1) : string8;
                    string10 = string8.substring(0, n4);
                    String string11 = null;
                    int n5 = string8.indexOf(59, ++n4);
                    assert (n5 != -1) : string8;
                    int n6 = ++n5;
                    n5 = string8.indexOf(59, n6);
                    assert (n5 != -1);
                    if (n5 > n6) {
                        string10 = string8.substring(n6, n5);
                        if (nameKind == NameKind.PREFIX && !string10.startsWith(string5) || nameKind == NameKind.EXACT_NAME && !string10.equals(string5)) continue;
                    }
                    ++n5;
                    int n7 = string10.lastIndexOf(46);
                    IndexedElement indexedElement = null;
                    if (string.length() < n7) {
                        n = string10.indexOf(46, string5.length());
                        if (n != -1) {
                            String string12;
                            int n8 = IndexedElement.decode(string8, n5, 0);
                            ElementKind elementKind = ElementKind.PACKAGE;
                            int n9 = string10.indexOf(46, n + 1);
                            if (n9 == -1) {
                                elementKind = ElementKind.CLASS;
                            }
                            if (string2 != null && string2.length() > 0) {
                                string12 = string10.substring(string2.length() + 1, n);
                                indexedElement = new IndexedPackage(null, string12, null, this, searchResult.getPersistentUrl(), string8, n8, elementKind);
                            } else {
                                string12 = string10.substring(0, n);
                                indexedElement = new IndexedPackage(null, string12, null, this, searchResult.getPersistentUrl(), string8, n8, elementKind);
                            }
                        } else {
                            string11 = string10.substring(0, n7);
                            string10 = string10.substring(n7 + 1);
                        }
                    } else if (n7 != -1) {
                        string11 = string10.substring(0, n7);
                        string10 = string10.substring(n7 + 1);
                    }
                    if (indexedElement == null) {
                        indexedElement = IndexedElement.create(string8, searchResult.getPersistentUrl(), null, string10, string11, n5, this, false);
                    }
                    if ((n = indexedElement instanceof IndexedFunction) != 0 && !bl2 || n == 0 && !bl3 || bl && indexedElement.getKind() != ElementKind.CONSTRUCTOR) continue;
                    if (!bl5) {
                        indexedElement.setSmart(true);
                    }
                    if (!bl6) {
                        indexedElement.setInherited(false);
                    }
                    set3.add(indexedElement);
                }
            }
            if (string2 == null || "Object".equals(string2)) break;
            if ((string2 = this.getExtends(string2, set)) == null) {
                string2 = "Object";
                bl5 = true;
            }
            if (hashSet2.contains(string2)) break;
            hashSet2.add(string2);
            bl6 = true;
        }
        return set3;
    }

    public String getType(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return this.getSimpleType(string);
        }
        String string2 = string.substring(0, n);
        List<String> list = ClassCache.INSTANCE.getAncestors(string2, this);
        if (list.size() <= 1) {
            return this.getSimpleType(string);
        }
        String string3 = string.substring(n + 1);
        int n2 = string3.length();
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string4 = "base";
        Set<String> set = TERMS_BASE;
        String string5 = string3.toLowerCase();
        assert (string5.length() == n2);
        this.search(string4, string5, NameKind.PREFIX, hashSet, ALL_SCOPE, set);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray = searchResult.getValues(string4);
            if (stringArray == null) continue;
            for (String string6 : stringArray) {
                if (!string6.startsWith(string5) || string6.charAt(n2) != ';') continue;
                assert (string6.charAt(n2) == ';');
                int n3 = n2 + 1;
                int n4 = string6.indexOf(59, n3);
                if (n4 == n3) continue;
                String string7 = string6.substring(n3, n4);
                for (String string8 : list) {
                    String string9;
                    if (!string8.equals(string7) || (string9 = JsIndex.getTypeInSignature(string6)) == null) continue;
                    return string9;
                }
            }
        }
        return null;
    }

    private static String getTypeInSignature(String string) {
        int n;
        int n2 = 0;
        int n3 = 8;
        for (n = 0; n < n3; ++n) {
            n2 = string.indexOf(59, n2 + 1);
        }
        if ((n = string.indexOf(59, ++n2)) > n2) {
            return string.substring(n2, n);
        }
        return null;
    }

    private String getSimpleType(String string) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string2 = "fqn";
        Set<String> set = TERMS_BASE;
        String string3 = string.toLowerCase();
        int n = string.length();
        this.search(string2, string3, NameKind.PREFIX, hashSet, ALL_SCOPE, set);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray = searchResult.getValues(string2);
            if (stringArray == null) continue;
            for (String string4 : stringArray) {
                String string5;
                if (!string4.startsWith(string3) || string4.charAt(n) != ';' || (string5 = JsIndex.getTypeInSignature(string4)) == null) continue;
                return string5;
            }
        }
        return null;
    }

    public boolean isReachable(JsParseResult jsParseResult, String string) {
        if (ALL_REACHABLE) {
            return true;
        }
        List<String> list = jsParseResult.getStructure().getImports();
        if (list.size() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string2 = list.get(i);
                if (string2.indexOf("../") != -1 && (string2 = string2.substring((n2 = string2.lastIndexOf("../")) + 3)).length() == 0 || !string.endsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

