/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Formatter;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.CodeStyle;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsPretty;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsFormatter
implements Formatter {
    private boolean embeddedJavaScript;
    private CodeStyle codeStyle;
    private int rightMarginOverride = -1;
    private int embeddededIndent = 0;
    private Stack<StackItem> stack = new Stack();

    public JsFormatter() {
        this.codeStyle = new DocSyncedCodeStyle();
    }

    public JsFormatter(CodeStyle codeStyle, int n) {
        assert (codeStyle != null);
        this.codeStyle = codeStyle;
        this.rightMarginOverride = n;
    }

    public boolean needsParserResult() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reformat(Document document, int n, int n2, CompilationInfo compilationInfo) {
        JsParseResult jsParseResult = null;
        if (compilationInfo != null) {
            jsParseResult = AstUtilities.getParseResult(compilationInfo);
        }
        if (jsParseResult == null || jsParseResult.getRootNode() == null || !JsUtils.isJsOrJsonDocument(document)) {
            this.reindent(document, n, n2, null, false);
            return;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        JsFormatter.syncOptions(baseDocument, this.codeStyle);
        JsPretty jsPretty = new JsPretty(compilationInfo, baseDocument, n, n2, this.codeStyle);
        jsPretty.format();
        try {
            baseDocument.atomicLock();
            for (JsPretty.Diff diff : jsPretty.getDiffs()) {
                baseDocument.remove(diff.start, diff.end - diff.start);
                baseDocument.insertString(diff.start, diff.text, null);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    public void reindent(Document document, int n, int n2) {
        this.reindent(document, n, n2, null, true);
    }

    public int indentSize() {
        return -1;
    }

    public int hangingIndentSize() {
        return -1;
    }

    private int getFormatStableStart(BaseDocument baseDocument, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious()) {
            return 0;
        }
        do {
            Token token;
            TokenId tokenId;
            if ((tokenId = (token = tokenSequence.token()).id()) != JsTokenId.FUNCTION) continue;
            return tokenSequence.offset();
        } while (tokenSequence.movePrevious());
        if (this.embeddedJavaScript && !tokenSequence.movePrevious()) {
            int n2 = tokenSequence.offset();
            try {
                int n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n3 == -1 || n2 > n3) {
                    return Math.min(baseDocument.getLength(), Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2) + 1);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return tokenSequence.offset();
    }

    private int getBracketBalanceDelta(TokenId tokenId) {
        if (tokenId == JsTokenId.LPAREN || tokenId == JsTokenId.LBRACKET) {
            return 1;
        }
        if (tokenId == JsTokenId.RPAREN || tokenId == JsTokenId.RBRACKET) {
            return -1;
        }
        return 0;
    }

    private int getTokenBalanceDelta(TokenId tokenId, BaseDocument baseDocument, TokenSequence<? extends JsTokenId> tokenSequence, boolean bl) {
        block23: {
            try {
                TokenSequence<? extends JsTokenId> tokenSequence2;
                OffsetRange offsetRange = OffsetRange.NONE;
                if (tokenId == JsTokenId.LBRACKET || tokenId == JsTokenId.LBRACE) {
                    this.stack.push(new StackItem(false, new OffsetRange(tokenSequence.offset(), tokenSequence.offset())));
                    return 1;
                }
                if (tokenId == JsTokenId.CASE || tokenId == JsTokenId.DEFAULT) {
                    int n = tokenSequence.index();
                    LexUtilities.findNextIncluding(tokenSequence, Collections.singletonList(JsTokenId.COLON));
                    Token<? extends JsTokenId> token = LexUtilities.findNextNonWsNonComment(tokenSequence);
                    JsTokenId jsTokenId = (JsTokenId)token.id();
                    if (jsTokenId == JsTokenId.CASE || jsTokenId == JsTokenId.DEFAULT) {
                        return 0;
                    }
                    if (jsTokenId == JsTokenId.RBRACE) {
                        return -1;
                    }
                    LexUtilities.findNextIncluding(tokenSequence, Collections.singletonList(JsTokenId.EOL));
                    LexUtilities.findNextNonWsNonComment(tokenSequence);
                    if (tokenSequence.token().id() == JsTokenId.CASE || tokenSequence.token().id() == JsTokenId.DEFAULT) {
                        return 0;
                    }
                    tokenSequence.moveIndex(n);
                    tokenSequence.moveNext();
                    return 1;
                }
                if (tokenId == JsTokenId.RBRACKET || tokenId == JsTokenId.RBRACE) {
                    StackItem stackItem;
                    int n = -1;
                    StackItem stackItem2 = stackItem = this.stack.empty() ? null : this.stack.pop();
                    if (stackItem != null && stackItem.range.getStart() <= baseDocument.getLength() + 1 && Utilities.getLineOffset((BaseDocument)baseDocument, (int)stackItem.range.getStart()) != Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset())) {
                        int n2 = 0;
                        while (!this.stack.empty() && this.stack.pop().braceless) {
                            ++n2;
                        }
                        n -= n2;
                    }
                    return n;
                }
                offsetRange = LexUtilities.getMultilineRange(baseDocument, tokenSequence);
                if (offsetRange != OffsetRange.NONE) {
                    this.stack.push(new StackItem(true, offsetRange));
                    break block23;
                }
                if (tokenId != JsTokenId.EOL) break block23;
                if (!bl) {
                    Token<? extends JsTokenId> token;
                    JsTokenId jsTokenId;
                    tokenSequence2 = LexUtilities.getPositionedSequence(baseDocument, tokenSequence.offset());
                    Token<? extends JsTokenId> token2 = LexUtilities.findNextNonWsNonComment(tokenSequence2);
                    JsTokenId jsTokenId2 = jsTokenId = token2 == null ? null : (JsTokenId)token2.id();
                    if (jsTokenId == JsTokenId.RBRACE) {
                        token = LexUtilities.findBwd(baseDocument, tokenSequence2, JsTokenId.LBRACE, JsTokenId.RBRACE);
                        if (token != OffsetRange.NONE) {
                            tokenSequence2.movePrevious();
                            if (LexUtilities.skipParenthesis(tokenSequence2, true)) {
                                Token<? extends JsTokenId> token3 = tokenSequence2.token();
                                token3 = LexUtilities.findPreviousNonWsNonComment(tokenSequence2);
                                if (token3.id() == JsTokenId.SWITCH) {
                                    return -1;
                                }
                            }
                        }
                    } else if ((jsTokenId == JsTokenId.CASE || jsTokenId == JsTokenId.DEFAULT) && (token = LexUtilities.findPreviousNonWsNonComment(tokenSequence2 = LexUtilities.getPositionedSequence(baseDocument, tokenSequence.offset()))).id() != JsTokenId.LBRACE) {
                        int n;
                        tokenSequence2 = LexUtilities.getPositionedSequence(baseDocument, tokenSequence.offset());
                        token = LexUtilities.findPreviousIncluding(tokenSequence2, Arrays.asList(JsTokenId.CASE, JsTokenId.DEFAULT));
                        int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence2.offset());
                        if (n3 != (n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset()))) {
                            return -1;
                        }
                    }
                }
                if (this.stack.empty() || !this.stack.peek().braceless) break block23;
                tokenSequence2 = this.stack.peek().range;
                if (tokenSequence2.containsInclusive(tokenSequence.offset())) {
                    int n;
                    if (bl) {
                        return 1;
                    }
                    int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence2.getEnd());
                    if (n4 == (n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset()))) {
                        return 1;
                    }
                    break block23;
                }
                int n = 0;
                while (!this.stack.empty() && this.stack.peek().braceless) {
                    ++n;
                    this.stack.pop();
                }
                return -n;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return 0;
    }

    private int getTokenBalance(TokenSequence<? extends JsTokenId> tokenSequence, BaseDocument baseDocument, int n, int n2, boolean bl, boolean bl2) {
        Token token;
        int n3 = 0;
        if (tokenSequence == null) {
            try {
                this.embeddededIndent = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        while ((token = tokenSequence.token()) != null) {
            TokenId tokenId = token.id();
            if (bl) {
                int n4 = this.getTokenBalanceDelta(tokenId, baseDocument, tokenSequence, bl2);
                n3 += n4;
            } else {
                n3 += this.getBracketBalanceDelta(tokenId);
            }
            if (tokenSequence.moveNext() && tokenSequence.offset() < n2) continue;
        }
        return n3;
    }

    private Token<? extends JsTokenId> getFirstToken(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            if (this.embeddedJavaScript) {
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n2);
                if (tokenSequence != null) {
                    tokenSequence.moveNext();
                    Token token = tokenSequence.token();
                    while (token != null && token.id() == JsTokenId.WHITESPACE) {
                        if (!tokenSequence.moveNext()) {
                            return null;
                        }
                        token = tokenSequence.token();
                    }
                    return token;
                }
            } else {
                return LexUtilities.getToken(baseDocument, n2);
            }
        }
        return null;
    }

    private int isEndIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            Token<? extends JsTokenId> token = this.getFirstToken(baseDocument, n);
            if (token == null) {
                return 0;
            }
            TokenId tokenId = token.id();
            if (tokenId == JsTokenId.RBRACE || tokenId == JsTokenId.RBRACKET || tokenId == JsTokenId.RPAREN) {
                int n3 = 1;
                int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                int n5 = n;
                while (n5 < n4 && token != null && ((n5 += token.length()) >= baseDocument.getLength() || (token = LexUtilities.getToken(baseDocument, n5)) == null || (tokenId = token.id()) == JsTokenId.WHITESPACE)) {
                }
                return n3;
            }
        }
        return 0;
    }

    private static boolean isLineContinued(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        Token token;
        if ((n = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) == -1) {
            return false;
        }
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        Token token2 = token = tokenSequence != null ? tokenSequence.token() : null;
        if (token != null) {
            boolean bl;
            TokenId tokenId = token.id();
            boolean bl2 = bl = tokenId == JsTokenId.NONUNARY_OP || tokenId == JsTokenId.DOT;
            if (tokenSequence.offset() == n && token.length() > 1 && ((Object)token.text()).toString().startsWith("\\")) {
                bl = true;
            }
            if (tokenId == JsTokenId.NONUNARY_OP && ",".equals(((Object)token.text()).toString())) {
                boolean bl3 = bl = n2 == 0;
            }
            if (tokenId == JsTokenId.COLON) {
                TokenSequence<? extends JsTokenId> tokenSequence2 = LexUtilities.getPositionedSequence(baseDocument, tokenSequence.offset());
                Token<? extends JsTokenId> token3 = LexUtilities.findPreviousIncluding(tokenSequence2, Arrays.asList(JsTokenId.CASE, JsTokenId.DEFAULT, JsTokenId.COLON));
                bl = token3 == null || token3.id() != JsTokenId.CASE && token3.id() != JsTokenId.DEFAULT;
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(Document document, int n, int n2, CompilationInfo compilationInfo, boolean bl) {
        this.embeddedJavaScript = !JsUtils.isJsOrJsonDocument(document);
        try {
            Token<? extends JsTokenId> token;
            BaseDocument baseDocument = (BaseDocument)document;
            if (bl && this.embeddedJavaScript && (token = LexUtilities.getToken(baseDocument, n)) == null) {
                return;
            }
            JsFormatter.syncOptions(baseDocument, this.codeStyle);
            if (n2 > baseDocument.getLength()) {
                n2 = baseDocument.getLength();
            }
            int n3 = n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n4 = 0;
            int n5 = 0;
            if (n > 0) {
                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n - 1));
                n4 = this.getFormatStableStart(baseDocument, n6);
                n5 = LexUtilities.getLineIndent(baseDocument, n4);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl2 = n != 0 || n2 != baseDocument.getLength();
            boolean bl3 = n2 == baseDocument.getLength() || bl;
            this.computeIndents(baseDocument, n5, n4, n2, compilationInfo, arrayList, arrayList2, bl2, bl3, bl);
            try {
                baseDocument.atomicLock();
                assert (arrayList2.size() == arrayList.size());
                org.netbeans.editor.Formatter formatter = baseDocument.getFormatter();
                for (int i = arrayList2.size() - 1; i >= 0; --i) {
                    int n7;
                    int n8 = (Integer)arrayList2.get(i);
                    int n9 = (Integer)arrayList.get(i);
                    if (n9 < n3) break;
                    if (n9 == n3 && i > 0) {
                        n7 = (Integer)arrayList.get(i - 1);
                        int n10 = (Integer)arrayList2.get(i - 1);
                        int n11 = LexUtilities.getLineIndent(baseDocument, n7);
                        if (n11 != n10 && (bl || !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n7) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n7))) {
                            n8 = n11 + (n8 - n10);
                        }
                    }
                    if ((n7 = LexUtilities.getLineIndent(baseDocument, n9)) == n8) continue;
                    formatter.changeRowIndent(baseDocument, n9, n8);
                }
                if (!bl && this.codeStyle.reformatComments()) {
                    this.reformatComments(baseDocument, n, n2);
                }
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public void computeIndents(BaseDocument baseDocument, int n, int n2, int n3, CompilationInfo compilationInfo, List<Integer> list, List<Integer> list2, boolean bl, boolean bl2, boolean bl3) {
        try {
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            int n5 = n3;
            int n6 = this.codeStyle.getIndentSize();
            int n7 = this.codeStyle.getContinuationIndentSize();
            int n8 = 0;
            int n9 = 0;
            boolean bl4 = false;
            int n10 = 0;
            int n11 = 0;
            while (!bl2 && n4 < n5 || bl2 && n4 <= n5) {
                int n12;
                int n13;
                int n14;
                if (this.embeddedJavaScript) {
                    n = this.embeddededIndent + n6;
                }
                int n15 = 0;
                int n16 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4);
                TokenSequence<? extends JsTokenId> tokenSequence = null;
                if (n16 != -1) {
                    tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n16, false);
                    if (tokenSequence != null) {
                        TokenId tokenId = tokenSequence.token().id();
                        if (tokenId == JsTokenId.BLOCK_COMMENT) {
                            if (tokenSequence.offset() == n16) {
                                n15 = 2;
                                n10 = LexUtilities.getLineIndent(baseDocument, n4);
                            } else {
                                n15 = 3;
                            }
                        } else if (tokenId == JsTokenId.NONUNARY_OP) {
                            bl4 = true;
                        } else if (tokenId == JsTokenId.STRING_LITERAL || tokenId == JsTokenId.STRING_END || tokenId == JsTokenId.REGEXP_LITERAL || tokenId == JsTokenId.REGEXP_END) {
                            n15 = 1;
                        }
                    } else {
                        n15 = 1;
                    }
                }
                int n17 = n14 = bl4 ? n7 : 0;
                if (n15 == 1) {
                    n13 = LexUtilities.getLineIndent(baseDocument, n4);
                } else if (n15 == 3) {
                    n13 = baseDocument.getText(n16, 1).charAt(0) == '*' ? n11 + 1 : LexUtilities.getLineIndent(baseDocument, n4);
                } else {
                    int n18 = this.isEndIndent(baseDocument, n4);
                    if (n18 > 0) {
                        n13 = (n8 - n18) * n6 + n14 + n;
                    } else {
                        assert (n15 == 0 || n15 == 2);
                        n13 = n8 * n6 + n14 + n;
                        if (n15 == 2) {
                            n11 = n13;
                        }
                    }
                }
                if (n13 < 0) {
                    n13 = 0;
                }
                if ((n12 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4)) != -1 || bl) {
                    list2.add(n13);
                    list.add(n4);
                }
                int n19 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4) + 1;
                if (n12 != -1) {
                    n8 += this.getTokenBalance(tokenSequence, baseDocument, n12, n19, true, bl3);
                    int n20 = this.getTokenBalance(tokenSequence, baseDocument, n12, n19, false, bl3);
                    bl4 = JsFormatter.isLineContinued(baseDocument, n4, n9 += n20);
                }
                n4 = n19;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    void reformatComments(BaseDocument baseDocument, int n, int n2) {
        int n3 = this.rightMarginOverride;
        if (n3 == -1) {
            CodeStyle codeStyle = this.codeStyle;
            if (codeStyle == null) {
                codeStyle = CodeStyle.getDefault(null);
            }
            n3 = codeStyle.getRightMargin();
        }
        throw new RuntimeException("Not yet implemented!");
    }

    private static void syncOptions(BaseDocument baseDocument, CodeStyle codeStyle) {
        if (codeStyle instanceof DocSyncedCodeStyle) {
            ((DocSyncedCodeStyle)codeStyle).syncToDocument(baseDocument);
        }
    }

    private static final class StackItem {
        private final boolean braceless;
        private final OffsetRange range;

        private StackItem(boolean bl, OffsetRange offsetRange) {
            this.braceless = bl;
            this.range = offsetRange;
        }

        public String toString() {
            return "StackItem[" + this.braceless + "," + this.range + "]";
        }
    }

    private static final class DocSyncedCodeStyle
    extends CodeStyle {
        private int indentSize = 4;
        private int continuationIndentSize = 4;
        private int rightMargin = 80;
        private EditorKit kit;

        private DocSyncedCodeStyle() {
            super(null);
        }

        private EditorKit getEditorKit() {
            if (this.kit == null) {
                this.kit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/xml")).lookup(EditorKit.class);
            }
            return this.kit;
        }

        private Integer getSpacesPerTab() {
            Integer n = (Integer)Settings.getValue(this.getEditorKit().getClass(), (String)"spaces-per-tab");
            return n;
        }

        public void syncToDocument(BaseDocument baseDocument) {
            Integer n = this.getSpacesPerTab();
            int n2 = n;
            if (n2 <= 0) {
                n2 = 4;
            }
            this.indentSize = this.continuationIndentSize = n2;
        }

        public int getIndentSize() {
            return this.indentSize;
        }

        public int getContinuationIndentSize() {
            return this.continuationIndentSize;
        }

        public boolean reformatComments() {
            return false;
        }

        public boolean indentHtml() {
            return false;
        }

        public int getRightMargin() {
            return this.rightMargin;
        }
    }
}

