/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.impl.common.DDProviderDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.api.Transaction;
import org.netbeans.modules.j2ee.sun.ddloaders.api.TransactionSupport;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public abstract class DDMultiViewDataObject
extends XmlMultiViewDataObject
implements DDProviderDataObject,
TransactionSupport {
    private WeakReference transactionReference = null;
    private static final int HANDLE_UNPARSABLE_TIMEOUT = 2000;
    private ModelSynchronizer modelSynchronizer = new ModelSynchronizer(this);

    public DDMultiViewDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    public void modelUpdatedFromUI() {
        this.modelSynchronizer.requestUpdateData();
    }

    public XmlMultiViewDataSynchronizer getModelSynchronizer() {
        return this.modelSynchronizer;
    }

    public void checkParseable() {
        if (!this.isDocumentParseable()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DDMultiViewDataObject.class, (String)"TXT_DocumentUnparsable", (Object)this.getPrimaryFile().getNameExt()), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DDMultiViewDataObject.this.goToXmlView();
                }
            });
        }
    }

    public InputStream createInputStream() {
        return this.getDataCache().createInputStream();
    }

    public Reader createReader() throws IOException {
        return this.getDataCache().createReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeModel(RootInterface rootInterface) throws IOException {
        if (this.transactionReference != null && this.transactionReference.get() != null) {
            return;
        }
        FileLock fileLock = this.waitForLock();
        if (fileLock == null) {
            return;
        }
        try {
            if (((ModelSynchronizer)this.getModelSynchronizer()).mayUpdateData(true)) {
                this.writeModel(rootInterface, fileLock);
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public void writeModel(RootInterface rootInterface, FileLock fileLock) {
        ModelSynchronizer modelSynchronizer = (ModelSynchronizer)this.getModelSynchronizer();
        this.modelSynchronizer.getReloadTask().cancel();
        ((RootInterface)modelSynchronizer.getModel()).merge((CommonDDBean)rootInterface, 3);
        modelSynchronizer.updateData(fileLock, false);
    }

    public FileLock getDataLock() {
        try {
            return this.getModelSynchronizer().takeLock();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    protected abstract boolean isModelCreated();

    protected abstract void parseDocument() throws IOException;

    protected abstract void validateDocument() throws IOException;

    protected String generateDocumentFromModel(RootInterface rootInterface) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            rootInterface.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString("UTF8");
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (IllegalStateException illegalStateException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
        }
        return byteArrayOutputStream.toString();
    }

    protected abstract RootInterface getDDModel();

    protected abstract boolean isDocumentParseable();

    public Transaction openTransaction() {
        final XmlMultiViewDataSynchronizer.Transaction transaction = this.getModelSynchronizer().openTransaction();
        if (transaction == null) {
            return null;
        }
        Transaction transaction2 = new Transaction(){

            public void rollback() {
                transaction.rollback();
                DDMultiViewDataObject.this.transactionReference = null;
            }

            public void commit() throws IOException {
                transaction.commit();
                DDMultiViewDataObject.this.transactionReference = null;
            }
        };
        this.transactionReference = new WeakReference<2>(transaction2);
        return transaction2;
    }

    public void notifyError(Exception exception) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        private long handleUnparseableTimeout;
        private Boolean overwriteUnparseable;

        public ModelSynchronizer(XmlMultiViewDataObject xmlMultiViewDataObject) {
            super(xmlMultiViewDataObject, 300);
            this.handleUnparseableTimeout = 0L;
            this.overwriteUnparseable = Boolean.TRUE;
            this.handleUnparseableTimeout = 0L;
            this.overwriteUnparseable = Boolean.TRUE;
        }

        protected boolean mayUpdateData(boolean bl) {
            long l;
            if (DDMultiViewDataObject.this.isDocumentParseable()) {
                return true;
            }
            if (!bl) {
                return false;
            }
            if (this.handleUnparseableTimeout != -1L && (l = new Date().getTime()) > this.handleUnparseableTimeout) {
                this.handleUnparseableTimeout = -1L;
                Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                    public void run() {
                        String string = NbBundle.getMessage(XmlMultiViewDataObject.class, (String)"TXT_OverwriteUnparsableDocument", (Object)DDMultiViewDataObject.this.getPrimaryFile().getNameExt());
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                        ModelSynchronizer.this.overwriteUnparseable = confirmation.getValue() == NotifyDescriptor.YES_OPTION;
                        ModelSynchronizer.this.handleUnparseableTimeout = new Date().getTime() + 2000L;
                    }
                });
            }
            return this.overwriteUnparseable;
        }

        public void updateData(FileLock fileLock, boolean bl) {
            super.updateData(fileLock, bl);
            try {
                DDMultiViewDataObject.this.validateDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            }
        }

        protected void updateDataFromModel(Object object, FileLock fileLock, boolean bl) {
            String string = DDMultiViewDataObject.this.generateDocumentFromModel((RootInterface)object);
            try {
                DDMultiViewDataObject.this.getDataCache().setData(fileLock, string, bl);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        protected Object getModel() {
            return DDMultiViewDataObject.this.getDDModel();
        }

        protected void reloadModelFromData() {
            try {
                DDMultiViewDataObject.this.parseDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }
}

