/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.repository.queue.BaseQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueQueue<K, V>
extends BaseQueue {
    protected Map<K, Entry> map = new HashMap<K, Entry>();
    protected boolean active = true;

    public KeyValueQueue() {
        this.queue = new BaseQueue.Queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(K k, V v) {
        if (this.needsTrace()) {
            System.err.printf("%s: addLast %s\n", this.getTraceName(), k.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.map.get(k);
            if (entry == null) {
                this.doAddLast(k, v);
                if (this.needsTrace()) {
                    System.err.printf("%s: added last %s\n", this.getTraceName(), k.toString());
                }
            } else {
                this.doReplaceAddLast(k, v, entry);
                if (this.needsTrace()) {
                    System.err.printf("%s: replaced last %s\n", this.getTraceName(), k.toString());
                }
            }
            this.lock.notifyAll();
        }
    }

    protected Entry doAddLast(K k, V v) {
        Entry entry = this.createEntry(k, v);
        this.map.put(k, entry);
        this.queue.addLast(entry);
        return entry;
    }

    protected void doReplaceAddLast(K k, V v, Entry entry) {
        entry.value = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(K k, V v) {
        if (this.needsTrace()) {
            System.err.printf("%s: addFirst %s\n", this.getTraceName(), k.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.map.get(k);
            if (entry == null) {
                this.doAddFirst(k, v);
                if (this.needsTrace()) {
                    System.err.printf("%s: added first %s\n", this.getTraceName(), k.toString());
                }
            } else {
                this.doReplaceAddFirst(k, v, entry);
                if (this.needsTrace()) {
                    System.err.printf("%s: replaced first %s\n", this.getTraceName(), k.toString());
                }
            }
            this.lock.notifyAll();
        }
    }

    protected Entry createEntry(K k, V v) {
        return new Entry(k, v);
    }

    protected Entry doAddFirst(K k, V v) {
        Entry entry = this.createEntry(k, v);
        this.map.put(k, entry);
        this.queue.addFirst(entry);
        return entry;
    }

    protected void doReplaceAddFirst(K k, V v, Entry entry) {
        entry.value = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry poll() throws InterruptedException {
        if (this.needsTrace()) {
            System.err.printf("%s: Polling...\n", this.getTraceName());
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            try {
                Entry entry2 = (Entry)this.queue.poll();
                if (entry2 != null) {
                    this.doPostPoll(entry2);
                    if (this.needsTrace()) {
                        System.err.printf("    %s: polling -> %s\n", this.getTraceName(), entry2.getKey());
                    }
                }
                entry = entry2;
                this.lock.notifyAll();
            }
            catch (Throwable throwable) {
                this.lock.notifyAll();
                throw throwable;
            }
            return entry;
        }
    }

    protected void doPostPoll(Entry entry) {
        this.map.remove(entry.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K k) {
        if (this.needsTrace()) {
            System.err.printf("%s: Removing %s\n", this.getTraceName(), k);
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry = this.map.remove(k);
            if (entry != null) {
                this.queue.remove(entry);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.active && !this.isReady()) {
                if (this.needsTrace()) {
                    System.err.printf("%s: waitReady() ...\n", this.getTraceName());
                }
                this.lock.wait();
                if (!this.needsTrace()) continue;
                System.err.printf("%s: waiting finished\n", this.getTraceName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disposable() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.active = false;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Entry
    extends BaseQueue.AbstractEntry {
        private K key;
        private V value;

        protected Entry(K k, V v) {
            assert (k != null);
            assert (v != null);
            this.key = k;
            this.value = v;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

