/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryCache {
    private final Map<Key, Object> cache = new ConcurrentHashMap<Key, Object>(1024);
    private Lock refQueueLock = new ReentrantLock();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private int readCnt = 0;
    private int readHitCnt = 0;

    public void hang(Key key, Persistent persistent) {
        this.cache.put(key, persistent);
    }

    public void put(Key key, Persistent persistent, boolean bl) {
        this.cache.put(key, new SoftValue(persistent, key, this.refQueue));
        if (!bl) {
            this.processQueue();
        }
    }

    public Persistent get(Key key) {
        ++this.readCnt;
        Object object = this.cache.get(key);
        if (object instanceof Persistent) {
            ++this.readHitCnt;
            return (Persistent)object;
        }
        if (object instanceof SoftReference) {
            Persistent persistent = (Persistent)((SoftReference)object).get();
            if (persistent != null) {
                ++this.readHitCnt;
            }
            return persistent;
        }
        return null;
    }

    public void remove(Key key) {
        this.cache.remove(key);
    }

    public void clearSoftRefs() {
        this.processQueue();
        HashSet<Key> hashSet = new HashSet<Key>(this.cache.keySet());
        for (Key key : hashSet) {
            Object object = this.cache.get(key);
            if (object == null || object instanceof Persistent) continue;
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        if (this.refQueueLock.tryLock()) {
            try {
                SoftValue softValue;
                while ((softValue = (SoftValue)this.refQueue.poll()) != null) {
                    Object object = this.cache.get(softValue.key);
                    if (object == null || !(object instanceof SoftReference) || ((SoftReference)object).get() != null) continue;
                    this.cache.remove(softValue.key);
                }
            }
            finally {
                this.refQueueLock.unlock();
            }
        }
    }

    public Collection<Pair<Key, Persistent>> clearHungObjects() {
        this.processQueue();
        ArrayList<Pair<Key, Persistent>> arrayList = new ArrayList<Pair<Key, Persistent>>();
        Iterator<Map.Entry<Key, Object>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Key, Object> entry = iterator.next();
            if (!(entry.getValue() instanceof Persistent)) continue;
            arrayList.add(new Pair<Key, Persistent>(entry.getKey(), (Persistent)entry.getValue()));
            iterator.remove();
        }
        return arrayList;
    }

    public void printStatistics(String string) {
        int n = this.readCnt == 0 ? 0 : this.readHitCnt * 100 / this.readCnt;
        System.out.printf("\n\nMemory cache statistics %s: %d reads,  %d hits (%d%%)\n\n", string, this.readCnt, this.readHitCnt, n);
    }

    private static class SoftValue
    extends SoftReference {
        private final Object key;

        private SoftValue(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.key = object2;
        }
    }
}

